/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.rd.animation.data.Value;
import com.rd.animation.data.type.ColorAnimationValue;
import com.rd.draw.data.Indicator;
import com.rd.draw.drawer.type.BaseDrawer;

public class ColorDrawer
extends BaseDrawer {
    public ColorDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
    }

    public void draw(@NonNull Canvas canvas, @NonNull Value value, int position, int coordinateX, int coordinateY) {
        if (!(value instanceof ColorAnimationValue)) {
            return;
        }
        ColorAnimationValue v = (ColorAnimationValue)value;
        float radius = this.indicator.getRadius();
        int color = this.indicator.getSelectedColor();
        int selectedPosition = this.indicator.getSelectedPosition();
        int selectingPosition = this.indicator.getSelectingPosition();
        int lastSelectedPosition = this.indicator.getLastSelectedPosition();
        if (this.indicator.isInteractiveAnimation()) {
            if (position == selectingPosition) {
                color = v.getColor();
            } else if (position == selectedPosition) {
                color = v.getColorReverse();
            }
        } else if (position == selectedPosition) {
            color = v.getColor();
        } else if (position == lastSelectedPosition) {
            color = v.getColorReverse();
        }
        this.paint.setColor(color);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, radius, this.paint);
    }
}

