/*
 * Decompiled with CFR 0.152.
 */
package com.rd.draw.drawer.type;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import com.rd.animation.type.AnimationType;
import com.rd.draw.data.Indicator;
import com.rd.draw.drawer.type.BaseDrawer;

public class BasicDrawer
extends BaseDrawer {
    private Paint strokePaint = new Paint();

    public BasicDrawer(@NonNull Paint paint, @NonNull Indicator indicator) {
        super(paint, indicator);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeWidth((float)indicator.getStroke());
    }

    public void draw(@NonNull Canvas canvas, int position, boolean isSelectedItem, int coordinateX, int coordinateY) {
        Paint paint;
        float radius = this.indicator.getRadius();
        int strokePx = this.indicator.getStroke();
        float scaleFactor = this.indicator.getScaleFactor();
        int selectedColor = this.indicator.getSelectedColor();
        int unselectedColor = this.indicator.getUnselectedColor();
        int selectedPosition = this.indicator.getSelectedPosition();
        AnimationType animationType = this.indicator.getAnimationType();
        if (animationType == AnimationType.SCALE && !isSelectedItem) {
            radius *= scaleFactor;
        } else if (animationType == AnimationType.SCALE_DOWN && isSelectedItem) {
            radius *= scaleFactor;
        }
        int color = unselectedColor;
        if (position == selectedPosition) {
            color = selectedColor;
        }
        if (animationType == AnimationType.FILL && position != selectedPosition) {
            paint = this.strokePaint;
            paint.setStrokeWidth((float)strokePx);
        } else {
            paint = this.paint;
        }
        paint.setColor(color);
        canvas.drawCircle((float)coordinateX, (float)coordinateY, radius, paint);
    }
}

