/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare.configuration;

import eu.roboflax.cloudflare.CloudflareAccess;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class CloudflareConfig {
    private String xAuthKey;
    private String xAuthEmail;
    private String xAuthToken;
    private ExecutorService threadPool;
    private Integer maxThreads;

    public CloudflareConfig(String xAuthKey, String xAuthEmail) {
        this.xAuthKey = xAuthKey;
        this.xAuthEmail = xAuthEmail;
    }

    public CloudflareConfig(String xAuthKey, String xAuthEmail, @Nullable Integer maxThreads) {
        this(xAuthKey, xAuthEmail);
        this.maxThreads = maxThreads;
    }

    public CloudflareConfig(String xAuthKey, String xAuthEmail, @Nullable ExecutorService threadPool) {
        this(xAuthKey, xAuthEmail);
        this.threadPool = threadPool;
    }

    public CloudflareConfig(String xAuthToken) {
        this.xAuthToken = xAuthToken;
    }

    public CloudflareConfig(String xAuthToken, @Nullable Integer maxThreads) {
        this(xAuthToken);
        this.maxThreads = maxThreads;
    }

    public CloudflareConfig(String xAuthToken, @Nullable ExecutorService threadPool) {
        this(xAuthToken);
        this.threadPool = threadPool;
    }

    public CloudflareAccess createAccess() {
        if (this.xAuthToken != null) {
            if (this.threadPool != null) {
                return new CloudflareAccess(this.xAuthToken, this.threadPool);
            }
            if (this.maxThreads != null) {
                return new CloudflareAccess(this.xAuthToken, this.maxThreads);
            }
            return new CloudflareAccess(this.xAuthToken);
        }
        if (this.threadPool != null) {
            return new CloudflareAccess(this.xAuthKey, this.xAuthEmail, this.threadPool);
        }
        if (this.maxThreads != null) {
            return new CloudflareAccess(this.xAuthKey, this.xAuthEmail, this.maxThreads);
        }
        return new CloudflareAccess(this.xAuthKey, this.xAuthEmail);
    }

    public String getXAuthKey() {
        return this.xAuthKey;
    }

    public String getXAuthEmail() {
        return this.xAuthEmail;
    }

    public String getXAuthToken() {
        return this.xAuthToken;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setXAuthKey(String xAuthKey) {
        this.xAuthKey = xAuthKey;
    }

    public void setXAuthEmail(String xAuthEmail) {
        this.xAuthEmail = xAuthEmail;
    }

    public void setXAuthToken(String xAuthToken) {
        this.xAuthToken = xAuthToken;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }
}

