/*
 * Decompiled with CFR 0.152.
 */
package eu.roboflax.cloudflare;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.roboflax.cloudflare.CloudflareAccess;
import eu.roboflax.cloudflare.CloudflareCallback;
import eu.roboflax.cloudflare.CloudflareResponse;
import eu.roboflax.cloudflare.Pagination;
import eu.roboflax.cloudflare.constants.Category;
import eu.roboflax.cloudflare.http.HttpMethod;
import io.joshworks.restclient.http.HttpResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;

public class CloudflareRequest {
    private CloudflareAccess cloudflareAccess;
    private HttpMethod httpMethod;
    private String additionalPath;
    private List<String> orderedIdentifiers = Lists.newArrayList();
    private Map<String, Object> queryStrings = Maps.newHashMap();
    private JsonObject body = new JsonObject();
    private Pair<HttpResponse<String>, JsonObject> response;
    public static final String ERROR_INVALID_ADDITIONAL_PATH = "you have to specify the additional path";
    public static final String ERROR_INVALID_HTTP_METHOD = "you have to specify the http method";
    public static final String ERROR_INVALID_BODY = "invalid body";
    public static final String ERROR_INVALID_QUERY_STRING = "invalid query string";
    public static final String ERROR_INVALID_IDENTIFIER = "invalid identifier";
    public static final String ERROR_INVALID_PAGINATION = "invalid pagination";
    public static final String ERROR_RESULT_IS_JSON_OBJECT = "Property 'result' is not a json array, because it is a json object use asObject() instead of asObjectList().";
    public static final String ERROR_RESULT_IS_JSON_ARRAY = "Property 'result' is not a json object, because it is a json array use asObjectList() instead of asObject().";
    public static final String ERROR_PARSING_JSON = "Could not parse returned text as json.";
    public static final String ERROR_CLOUDFLARE_FAILURE = "Cloudflare was unable to perform your request and couldn't determine the result of the requested/passed information. Maybe you built the request wrong or something different.";

    public CloudflareRequest() {
    }

    public CloudflareRequest(HttpMethod httpMethod) {
        this.httpMethod(httpMethod);
    }

    public CloudflareRequest(String additionalPath) {
        this.additionalPath(additionalPath);
    }

    public CloudflareRequest(CloudflareAccess cloudflareAccess) {
        this.cloudflareAccess(cloudflareAccess);
    }

    public CloudflareRequest(HttpMethod httpMethod, CloudflareAccess cloudflareAccess) {
        this.httpMethod(httpMethod).cloudflareAccess(cloudflareAccess);
    }

    public CloudflareRequest(HttpMethod httpMethod, String additionalPath) {
        this.httpMethod(httpMethod).additionalPath(additionalPath);
    }

    public CloudflareRequest(String additionalPath, CloudflareAccess cloudflareAccess) {
        this.additionalPath(additionalPath).cloudflareAccess(cloudflareAccess);
    }

    public CloudflareRequest(HttpMethod httpMethod, String additionalPath, CloudflareAccess cloudflareAccess) {
        this.httpMethod(httpMethod).additionalPath(additionalPath).cloudflareAccess(cloudflareAccess);
    }

    public CloudflareRequest(Category category, CloudflareAccess cloudflareAccess) {
        this.category(category).cloudflareAccess(cloudflareAccess);
    }

    public CloudflareRequest(Category category) {
        this.category(category);
    }

    public static CloudflareRequest newRequest() {
        return new CloudflareRequest();
    }

    public static CloudflareRequest newRequest(HttpMethod httpMethod) {
        return new CloudflareRequest(httpMethod);
    }

    public static CloudflareRequest newRequest(String additionalPath) {
        return new CloudflareRequest(additionalPath);
    }

    public static CloudflareRequest newRequest(CloudflareAccess cloudflareAccess) {
        return new CloudflareRequest(cloudflareAccess);
    }

    public static CloudflareRequest newRequest(HttpMethod httpMethod, String additionalPath) {
        return new CloudflareRequest(httpMethod, additionalPath);
    }

    public static CloudflareRequest newRequest(String additionalPath, CloudflareAccess cloudflareAccess) {
        return new CloudflareRequest(additionalPath, cloudflareAccess);
    }

    public static CloudflareRequest newRequest(HttpMethod httpMethod, CloudflareAccess cloudflareAccess) {
        return new CloudflareRequest(httpMethod, cloudflareAccess);
    }

    public static CloudflareRequest newRequest(HttpMethod httpMethod, String additionalPath, CloudflareAccess cloudflareAccess) {
        return new CloudflareRequest(httpMethod, additionalPath, cloudflareAccess);
    }

    public static CloudflareRequest newRequest(Category category) {
        return new CloudflareRequest(category);
    }

    public static CloudflareRequest newRequest(Category category, CloudflareAccess cloudflareAccess) {
        return new CloudflareRequest(category, cloudflareAccess);
    }

    public CloudflareRequest additionalPath(String additionalPath) {
        this.additionalPath = CloudflareRequest.validAdditionalPath((String)Preconditions.checkNotNull((Object)additionalPath));
        return this;
    }

    public CloudflareRequest httpMethod(HttpMethod httpMethod) {
        this.httpMethod = (HttpMethod)((Object)Preconditions.checkNotNull((Object)((Object)httpMethod)));
        return this;
    }

    public CloudflareRequest category(Category category) {
        Preconditions.checkNotNull((Object)((Object)category));
        this.httpMethod(category.getHttpMethod()).additionalPath(category.getAdditionalPath());
        return this;
    }

    public CloudflareRequest cloudflareAccess(CloudflareAccess cloudflareAccess) {
        this.cloudflareAccess = (CloudflareAccess)Preconditions.checkNotNull((Object)cloudflareAccess);
        return this;
    }

    public CloudflareRequest identifiers(String ... orderedIdentifiers) {
        Preconditions.checkNotNull((Object)orderedIdentifiers, (Object)ERROR_INVALID_IDENTIFIER);
        if (Lists.newArrayList((Object[])orderedIdentifiers).contains(null)) {
            throw new NullPointerException(ERROR_INVALID_IDENTIFIER);
        }
        Collections.addAll(this.orderedIdentifiers, orderedIdentifiers);
        return this;
    }

    public CloudflareRequest queryString(String parameter, Object value) {
        this.queryStrings.put((String)Preconditions.checkNotNull((Object)parameter, (Object)ERROR_INVALID_QUERY_STRING), Preconditions.checkNotNull((Object)value, (Object)ERROR_INVALID_QUERY_STRING));
        return this;
    }

    public CloudflareRequest queryString(Map<String, Object> parameterValue) {
        Preconditions.checkNotNull(parameterValue, (Object)ERROR_INVALID_QUERY_STRING);
        for (Map.Entry<String, Object> e : parameterValue.entrySet()) {
            this.queryString(e.getKey(), e.getValue());
        }
        return this;
    }

    public CloudflareRequest queryString(String parameter, Collection<?> values) {
        Preconditions.checkNotNull((Object)parameter, (Object)ERROR_INVALID_QUERY_STRING);
        Preconditions.checkNotNull(values, (Object)ERROR_INVALID_QUERY_STRING);
        for (Object value : values) {
            this.queryString(parameter, value);
        }
        return this;
    }

    public CloudflareRequest body(JsonObject wholeBody) {
        this.body = (JsonObject)Preconditions.checkNotNull((Object)wholeBody);
        return this;
    }

    public CloudflareRequest body(JsonElement wholeBody) {
        this.body(((JsonElement)Preconditions.checkNotNull((Object)wholeBody)).getAsJsonObject());
        return this;
    }

    public CloudflareRequest body(String wholeBody) {
        this.body(new JsonParser().parse((String)Preconditions.checkNotNull((Object)wholeBody)));
        return this;
    }

    public CloudflareRequest body(String property, String value) {
        this.body.addProperty((String)Preconditions.checkNotNull((Object)property, (Object)ERROR_INVALID_BODY), (String)Preconditions.checkNotNull((Object)value, (Object)ERROR_INVALID_BODY));
        return this;
    }

    public CloudflareRequest body(String property, Number value) {
        this.body.addProperty((String)Preconditions.checkNotNull((Object)property, (Object)ERROR_INVALID_BODY), (Number)Preconditions.checkNotNull((Object)value, (Object)ERROR_INVALID_BODY));
        return this;
    }

    public CloudflareRequest body(String property, Boolean value) {
        this.body.addProperty((String)Preconditions.checkNotNull((Object)property, (Object)ERROR_INVALID_BODY), (Boolean)Preconditions.checkNotNull((Object)value, (Object)ERROR_INVALID_BODY));
        return this;
    }

    public CloudflareRequest body(String property, Character value) {
        this.body.addProperty((String)Preconditions.checkNotNull((Object)property, (Object)ERROR_INVALID_BODY), (Character)Preconditions.checkNotNull((Object)value, (Object)ERROR_INVALID_BODY));
        return this;
    }

    public CloudflareRequest body(String property, JsonElement value) {
        this.body.add((String)Preconditions.checkNotNull((Object)property, (Object)ERROR_INVALID_BODY), (JsonElement)Preconditions.checkNotNull((Object)value, (Object)ERROR_INVALID_BODY));
        return this;
    }

    public CloudflareRequest pagination(Pagination pagination) {
        this.queryString(((Pagination)Preconditions.checkNotNull((Object)pagination, (Object)ERROR_INVALID_PAGINATION)).getAsQueryStringsMap());
        return this;
    }

    private HttpResponse<String> sendRequest() {
        switch ((HttpMethod)((Object)Preconditions.checkNotNull((Object)((Object)this.httpMethod), (Object)ERROR_INVALID_HTTP_METHOD))) {
            case GET: {
                return this.cloudflareAccess.getRestClient().get(this.categoryPath()).queryString(this.queryStrings).asString();
            }
            case POST: {
                return this.cloudflareAccess.getRestClient().post(this.categoryPath()).queryString(this.queryStrings).body(this.body.toString()).asString();
            }
            case DELETE: {
                return this.cloudflareAccess.getRestClient().delete(this.categoryPath()).queryString(this.queryStrings).body(this.body.toString()).asString();
            }
            case PUT: {
                return this.cloudflareAccess.getRestClient().put(this.categoryPath()).queryString(this.queryStrings).body(this.body.toString()).asString();
            }
            case PATCH: {
                return this.cloudflareAccess.getRestClient().patch(this.categoryPath()).queryString(this.queryStrings).body(this.body.toString()).asString();
            }
        }
        throw new IllegalStateException("Should never happen because other http methods are blocked.");
    }

    private Pair<HttpResponse<String>, JsonObject> response() {
        if (this.response == null) {
            HttpResponse<String> httpResponse = this.sendRequest();
            JsonElement parsed = new JsonParser().parse((String)httpResponse.getBody());
            if (parsed.isJsonNull()) {
                throw new IllegalStateException(ERROR_PARSING_JSON);
            }
            this.response = Pair.of(httpResponse, (Object)parsed.getAsJsonObject());
        }
        return this.response;
    }

    public CloudflareResponse<Void> asVoid() {
        HttpResponse httpResponse = (HttpResponse)this.response().getLeft();
        JsonObject json = (JsonObject)this.response().getRight();
        return new CloudflareResponse<Object>(json, null, httpResponse.isSuccessful(), httpResponse.getStatus(), httpResponse.getStatusText());
    }

    public void asVoid(Consumer<CloudflareResponse<Void>> consumer) {
        consumer.accept(this.asVoid());
    }

    public void asVoidAsync(CloudflareCallback<CloudflareResponse<Void>> callback) {
        this.asyncCallback(callback, this::asVoid);
    }

    public void asVoid(CloudflareCallback<CloudflareResponse<Void>> callback) {
        this.syncCallback(callback, this::asVoid);
    }

    public CompletableFuture<CloudflareResponse<Void>> asVoidAsync() {
        return CompletableFuture.supplyAsync(this::asVoid, this.getCloudflareAccess().getThreadPool());
    }

    public CloudflareResponse<Void> send() {
        return this.asVoid();
    }

    public CompletableFuture<CloudflareResponse<Void>> sendAsync() {
        return this.asVoidAsync();
    }

    public void send(Consumer<CloudflareResponse<Void>> consumer) {
        consumer.accept(this.asVoid());
    }

    public void sendAsync(CloudflareCallback<CloudflareResponse<Void>> callback) {
        this.asyncCallback(callback, this::asVoid);
    }

    public void send(CloudflareCallback<CloudflareResponse<Void>> callback) {
        this.syncCallback(callback, this::asVoid);
    }

    public <T> CloudflareResponse<T> asObject(Class<T> objectType) {
        HttpResponse httpResponse = (HttpResponse)this.response().getLeft();
        JsonObject json = (JsonObject)this.response().getRight();
        if (json.get("result").isJsonObject()) {
            return new CloudflareResponse<Object>(json, CloudflareAccess.getGson().fromJson((JsonElement)json.getAsJsonObject("result"), objectType), httpResponse.isSuccessful(), httpResponse.getStatus(), httpResponse.getStatusText());
        }
        if (json.get("result").isJsonArray()) {
            throw new IllegalStateException(ERROR_RESULT_IS_JSON_ARRAY);
        }
        return new CloudflareResponse<Object>(json, null, httpResponse.isSuccessful(), httpResponse.getStatus(), httpResponse.getStatusText());
    }

    public <T> CompletableFuture<CloudflareResponse<T>> asObjectAsync(Class<T> objectType) {
        return CompletableFuture.supplyAsync(() -> this.asObject(objectType), this.getCloudflareAccess().getThreadPool());
    }

    public <T> void asObject(Consumer<CloudflareResponse<T>> consumer, Class<T> objectType) {
        consumer.accept(this.asObject(objectType));
    }

    public <T> void asObjectAsync(CloudflareCallback<CloudflareResponse<T>> callback, Class<T> objectType) {
        this.asyncCallback(callback, () -> this.asObject(objectType));
    }

    public <T> void asObject(CloudflareCallback<CloudflareResponse<T>> callback, Class<T> objectType) {
        this.syncCallback(callback, () -> this.asObject(objectType));
    }

    public <T> CloudflareResponse<List<T>> asObjectList(Class<T> objectType) {
        JsonObject json = (JsonObject)this.response().getRight();
        HttpResponse httpResponse = (HttpResponse)this.response().getLeft();
        if (json.get("result").isJsonArray()) {
            return new CloudflareResponse<List<T>>(json, this.toListOfObjects(json.getAsJsonArray("result"), objectType), httpResponse.isSuccessful(), httpResponse.getStatus(), httpResponse.getStatusText());
        }
        if (json.get("result").isJsonObject()) {
            throw new IllegalStateException(ERROR_RESULT_IS_JSON_OBJECT);
        }
        return new CloudflareResponse<Object>(json, null, httpResponse.isSuccessful(), httpResponse.getStatus(), httpResponse.getStatusText());
    }

    public <T> CompletableFuture<CloudflareResponse<List<T>>> asObjectListAsync(Class<T> objectType) {
        return CompletableFuture.supplyAsync(() -> this.asObjectList(objectType), this.getCloudflareAccess().getThreadPool());
    }

    public <T> void asObjectList(Consumer<CloudflareResponse<List<T>>> consumer, Class<T> objectType) {
        consumer.accept(this.asObjectList(objectType));
    }

    public <T> void asObjectListAsync(CloudflareCallback<CloudflareResponse<List<T>>> callback, Class<T> objectType) {
        this.asyncCallback(callback, () -> this.asObjectList(objectType));
    }

    public <T> void asObjectList(CloudflareCallback<CloudflareResponse<List<T>>> callback, Class<T> objectType) {
        this.syncCallback(callback, () -> this.asObjectList(objectType));
    }

    public <T> CloudflareResponse<T> asObjectOrObjectList(Class<T> objectType) {
        JsonObject json = (JsonObject)this.response().getRight();
        HttpResponse httpResponse = (HttpResponse)this.response().getLeft();
        Object object = json.get("result").isJsonArray() ? this.toListOfObjects(json.getAsJsonArray("result"), objectType) : (json.get("result").isJsonObject() ? CloudflareAccess.getGson().fromJson((JsonElement)json.getAsJsonObject("result"), objectType) : null);
        return new CloudflareResponse<List<T>>(json, object, httpResponse.isSuccessful(), httpResponse.getStatus(), httpResponse.getStatusText());
    }

    public <T> CompletableFuture<CloudflareResponse<T>> asObjectOrObjectListAsync(Class<T> objectType) {
        return CompletableFuture.supplyAsync(() -> this.asObjectOrObjectList(objectType), this.getCloudflareAccess().getThreadPool());
    }

    public <T> void asObjectOrObjectList(Consumer<CloudflareResponse<T>> consumer, Class<T> objectType) {
        consumer.accept(this.asObjectOrObjectList(objectType));
    }

    public <T> void asObjectOrObjectListAsync(CloudflareCallback<CloudflareResponse<T>> callback, Class<T> objectType) {
        this.asyncCallback(callback, () -> this.asObjectOrObjectList(objectType));
    }

    public <T> void asObjectOrObjectList(CloudflareCallback<CloudflareResponse<T>> callback, Class<T> objectType) {
        this.syncCallback(callback, () -> this.asObjectOrObjectList(objectType));
    }

    private <T> void runCallback(CloudflareCallback<CloudflareResponse<T>> callback, Callable<CloudflareResponse<T>> getResponse) {
        Throwable throwable;
        HttpResponse httpResponse = (HttpResponse)this.response().getLeft();
        JsonObject json = (JsonObject)this.response().getRight();
        try {
            CloudflareResponse<T> response = getResponse.call();
            if (!response.isSuccessful()) {
                throw new IllegalStateException(ERROR_CLOUDFLARE_FAILURE);
            }
            try {
                callback.onSuccess(response);
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
            return;
        }
        catch (ExecutionException e) {
            throwable = e.getCause();
        }
        catch (Error | Exception e) {
            throwable = e;
        }
        HashMap errors = Maps.newHashMap();
        for (JsonElement e : json.getAsJsonArray("errors")) {
            JsonObject o = e.getAsJsonObject();
            errors.put(o.get("code").getAsInt(), o.get("message").getAsString());
        }
        callback.onFailure(throwable, httpResponse.getStatus(), httpResponse.getStatusText(), errors);
    }

    private <T> void syncCallback(CloudflareCallback<CloudflareResponse<T>> callback, Callable<CloudflareResponse<T>> getResponse) {
        this.runCallback(callback, getResponse);
    }

    private <T> void asyncCallback(CloudflareCallback<CloudflareResponse<T>> callback, Callable<CloudflareResponse<T>> getResponse) {
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)this.getCloudflareAccess().getThreadPool()).submit(getResponse);
        future.addListener(() -> this.runCallback(callback, () -> future.get()), (Executor)this.getCloudflareAccess().getThreadPool());
    }

    private <T> List<T> toListOfObjects(JsonArray jsonArray, final Class<T> objectType) {
        return (List)CloudflareAccess.getGson().fromJson((JsonElement)jsonArray, (Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{objectType};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        });
    }

    private String categoryPath() {
        String additionalCategoryPath = (String)Preconditions.checkNotNull((Object)this.additionalPath, (Object)ERROR_INVALID_ADDITIONAL_PATH);
        for (int place = 1; place <= this.orderedIdentifiers.size(); ++place) {
            additionalCategoryPath = additionalCategoryPath.replace("{id-" + place + "}", this.orderedIdentifiers.get(place - 1));
        }
        return additionalCategoryPath;
    }

    private static String validAdditionalPath(String additionalPath) {
        if (additionalPath.startsWith("/")) {
            additionalPath = additionalPath.substring(1);
        }
        return additionalPath;
    }

    public CloudflareAccess getCloudflareAccess() {
        return this.cloudflareAccess;
    }
}

