/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.termgenerator;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.rml.StrictMode;
import be.ugent.rml.functions.FunctionUtils;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import be.ugent.rml.termgenerator.TermGenerator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedNodeGenerator
extends TermGenerator {
    private static final Logger logger = LoggerFactory.getLogger(NamedNodeGenerator.class);
    private final String baseIRI;
    private final StrictMode strictMode;

    public NamedNodeGenerator(SingleRecordFunctionExecutor functionExecutor, String baseIRI, StrictMode strictMode) {
        super(functionExecutor);
        this.strictMode = strictMode;
        this.baseIRI = baseIRI == null ? "" : baseIRI;
    }

    @Override
    public List<Term> generate(Record record) throws Exception {
        List<String> objectStrings = FunctionUtils.functionObjectToList(this.functionExecutor.execute(record));
        ArrayList<Term> objects = new ArrayList<Term>();
        if (!objectStrings.isEmpty()) {
            for (String object : objectStrings) {
                Object iri = object;
                if (object.indexOf(58) < 0) {
                    iri = this.baseIRI + object;
                }
                if (this.strictMode.equals((Object)StrictMode.STRICT)) {
                    try {
                        new ParsedIRI((String)iri);
                    }
                    catch (Exception e) {
                        logger.error("'" + (String)iri + "' is not a valid IRI");
                        throw new Exception("'" + (String)iri + "' is not a valid IRI");
                    }
                } else if (((String)iri).contains(" ")) continue;
                objects.add(new NamedNode((String)iri));
            }
        }
        return objects;
    }
}

