/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml;

import be.ugent.rml.Utils;
import be.ugent.rml.extractor.Extractor;
import be.ugent.rml.extractor.ReferenceExtractor;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MappingOptimizer {
    private final QuadStore rmlStore;

    public MappingOptimizer(QuadStore rmlStore) {
        this.rmlStore = rmlStore;
    }

    public QuadStore optimizeMapping() throws Exception {
        this.renameSameLogicalSource();
        this.eliminateSelfJoins();
        return this.rmlStore;
    }

    private void renameSameLogicalSource() {
        List<Term> logicalSources = Utils.getObjectsFromQuads(this.rmlStore.getQuads(null, new NamedNode("http://w3id.org/rml/logicalSource"), null));
        HashMap logicalSourcesDict = new HashMap();
        for (Term logicalSource : logicalSources) {
            HashSet<Term> allObjects = new HashSet<Term>();
            List<Term> objects = Utils.getObjectsFromQuads(this.rmlStore.getQuads(logicalSource, null, null));
            while (!objects.isEmpty()) {
                Term object = objects.remove(objects.size() - 1);
                if (object.isBNode() || object.isIRI()) {
                    List<Term> newObjects = Utils.getObjectsFromQuads(this.rmlStore.getQuads(object, null, null));
                    if (!newObjects.isEmpty()) {
                        objects.addAll(newObjects);
                        continue;
                    }
                    allObjects.add(object);
                    continue;
                }
                allObjects.add(object);
            }
            Set finalObjectSet = Collections.unmodifiableSet(allObjects);
            if (!logicalSourcesDict.keySet().contains(finalObjectSet)) {
                logicalSourcesDict.put(finalObjectSet, logicalSource);
                continue;
            }
            List<Term> triplesMaps = Utils.getSubjectsFromQuads(this.rmlStore.getQuads(null, new NamedNode("http://w3id.org/rml/logicalSource"), logicalSource));
            for (Term triplesMap : triplesMaps) {
                this.rmlStore.removeQuads(triplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), logicalSource);
                this.rmlStore.addQuad(triplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), (Term)logicalSourcesDict.get(finalObjectSet));
            }
        }
    }

    private void eliminateSelfJoins() {
        List<Quad> refObjectMapsQuads = this.rmlStore.getQuads(null, new NamedNode("http://w3id.org/rml/parentTriplesMap"), null);
        for (Quad refObjectMapQuad : refObjectMapsQuads) {
            Term parentTriplesMap = refObjectMapQuad.getObject();
            Term childObjectMap = refObjectMapQuad.getSubject();
            Term parentLogicalSource = Utils.getObjectsFromQuads(this.rmlStore.getQuads(parentTriplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), null)).get(0);
            Term childPredicateObjectMap = Utils.getSubjectsFromQuads(this.rmlStore.getQuads(null, new NamedNode("http://w3id.org/rml/objectMap"), childObjectMap)).get(0);
            Term childTriplesMap = Utils.getSubjectsFromQuads(this.rmlStore.getQuads(null, new NamedNode("http://w3id.org/rml/predicateObjectMap"), childPredicateObjectMap)).get(0);
            Term childLogicalSource = Utils.getObjectsFromQuads(this.rmlStore.getQuads(childTriplesMap, new NamedNode("http://w3id.org/rml/logicalSource"), null)).get(0);
            if (!childLogicalSource.equals(parentLogicalSource)) continue;
            List<Term> joinConditions = Utils.getObjectsFromQuads(this.rmlStore.getQuads(childObjectMap, new NamedNode("http://w3id.org/rml/joinCondition"), null));
            List<Term> parentSubjectMaps = Utils.getObjectsFromQuads(this.rmlStore.getQuads(parentTriplesMap, new NamedNode("http://w3id.org/rml/subjectMap"), null));
            Term parentSubjectMap = null;
            if (!parentSubjectMaps.isEmpty()) {
                parentSubjectMap = parentSubjectMaps.get(0);
            }
            boolean safeSelfJoinElimination = true;
            if (parentSubjectMap != null && !joinConditions.isEmpty()) {
                ArrayList<String> joinReferences = new ArrayList<String>();
                for (Term joinCondition : joinConditions) {
                    String parent = Utils.getObjectsFromQuads(this.rmlStore.getQuads(joinCondition, new NamedNode("http://w3id.org/rml/parent"), null)).get(0).getValue();
                    String child = Utils.getObjectsFromQuads(this.rmlStore.getQuads(joinCondition, new NamedNode("http://w3id.org/rml/child"), null)).get(0).getValue();
                    if (child.equals(parent)) {
                        joinReferences.add(child);
                        continue;
                    }
                    safeSelfJoinElimination = false;
                }
                if (safeSelfJoinElimination) {
                    List<Term> childPredicateMaps;
                    List<Term> childSubjectMaps;
                    boolean safeTerms = this.hasSafeReferences(parentSubjectMap, joinReferences);
                    if (!safeTerms && (safeTerms = !(childSubjectMaps = Utils.getObjectsFromQuads(this.rmlStore.getQuads(parentTriplesMap, new NamedNode("http://w3id.org/rml/subjectMap"), null))).isEmpty() ? this.hasSafeReferences(childSubjectMaps.get(0), joinReferences) : true) && !(childPredicateMaps = Utils.getObjectsFromQuads(this.rmlStore.getQuads(childPredicateObjectMap, new NamedNode("http://w3id.org/rml/predicateMap"), null))).isEmpty()) {
                        safeTerms = this.hasSafeReferences(childPredicateMaps.get(0), joinReferences);
                    }
                    if (!safeTerms) {
                        safeSelfJoinElimination = false;
                    }
                }
            }
            if (!safeSelfJoinElimination) continue;
            boolean termTypeAdded = false;
            List<Quad> parentSubjectMapQuads = this.rmlStore.getQuads(parentSubjectMap, null, null);
            for (Quad parentSubjectMapQuad : parentSubjectMapQuads) {
                Term predicate = parentSubjectMapQuad.getPredicate();
                if (predicate.equals(new NamedNode("http://semweb.mmlab.be/ns/fnml#functionValue")) || predicate.equals(new NamedNode("http://w3id.org/rml/termType")) || predicate.equals(new NamedNode("http://w3id.org/rml/reference")) || predicate.equals(new NamedNode("http://w3id.org/rml/template")) || predicate.equals(new NamedNode("http://w3id.org/rml/constant"))) {
                    this.rmlStore.addQuad(childObjectMap, predicate, parentSubjectMapQuad.getObject());
                }
                if (!predicate.equals(new NamedNode("http://w3id.org/rml/termType"))) continue;
                termTypeAdded = true;
            }
            this.rmlStore.removeQuads(childObjectMap, new NamedNode("http://w3id.org/rml/parentTriplesMap"), parentTriplesMap);
            if (termTypeAdded) continue;
            this.rmlStore.addQuad(childObjectMap, new NamedNode("http://w3id.org/rml/termType"), new NamedNode("http://w3id.org/rml/IRI"));
        }
    }

    private Set<String> getAllLinkedReferences(Term term) {
        HashSet<String> references = new HashSet<String>();
        ArrayList<Term> linkedSubjects = new ArrayList<Term>();
        linkedSubjects.add(term);
        while (!linkedSubjects.isEmpty()) {
            Term subject = (Term)linkedSubjects.get(0);
            List<Quad> linkedQuads = this.rmlStore.getQuads(subject, null, null);
            for (Quad linkedQuad : linkedQuads) {
                Term predicate = linkedQuad.getPredicate();
                if (predicate.equals(new NamedNode("http://w3id.org/rml/reference"))) {
                    references.add(linkedQuad.getObject().getValue());
                    continue;
                }
                if (predicate.equals(new NamedNode("http://w3id.org/rml/template"))) {
                    String template = linkedQuad.getObject().getValue();
                    List<Extractor> extractors = Utils.parseTemplate(template, false, false);
                    for (Extractor extractor : extractors) {
                        if (!(extractor instanceof ReferenceExtractor)) continue;
                        references.add(((ReferenceExtractor)extractor).getReference());
                    }
                    continue;
                }
                Term object = linkedQuad.getObject();
                if (!object.isBNode() && !object.isIRI()) continue;
                linkedSubjects.add(object);
            }
            linkedSubjects.remove(0);
        }
        return references;
    }

    private boolean hasSafeReferences(Term term, List<String> joinReferences) {
        boolean isSafe = true;
        Set<String> termReferences = this.getAllLinkedReferences(term);
        for (String parentReference : termReferences) {
            if (joinReferences.contains(parentReference)) continue;
            isSafe = false;
        }
        return isSafe;
    }
}

