/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmac100.jshellscriptengine;

import com.github.dmac100.jshellscriptengine.JShellScriptEngine;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class JShellScriptEngineFactory
implements ScriptEngineFactory {
    private final Bindings globalBindings = new SimpleBindings();

    @Override
    public String getEngineName() {
        return "JShell ScriptEngine";
    }

    @Override
    public String getEngineVersion() {
        return "1.0";
    }

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("java");
    }

    @Override
    public String getLanguageName() {
        return "Java";
    }

    @Override
    public String getLanguageVersion() {
        return "9";
    }

    @Override
    public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(".").append(string2);
        stringBuilder.append("(");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return Arrays.asList("text/x-java-source");
    }

    @Override
    public List<String> getNames() {
        return Arrays.asList("Java", "JShell", "jshell", "java");
    }

    @Override
    public String getOutputStatement(String string) {
        return "System.out.println(" + string + ");";
    }

    @Override
    public Object getParameter(String string) {
        switch (string) {
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
            case "javax.script.name": {
                return this.getNames().get(0);
            }
        }
        return null;
    }

    @Override
    public String getProgram(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(",").append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JShellScriptEngine(this.globalBindings);
    }
}

