/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer.dnd;

import com.ricardojlrufino.jexplorer.JExplorerPanel;
import com.ricardojlrufino.jexplorer.dnd.FileTransferHandler;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class FileTreeDragSource
implements DragGestureListener,
DragSourceListener {
    protected JTree tree;
    protected JExplorerPanel panel;
    protected File[] dragFiles;
    protected TreePath[] paths;
    public static AtomicBoolean started = new AtomicBoolean(false);

    public static void install(JExplorerPanel panel) {
        new FileTreeDragSource(panel);
    }

    public FileTreeDragSource(JExplorerPanel panel) {
        this.panel = panel;
        this.tree = panel.getTree();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 3, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point location = dge.getDragOrigin();
        TreePath dragPath = this.tree.getPathForLocation(location.x, location.y);
        started.set(true);
        if (dragPath != null && this.tree.isPathSelected(dragPath)) {
            this.paths = this.tree.getSelectionPaths();
            if (this.paths != null && this.paths.length > 0) {
                this.dragFiles = new File[this.paths.length];
                for (int i = 0; i < this.paths.length; ++i) {
                    this.dragFiles[i] = this.panel.getSelectedFile(this.paths[i]);
                }
                FileTransferHandler.FileTransferable transferable = new FileTransferHandler.FileTransferable(Arrays.asList(this.dragFiles), true);
                transferable.setSelectionPath(this.tree.getSelectionPath());
                this.panel.setCurrentFileTransferable(transferable);
                dge.startDrag(null, transferable, this);
                this.tree.clearSelection();
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        Transferable transferable = dsde.getDragSourceContext().getTransferable();
        if (transferable instanceof FileTransferHandler.FileTransferable) {
            FileTransferHandler.FileTransferable fileTransferable = (FileTransferHandler.FileTransferable)transferable;
            fileTransferable.setMove(2 == dsde.getDropAction());
            this.panel.setCurrentFileTransferable(fileTransferable);
        }
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        started.set(false);
    }
}

