/*
 * Decompiled with CFR 0.152.
 */
import com.ricardojlrufino.jexplorer.JExplorerPanel;
import com.ricardojlrufino.jexplorer.utils.AcceptAllFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileExplorerPanelDemo
extends JFrame {
    public FileExplorerPanelDemo() {
        final Preferences prefs = Preferences.userNodeForPackage(FileExplorerPanelDemo.class);
        String root = prefs.get("lastFolder", System.getProperty("user.home"));
        final JExplorerPanel fileExplorerPanel = new JExplorerPanel(new File(root));
        this.setDefaultCloseOperation(3);
        this.setTitle("JExplorerPanel demo");
        this.setSize(500, 500);
        this.setLayout(new BorderLayout());
        this.add(fileExplorerPanel);
        final JTextField filterTextField = new JTextField();
        filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                final String text = filterTextField.getText();
                if (text == null || text.trim().isEmpty()) {
                    fileExplorerPanel.setFileFilter(new AcceptAllFileFilter());
                } else {
                    fileExplorerPanel.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().contains(text);
                        }
                    });
                }
            }
        });
        this.add((Component)filterTextField, "North");
        JButton button = new JButton("Browse");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                fileChooser.setFileSelectionMode(1);
                int result = fileChooser.showOpenDialog(FileExplorerPanelDemo.this);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    fileExplorerPanel.replaceWorkingDirectory(selectedFile);
                    prefs.put("lastFolder", selectedFile.getAbsolutePath());
                }
            }
        });
        this.add((Component)button, "South");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new FileExplorerPanelDemo().setVisible(true);
    }
}

