/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import androidx.annotation.VisibleForTesting;

class SQLiteStatementType {
    public static final int STATEMENT_SELECT = 1;
    public static final int STATEMENT_UPDATE = 2;
    public static final int STATEMENT_ATTACH = 3;
    public static final int STATEMENT_BEGIN = 4;
    public static final int STATEMENT_COMMIT = 5;
    public static final int STATEMENT_ABORT = 6;
    public static final int STATEMENT_PRAGMA = 7;
    public static final int STATEMENT_DDL = 8;
    public static final int STATEMENT_UNPREPARED = 9;
    public static final int STATEMENT_OTHER = 99;

    private SQLiteStatementType() {
    }

    public static int getSqlStatementType(String sql) {
        if ((sql = SQLiteStatementType.stripLeadingSqlComments(sql)).length() < 3) {
            return 99;
        }
        String prefixSql = sql.substring(0, 3);
        if (prefixSql.equalsIgnoreCase("SEL") || prefixSql.equalsIgnoreCase("WIT")) {
            return 1;
        }
        if (prefixSql.equalsIgnoreCase("INS") || prefixSql.equalsIgnoreCase("UPD") || prefixSql.equalsIgnoreCase("REP") || prefixSql.equalsIgnoreCase("DEL")) {
            return 2;
        }
        if (prefixSql.equalsIgnoreCase("ATT")) {
            return 3;
        }
        if (prefixSql.equalsIgnoreCase("COM") || prefixSql.equalsIgnoreCase("END")) {
            return 5;
        }
        if (prefixSql.equalsIgnoreCase("ROL")) {
            return 6;
        }
        if (prefixSql.equalsIgnoreCase("BEG")) {
            return 4;
        }
        if (prefixSql.equalsIgnoreCase("PRA")) {
            return 7;
        }
        if (prefixSql.equalsIgnoreCase("CRE") || prefixSql.equalsIgnoreCase("DRO") || prefixSql.equalsIgnoreCase("ALT")) {
            return 8;
        }
        if (prefixSql.equalsIgnoreCase("ANA") || prefixSql.equalsIgnoreCase("DET")) {
            return 9;
        }
        return 99;
    }

    @VisibleForTesting
    static String stripLeadingSqlComments(String sql) {
        sql = sql.trim();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        int statementStartIndex = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (inSingleLineComment) {
                if (c != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (inMultiLineComment) {
                if (c != '*' || i + 1 >= sql.length() || sql.charAt(i + 1) != '/') continue;
                inMultiLineComment = false;
                continue;
            }
            if (c == '-') {
                if (i + 1 >= sql.length() || sql.charAt(i + 1) != '-') continue;
                inSingleLineComment = true;
                continue;
            }
            if (c == '/') {
                if (i + 1 >= sql.length() || sql.charAt(i + 1) != '*') continue;
                inMultiLineComment = true;
                continue;
            }
            if (c == '\n' || c == '\r' || c == ' ' || c == '\t') continue;
            statementStartIndex = i;
            break;
        }
        return sql.substring(statementStartIndex);
    }
}

