/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database;

import android.database.CharArrayBuffer;
import android.database.StaleDataException;
import io.requery.android.database.AbstractCursor;
import io.requery.android.database.CursorWindow;

public abstract class AbstractWindowedCursor
extends AbstractCursor {
    protected CursorWindow mWindow;

    @Override
    public byte[] getBlob(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getBlob(this.mPos, columnIndex);
    }

    @Override
    public String getString(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getString(this.mPos, columnIndex);
    }

    @Override
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        this.mWindow.copyStringToBuffer(this.mPos, columnIndex, buffer);
    }

    @Override
    public short getShort(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getShort(this.mPos, columnIndex);
    }

    @Override
    public int getInt(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getInt(this.mPos, columnIndex);
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getLong(this.mPos, columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getFloat(this.mPos, columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getDouble(this.mPos, columnIndex);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.mWindow.getType(this.mPos, columnIndex) == 0;
    }

    @Override
    public int getType(int columnIndex) {
        return this.mWindow.getType(this.mPos, columnIndex);
    }

    @Override
    protected void checkPosition() {
        super.checkPosition();
        if (this.mWindow == null) {
            throw new StaleDataException("Attempting to access a closed CursorWindow.Most probable cause: cursor is deactivated prior to calling this method.");
        }
    }

    public CursorWindow getWindow() {
        return this.mWindow;
    }

    public void setWindow(CursorWindow window) {
        if (window != this.mWindow) {
            this.closeWindow();
            this.mWindow = window;
        }
    }

    public boolean hasWindow() {
        return this.mWindow != null;
    }

    protected void closeWindow() {
        if (this.mWindow != null) {
            this.mWindow.close();
            this.mWindow = null;
        }
    }

    protected void clearOrCreateWindow(String name) {
        if (this.mWindow == null) {
            this.mWindow = new CursorWindow(name);
        } else {
            this.mWindow.clear();
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.closeWindow();
    }
}

