/*
 * Decompiled with CFR 0.152.
 */
package pl.jeremi.antirelog;

import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.jeremi.antirelog.CombatHandle;

public class AntiRelog
extends JavaPlugin
implements Listener {
    static FileConfiguration config;
    private HashMap<Player, CombatHandle> handledPlayers;
    private HashMap<Player, Boolean> bypassingPlayers;

    public void onEnable() {
        config = this.getConfig();
        config.addDefault("enable-bar", (Object)true);
        config.addDefault("combat-len", (Object)15);
        config.addDefault("vanish-timeout", (Object)5);
        config.addDefault("busy-message", (Object)"&cDo not log out before&7: &r{timeleft} secs.");
        config.addDefault("free-message", (Object)"&aYou can now log out");
        config.addDefault("busy-color", (Object)"red");
        config.addDefault("free-color", (Object)"green");
        config.addDefault("bar-style", (Object)"segmented_6");
        config.addDefault("broadcast-message", (Object)"&b[AntiRelog] &6Player &2{displayname} &6has left while in combat!");
        config.addDefault("busy-chat", (Object)"&c[AntiRelog] &fYou are now in &6combat&f! It time out in {timeout} seconds.");
        config.addDefault("free-chat", (Object)"&a[AntiRelog] &6Combat&f timed out!");
        config.addDefault("subjects", (Object)new String[]{"Player", "Zombie", "Husk", "Zombie_Villager"});
        config.options().copyDefaults(true);
        this.saveConfig();
        this.handledPlayers = new HashMap();
        this.bypassingPlayers = new HashMap();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        CombatHandle.enableBar = config.getBoolean("enable-bar");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("artoggle")) {
            if (sender instanceof Player && args.length == 0) {
                Player player = (Player)sender;
                if (this.bypassingPlayers.containsKey(player)) {
                    this.bypassingPlayers.put(player, this.bypassingPlayers.get(player) == false);
                    this.getLogger().log(Level.INFO, "Toggled " + player.getName() + "'s bypass to " + this.bypassingPlayers.get(player).toString());
                    player.sendMessage("[AntiRelog] " + ChatColor.GREEN + "Successfully set your bypass: " + this.bypassingPlayers.get(player).toString());
                }
                return true;
            }
            if (args.length == 1) {
                Player player = this.getServer().getPlayer(args[0]);
                if (player != null && sender instanceof Player && !player.equals(sender) && !sender.hasPermission("antirelog.toggle.others")) {
                    sender.sendMessage("[AntiRelog] " + ChatColor.RED + "You don't have permission to toggle others bypass.");
                    return true;
                }
                if (player != null && this.bypassingPlayers.containsKey(player)) {
                    this.bypassingPlayers.put(player, this.bypassingPlayers.get(player) == false);
                    this.getLogger().log(Level.INFO, "Toggled " + player.getName() + "'s bypass to " + this.bypassingPlayers.get(player).toString());
                    player.sendMessage("[AntiRelog] " + ChatColor.GREEN + "Successfully set your bypass: " + this.bypassingPlayers.get(player).toString());
                } else {
                    sender.sendMessage("[AntiRelog] " + ChatColor.RED + "Something went wrong. Is this player online?");
                }
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onCombat(EntityDamageByEntityEvent event) {
        Player damager;
        Player player;
        if (event.getDamager() instanceof Player && this.isSubject(event.getEntity().getType()) && !this.bypassingPlayers.get(player = (Player)event.getDamager()).booleanValue()) {
            this.handledPlayers.get(player).startCombat();
        }
        if (event.getEntity() instanceof Player && !this.bypassingPlayers.get(player = (Player)event.getEntity()).booleanValue()) {
            this.handledPlayers.get(player).startCombat();
        }
        if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player && this.isSubject(event.getEntity().getType()) && !this.bypassingPlayers.get(damager = (Player)((Projectile)event.getDamager()).getShooter()).booleanValue()) {
            this.handledPlayers.get(damager).startCombat();
        }
    }

    protected static String getConfigString(String key) {
        String value = config.getString(key);
        return value != null ? value : "";
    }

    private boolean isSubject(EntityType entity) {
        for (String s : config.getStringList("subjects")) {
            if (!s.toUpperCase().equals(entity.name())) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.handledPlayers.put(event.getPlayer(), new CombatHandle(event.getPlayer(), this));
        this.bypassingPlayers.put(event.getPlayer(), event.getPlayer().hasPermission("antirelog.bypass"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.bypassingPlayers.get(player).booleanValue() && this.handledPlayers.get(player).shouldBePunished()) {
            player.setHealth(0.0);
            String broadcastMessage = config.getString("broadcast-message");
            if (broadcastMessage != null && !broadcastMessage.isEmpty()) {
                event.setQuitMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)broadcastMessage.replaceAll("\\{displayname}", player.getDisplayName()).replaceAll("\\{username}", player.getName())));
            }
        }
        if (this.handledPlayers.containsKey(player)) {
            this.handledPlayers.get(player).cleanUp();
            this.handledPlayers.remove(player);
        }
        this.bypassingPlayers.remove(player);
    }
}

