/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import java.net.IDN;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.extensions.StringKt;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/readium/r2/shared/util/Href;", "", "href", "", "baseHref", "(Ljava/lang/String;Ljava/lang/String;)V", "percentEncodedString", "getPercentEncodedString", "()Ljava/lang/String;", "queryParameters", "", "Lorg/readium/r2/shared/util/Href$QueryParameter;", "getQueryParameters", "()Ljava/util/List;", "string", "getString", "QueryParameter", "r2-shared_release"})
public final class Href {
    private final String baseHref;
    private final String href;

    @NotNull
    public final String getString() {
        String string2;
        if (StringsKt.isBlank((CharSequence)this.href)) {
            return this.baseHref;
        }
        try {
            URI absoluteUri = URI.create(this.baseHref).resolve(this.href);
            String string3 = absoluteUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"absoluteUri.toString()");
            String absoluteString = string3;
            URI uRI = absoluteUri;
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"absoluteUri");
            boolean addSlash = uRI.getScheme() == null && !StringsKt.startsWith$default((String)absoluteString, (String)"/", (boolean)false, (int)2, null);
            string2 = (addSlash ? "/" : "") + absoluteString;
        }
        catch (IllegalArgumentException e) {
            String string4;
            try {
                Uri hrefUri = Uri.parse((String)this.href);
                Uri uri = hrefUri;
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"hrefUri");
                string4 = uri.isAbsolute() ? this.href : (StringsKt.startsWith$default((String)this.baseHref, (String)"/", (boolean)false, (int)2, null) ? this.baseHref + this.href : '/' + this.baseHref + this.href);
            }
            catch (Exception e2) {
                string4 = StringsKt.startsWith$default((String)this.href, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.href, (String)"https://", (boolean)false, (int)2, null) ? this.href : StringsKt.removeSuffix((String)this.baseHref, (CharSequence)"/") + StringKt.addPrefix(this.href, "/");
            }
            string2 = string4;
        }
        String resolved = string2;
        String string5 = URLDecoder.decode(resolved, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"URLDecoder.decode(resolved, \"UTF-8\")");
        return string5;
    }

    @NotNull
    public final String getPercentEncodedString() {
        String string2;
        String string3 = this.getString();
        if (StringsKt.startsWith$default((String)string3, (String)"/", (boolean)false, (int)2, null)) {
            string3 = StringKt.addPrefix(string3, "file://");
        }
        try {
            URL url = new URL(string3);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), IDN.toASCII(url.getHost()), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            String string4 = uri.toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"uri.toASCIIString()");
            string2 = StringsKt.removePrefix((String)string4, (CharSequence)"file://");
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
            string2 = this.getString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QueryParameter> getQueryParameters() {
        void $this$mapTo$iv$iv;
        List list = new UrlQuerySanitizer(this.getPercentEncodedString()).getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"UrlQuerySanitizer(percen\u2026odedString).parameterList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UrlQuerySanitizer.ParameterValuePair parameterValuePair = (UrlQuerySanitizer.ParameterValuePair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.mParameter;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.mParameter");
            QueryParameter queryParameter = new QueryParameter(string2, it.mValue);
            collection.add(queryParameter);
        }
        return (List)destination$iv$iv;
    }

    public Href(@NotNull String href, @NotNull String baseHref) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        Intrinsics.checkNotNullParameter((Object)baseHref, (String)"baseHref");
        this.href = href;
        CharSequence charSequence = baseHref;
        boolean bl = false;
        this.baseHref = charSequence.length() == 0 ? "/" : baseHref;
    }

    public /* synthetic */ Href(String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string3 = "/";
        }
        this(string2, string3);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/shared/util/Href$QueryParameter;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "r2-shared_release"})
    public static final class QueryParameter {
        @NotNull
        private final String name;
        @Nullable
        private final String value;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public QueryParameter(@NotNull String name, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final QueryParameter copy(@NotNull String name, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new QueryParameter(name, value);
        }

        public static /* synthetic */ QueryParameter copy$default(QueryParameter queryParameter, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = queryParameter.name;
            }
            if ((n & 2) != 0) {
                string3 = queryParameter.value;
            }
            return queryParameter.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "QueryParameter(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string2 = this.name;
            String string3 = this.value;
            return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QueryParameter)) break block3;
                    QueryParameter queryParameter = (QueryParameter)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)queryParameter.name) || !Intrinsics.areEqual((Object)this.value, (Object)queryParameter.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

