/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.publication.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.readium.r2.shared.UserException;
import org.readium.r2.shared.extensions.JSONKt;
import org.readium.r2.shared.extensions.StringKt;
import org.readium.r2.shared.fetcher.FailureResource;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.fetcher.StringResource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.services.ContentProtectionService;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH&J\u0011\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler;", "", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "toBooleanOrNull", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "toJSON", "Lorg/json/JSONObject;", "Lorg/readium/r2/shared/publication/services/ContentProtectionService$UserRights;", "Companion", "ContentProtectionHandler", "RightsCopyHandler", "RightsPrintHandler", "Lorg/readium/r2/shared/publication/services/RouteHandler$ContentProtectionHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler$RightsCopyHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler$RightsPrintHandler;", "r2-shared_release"})
abstract class RouteHandler {
    private static final List<RouteHandler> handlers;
    @NotNull
    private static final List<Link> links;
    public static final Companion Companion;

    @NotNull
    public abstract Link getLink();

    public abstract boolean acceptRequest(@NotNull Link var1);

    @NotNull
    public abstract Resource handleRequest(@NotNull Link var1, @NotNull ContentProtectionService var2);

    @Nullable
    public final Boolean toBooleanOrNull(@NotNull String $this$toBooleanOrNull) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$toBooleanOrNull, (String)"$this$toBooleanOrNull");
        String string2 = $this$toBooleanOrNull;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        switch (string3) {
            case "true": {
                bl = true;
                break;
            }
            case "false": {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @NotNull
    public final JSONObject toJSON(@NotNull ContentProtectionService.UserRights $this$toJSON) {
        Intrinsics.checkNotNullParameter((Object)$this$toJSON, (String)"$this$toJSON");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("canCopy", $this$toJSON.getCanCopy());
        $this$apply.put("canPrint", $this$toJSON.getCanPrint());
        return jSONObject;
    }

    private RouteHandler() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        handlers = CollectionsKt.listOf((Object[])new RouteHandler[]{ContentProtectionHandler.INSTANCE, RightsCopyHandler.INSTANCE, RightsPrintHandler.INSTANCE});
        Iterable $this$map$iv = handlers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RouteHandler routeHandler = (RouteHandler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Link link2 = it.getLink();
            collection.add(link2);
        }
        links = (List)var3_3;
    }

    public /* synthetic */ RouteHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$ContentProtectionHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "r2-shared_release"})
    public static final class ContentProtectionHandler
    extends RouteHandler {
        @NotNull
        private static final Link link;
        public static final ContentProtectionHandler INSTANCE;

        @Override
        @NotNull
        public Link getLink() {
            return link;
        }

        @Override
        public boolean acceptRequest(@NotNull Link link2) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            return Intrinsics.areEqual((Object)link2.getHref(), (Object)this.getLink().getHref());
        }

        @Override
        @NotNull
        public Resource handleRequest(@NotNull Link link2, @NotNull ContentProtectionService service) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            return new StringResource(link2, (Function1<? super Continuation<? super String>, ? extends Object>)((Function1)new Function1<Continuation<? super String>, Object>(service, null){
                int label;
                final /* synthetic */ ContentProtectionService $service;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            JSONObject jSONObject = new JSONObject();
                            boolean bl = false;
                            boolean bl2 = false;
                            JSONObject $this$apply = jSONObject;
                            boolean bl3 = false;
                            $this$apply.put("isRestricted", this.$service.isRestricted());
                            UserException userException = this.$service.getError();
                            $this$apply.putOpt("error", (Object)(userException != null ? userException.getLocalizedMessage() : null));
                            JSONKt.putIfNotEmpty($this$apply, "name", this.$service.getName());
                            $this$apply.put("rights", (Object)ContentProtectionHandler.INSTANCE.toJSON(this.$service.getRights()));
                            String string2 = jSONObject.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject().apply {\n   \u2026             }.toString()");
                            return string2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$service = contentProtectionService;
                    super(1, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function1<Continuation<? super String>, Object> function1 = new /* invalid duplicate definition of identical inner class */;
                    return function1;
                }

                public final Object invoke(Object object) {
                    return (this.create((Continuation)object)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private ContentProtectionHandler() {
            super(null);
        }

        static {
            ContentProtectionHandler contentProtectionHandler;
            INSTANCE = contentProtectionHandler = new ContentProtectionHandler();
            link = new Link("/~readium/content-protection", "application/vnd.readium.content-protection+json", false, null, null, null, null, null, null, null, null, null, null, 8188, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$RightsCopyHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "r2-shared_release"})
    public static final class RightsCopyHandler
    extends RouteHandler {
        @NotNull
        private static final Link link;
        public static final RightsCopyHandler INSTANCE;

        @Override
        @NotNull
        public Link getLink() {
            return link;
        }

        @Override
        public boolean acceptRequest(@NotNull Link link2) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            return StringsKt.startsWith$default((String)link2.getHref(), (String)"/~readium/rights/copy", (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public Resource handleRequest(@NotNull Link link2, @NotNull ContentProtectionService service) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Map<String, String> parameters2 = StringKt.queryParameters(link2.getHref());
            String string2 = parameters2.get("text");
            if (string2 == null) {
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("'text' parameter is required")));
            }
            String text = string2;
            String string3 = parameters2.get("peek");
            if (string3 == null) {
                string3 = "false";
            }
            Boolean bl = this.toBooleanOrNull(string3);
            if (bl == null) {
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("if present, 'peek' must be true or false")));
            }
            boolean peek = bl;
            ContentProtectionService.UserRights userRights = service.getRights();
            boolean bl2 = false;
            boolean bl3 = false;
            ContentProtectionService.UserRights $this$with = userRights;
            boolean bl4 = false;
            boolean copyAllowed = peek ? $this$with.canCopy(text) : $this$with.copy(text);
            return copyAllowed ? (Resource)new FailureResource(link2, Resource.Exception.Forbidden.INSTANCE) : (Resource)new StringResource(link2, "true");
        }

        private RightsCopyHandler() {
            super(null);
        }

        static {
            RightsCopyHandler rightsCopyHandler;
            INSTANCE = rightsCopyHandler = new RightsCopyHandler();
            link = new Link("/~readium/rights/copy{?text,peek}", "application/vnd.readium.rights.copy+json", true, null, null, null, null, null, null, null, null, null, null, 8184, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$RightsPrintHandler;", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "()V", "link", "Lorg/readium/r2/shared/publication/Link;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "acceptRequest", "", "handleRequest", "Lorg/readium/r2/shared/fetcher/Resource;", "service", "Lorg/readium/r2/shared/publication/services/ContentProtectionService;", "r2-shared_release"})
    public static final class RightsPrintHandler
    extends RouteHandler {
        @NotNull
        private static final Link link;
        public static final RightsPrintHandler INSTANCE;

        @Override
        @NotNull
        public Link getLink() {
            return link;
        }

        @Override
        public boolean acceptRequest(@NotNull Link link2) {
            Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
            return StringsKt.startsWith$default((String)link2.getHref(), (String)"/~readium/rights/print", (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public Resource handleRequest(@NotNull Link link2, @NotNull ContentProtectionService service) {
            Integer n;
            Map<String, String> parameters2;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    parameters2 = StringKt.queryParameters(link2.getHref());
                    String string2 = parameters2.get("pageCount");
                    if (string2 == null) {
                        return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("'pageCount' parameter is required")));
                    }
                    String pageCountString = string2;
                    n = StringsKt.toIntOrNull((String)pageCountString);
                    if (n == null) break block6;
                    Integer n2 = n;
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)n2).intValue();
                    boolean bl3 = false;
                    n = it >= 0 ? n2 : null;
                    if (n != null) break block7;
                }
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("'pageCount' must be a positive integer")));
            }
            int pageCount = n;
            String string3 = parameters2.get("peek");
            if (string3 == null) {
                string3 = "false";
            }
            Boolean bl = this.toBooleanOrNull(string3);
            if (bl == null) {
                return new FailureResource(link2, new Resource.Exception.BadRequest(parameters2, (Throwable)new IllegalArgumentException("if present, 'peek' must be true or false")));
            }
            boolean peek = bl;
            ContentProtectionService.UserRights userRights = service.getRights();
            boolean bl4 = false;
            boolean bl5 = false;
            ContentProtectionService.UserRights $this$with = userRights;
            boolean bl6 = false;
            boolean printAllowed = peek ? $this$with.canPrint(pageCount) : $this$with.print(pageCount);
            return printAllowed ? (Resource)new FailureResource(link2, Resource.Exception.Forbidden.INSTANCE) : (Resource)new StringResource(link2, "true");
        }

        private RightsPrintHandler() {
            super(null);
        }

        static {
            RightsPrintHandler rightsPrintHandler;
            INSTANCE = rightsPrintHandler = new RightsPrintHandler();
            link = new Link("/~readium/rights/print{?pageCount,peek}", "application/vnd.readium.rights.print+json", true, null, null, null, null, null, null, null, null, null, null, 8184, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/readium/r2/shared/publication/services/RouteHandler$Companion;", "", "()V", "handlers", "", "Lorg/readium/r2/shared/publication/services/RouteHandler;", "links", "Lorg/readium/r2/shared/publication/Link;", "getLinks", "()Ljava/util/List;", "route", "link", "r2-shared_release"})
    public static final class Companion {
        @NotNull
        public final List<Link> getLinks() {
            return links;
        }

        @Nullable
        public final RouteHandler route(@NotNull Link link2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
                Iterable $this$firstOrNull$iv = handlers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RouteHandler it = (RouteHandler)element$iv;
                    boolean bl = false;
                    if (!it.acceptRequest(link2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

