/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.extensions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.publication.Publication;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/readium/r2/shared/extensions/PublicationRepository;", "", "()V", "publications", "", "", "Lorg/readium/r2/shared/publication/Publication;", "add", "publication", "clear", "", "createId", "get", "id", "remove", "r2-shared_release"})
final class PublicationRepository {
    private static final Map<String, Publication> publications;
    public static final PublicationRepository INSTANCE;

    @Nullable
    public final Publication get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return publications.get(id);
    }

    @NotNull
    public final String add(@NotNull Publication publication) {
        Intrinsics.checkNotNullParameter((Object)publication, (String)"publication");
        String id = this.createId();
        publications.put(id, publication);
        return id;
    }

    public final void remove(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        publications.remove(id);
    }

    public final void clear() {
        publications.clear();
    }

    private final String createId() {
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
        String id = string2;
        if (publications.containsKey(id)) {
            return this.createId();
        }
        return id;
    }

    private PublicationRepository() {
    }

    static {
        PublicationRepository publicationRepository;
        INSTANCE = publicationRepository = new PublicationRepository();
        boolean bl = false;
        publications = new LinkedHashMap();
    }
}

