/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.fetcher;

import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.fetcher.Fetcher;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.fetcher.StreamResource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.util.Try;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/readium/r2/shared/fetcher/ZipFetcher;", "Lorg/readium/r2/shared/fetcher/Fetcher;", "archive", "Ljava/util/zip/ZipFile;", "(Ljava/util/zip/ZipFile;)V", "close", "", "get", "Lorg/readium/r2/shared/fetcher/Resource;", "link", "Lorg/readium/r2/shared/publication/Link;", "parameters", "", "", "Lorg/readium/r2/shared/fetcher/HrefParameters;", "Companion", "ZipResource", "r2-shared_release"})
public final class ZipFetcher
implements Fetcher {
    private final ZipFile archive;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Resource get(@NotNull Link link, @NotNull Map<String, String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        return new ZipResource(link, this.archive);
    }

    @Override
    public void close() {
        this.archive.close();
    }

    private ZipFetcher(ZipFile archive) {
        this.archive = archive;
    }

    public /* synthetic */ ZipFetcher(ZipFile archive, DefaultConstructorMarker $constructor_marker) {
        this(archive);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/readium/r2/shared/fetcher/ZipFetcher$ZipResource;", "Lorg/readium/r2/shared/fetcher/StreamResource;", "link", "Lorg/readium/r2/shared/publication/Link;", "archive", "Ljava/util/zip/ZipFile;", "(Lorg/readium/r2/shared/publication/Link;Ljava/util/zip/ZipFile;)V", "getArchive", "()Ljava/util/zip/ZipFile;", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "metadataLength", "", "getMetadataLength", "()Ljava/lang/Long;", "metadataLength$delegate", "Lkotlin/Lazy;", "close", "", "entryForHref", "Ljava/util/zip/ZipEntry;", "href", "", "stream", "Lorg/readium/r2/shared/util/Try;", "Ljava/io/InputStream;", "Lorg/readium/r2/shared/fetcher/Resource$Error;", "r2-shared_release"})
    private static final class ZipResource
    extends StreamResource {
        @Nullable
        private final Lazy metadataLength$delegate;
        @NotNull
        private final Link link;
        @NotNull
        private final ZipFile archive;

        @Override
        @NotNull
        protected Try<InputStream, Resource.Error> stream() {
            ZipEntry entry = this.entryForHref(this.getLink().getHref());
            return entry == null ? Try.Companion.failure(Resource.Error.NotFound.INSTANCE) : Try.Companion.success(this.archive.getInputStream(entry));
        }

        @Override
        @Nullable
        protected Long getMetadataLength() {
            Lazy lazy = this.metadataLength$delegate;
            ZipResource zipResource = this;
            Object var3_3 = null;
            boolean bl = false;
            return (Long)lazy.getValue();
        }

        @Override
        public void close() {
        }

        private final ZipEntry entryForHref(String href) {
            return this.archive.getEntry(StringsKt.removePrefix((String)href, (CharSequence)"/"));
        }

        @Override
        @NotNull
        public Link getLink() {
            return this.link;
        }

        @NotNull
        public final ZipFile getArchive() {
            return this.archive;
        }

        public ZipResource(@NotNull Link link, @NotNull ZipFile archive) {
            Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
            Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
            this.link = link;
            this.archive = archive;
            this.metadataLength$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
                final /* synthetic */ ZipResource this$0;

                @Nullable
                public final Long invoke() {
                    Long l;
                    ZipEntry zipEntry = ZipResource.access$entryForHref(this.this$0, this.this$0.getLink().getHref());
                    if (zipEntry != null) {
                        Long l2 = zipEntry.getSize();
                        boolean bl = false;
                        boolean bl2 = false;
                        long it = ((Number)l2).longValue();
                        boolean bl3 = false;
                        l = it != -1L ? l2 : null;
                    } else {
                        l = null;
                    }
                    return l;
                }
                {
                    this.this$0 = zipResource;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ ZipEntry access$entryForHref(ZipResource $this, String href) {
            return $this.entryForHref(href);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/shared/fetcher/ZipFetcher$Companion;", "", "()V", "fromPath", "Lorg/readium/r2/shared/fetcher/ZipFetcher;", "path", "", "r2-shared_release"})
    public static final class Companion {
        @Nullable
        public final ZipFetcher fromPath(@NotNull String path) {
            ZipFetcher zipFetcher;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            try {
                zipFetcher = new ZipFetcher(new ZipFile(path), null);
            }
            catch (Exception e) {
                zipFetcher = null;
            }
            return zipFetcher;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

