/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.fetcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.fetcher.FailureResource;
import org.readium.r2.shared.fetcher.Fetcher;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.fetcher.StreamResource;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.util.Try;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0019\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007j\u0002`\u0013H\u0016R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/readium/r2/shared/fetcher/FileFetcher;", "Lorg/readium/r2/shared/fetcher/Fetcher;", "href", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "paths", "", "(Ljava/util/Map;)V", "openedResources", "", "Ljava/lang/ref/WeakReference;", "Lorg/readium/r2/shared/fetcher/Resource;", "close", "", "get", "link", "Lorg/readium/r2/shared/publication/Link;", "parameters", "Lorg/readium/r2/shared/fetcher/HrefParameters;", "FileResource", "r2-shared_release"})
public final class FileFetcher
implements Fetcher {
    private final List<WeakReference<Resource>> openedResources;
    private final Map<String, String> paths;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Resource get(@NotNull Link link, @NotNull Map<String, String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        Object object = this.paths;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            FailureResource failureResource;
            String resourcePath;
            void href;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String path = entry2.getValue();
            if (!StringsKt.startsWith$default((String)link.getHref(), (String)href, (boolean)false, (int)2, null)) continue;
            String string = resourcePath = new File(path, StringsKt.removePrefix((String)link.getHref(), (CharSequence)((CharSequence)href))).getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourcePath");
            if (!StringsKt.startsWith$default((String)string, (String)path, (boolean)false, (int)2, null)) continue;
            try {
                RandomAccessFile file = new RandomAccessFile(resourcePath, "r");
                FileResource resource = new FileResource(link, file);
                this.openedResources.add(new WeakReference<FileResource>(resource));
                return resource;
            }
            catch (FileNotFoundException e) {
                failureResource = new FailureResource(link, Resource.Error.NotFound.INSTANCE);
            }
            catch (SecurityException e) {
                failureResource = new FailureResource(link, Resource.Error.Forbidden.INSTANCE);
            }
            catch (Exception e) {
                failureResource = new FailureResource(link, new Resource.Error.Other(e));
            }
            return failureResource;
        }
        return new FailureResource(link, Resource.Error.NotFound.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.openedResources;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Resource resource;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            WeakReference p1 = (WeakReference)element$iv$iv;
            boolean bl2 = false;
            if ((Resource)p1.get() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Resource it$iv$iv = resource;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Resource it = (Resource)element$iv;
            boolean bl = false;
            it.close();
        }
        this.openedResources.clear();
    }

    public FileFetcher(@NotNull Map<String, String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        this.paths = paths;
        this.openedResources = new LinkedList();
    }

    public FileFetcher(@NotNull String href, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(MapsKt.mapOf((Pair)TuplesKt.to((Object)href, (Object)path)));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/readium/r2/shared/fetcher/FileFetcher$FileResource;", "Lorg/readium/r2/shared/fetcher/StreamResource;", "link", "Lorg/readium/r2/shared/publication/Link;", "file", "Ljava/io/RandomAccessFile;", "(Lorg/readium/r2/shared/publication/Link;Ljava/io/RandomAccessFile;)V", "getLink", "()Lorg/readium/r2/shared/publication/Link;", "metadataLength", "", "getMetadataLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "close", "", "stream", "Lorg/readium/r2/shared/util/Try;", "Ljava/io/InputStream;", "Lorg/readium/r2/shared/fetcher/Resource$Error;", "r2-shared_release"})
    private static final class FileResource
    extends StreamResource {
        @Nullable
        private final Long metadataLength;
        @NotNull
        private final Link link;
        private final RandomAccessFile file;

        @Override
        @NotNull
        protected Try<InputStream, Resource.Error> stream() {
            InputStream inputStream = Channels.newInputStream(this.file.getChannel());
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Channels.newInputStream(file.channel)");
            InputStream inputStream2 = inputStream;
            int n = 8192;
            boolean bl = false;
            BufferedInputStream stream2 = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
            return Try.Companion.success(stream2);
        }

        @Override
        @Nullable
        protected Long getMetadataLength() {
            return this.metadataLength;
        }

        @Override
        public void close() {
            this.file.close();
        }

        @Override
        @NotNull
        public Link getLink() {
            return this.link;
        }

        public FileResource(@NotNull Link link, @NotNull RandomAccessFile file) {
            Long l;
            FileResource fileResource;
            Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.link = link;
            this.file = file;
            FileResource fileResource2 = this;
            try {
                fileResource = fileResource2;
                l = this.file.length();
            }
            catch (Exception exception) {
                fileResource = fileResource2;
                l = null;
            }
            fileResource.metadataLength = l;
        }
    }
}

