/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared;

import android.net.Uri;
import java.net.URI;
import java.net.URLDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0005"}, d2={"getAbsolute", "", "href", "base", "normalize", "r2-shared_release"})
public final class URLHelperKt {
    @NotNull
    public static final String getAbsolute(@NotNull String href, @NotNull String base) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        try {
            URI baseURI = URI.create(base);
            URI relative = baseURI.resolve(href);
            String string2 = relative.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"relative.toString()");
            string = string2;
        }
        catch (IllegalArgumentException e) {
            Uri hrefUri;
            Uri uri = hrefUri = Uri.parse((String)href);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"hrefUri");
            string = uri.isAbsolute() ? href : base + href;
        }
        return string;
    }

    @NotNull
    public static final String normalize(@NotNull String base, @Nullable String href) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        CharSequence charSequence = href;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        try {
            URI absoluteUri = URI.create(base).resolve(href);
            String string2 = absoluteUri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"absoluteUri.toString()");
            String absoluteString = string2;
            URI uRI = absoluteUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"absoluteUri");
            boolean addSlash = uRI.getScheme() == null && !StringsKt.startsWith$default((String)absoluteString, (String)"/", (boolean)false, (int)2, null);
            string = (addSlash ? "/" : "") + absoluteString;
        }
        catch (IllegalArgumentException e) {
            Uri hrefUri;
            Uri uri = hrefUri = Uri.parse((String)href);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"hrefUri");
            string = uri.isAbsolute() ? href : (StringsKt.startsWith$default((String)base, (String)"/", (boolean)false, (int)2, null) ? base + href : "/" + base + href);
        }
        String resolved = string;
        String string3 = URLDecoder.decode(resolved, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"URLDecoder.decode(resolved, \"UTF-8\")");
        return string3;
    }
}

