/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared;

import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.LinkError;
import org.readium.r2.shared.Properties;
import org.readium.r2.shared.URLHelperKt;
import org.readium.r2.shared.opds.IndirectAcquisition;
import org.readium.r2.shared.opds.IndirectAcquisitionKt;
import org.readium.r2.shared.opds.Price;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0006"}, d2={"parseLink", "Lorg/readium/r2/shared/Link;", "linkDict", "Lorg/json/JSONObject;", "feedUrl", "Ljava/net/URL;", "r2-shared_release"})
public final class LinkKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Link parseLink(@NotNull JSONObject linkDict, @Nullable URL feedUrl) {
        int n;
        int n2;
        Object it;
        int n3;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)linkDict, (String)"linkDict");
        Link link = new Link();
        if (linkDict.has("title")) {
            link.setTitle(linkDict.getString("title"));
        }
        if (linkDict.has("href")) {
            URL uRL = feedUrl;
            if (uRL != null) {
                object = uRL;
                n3 = 0;
                boolean bl = false;
                it = object;
                n2 = 0;
                String string = linkDict.getString("href");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkDict.getString(\"href\")");
                String string2 = feedUrl.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"feedUrl.toString()");
                link.setHref(URLHelperKt.getAbsolute(string, string2));
            } else {
                boolean bl = false;
                n3 = 0;
                n = 0;
                link.setHref(linkDict.getString("href"));
            }
        }
        if (linkDict.has("type")) {
            link.setTypeLink(linkDict.getString("type"));
        }
        if (linkDict.has("rel")) {
            if (linkDict.get("rel") instanceof String) {
                List<String> list = link.getRel();
                String string = linkDict.getString("rel");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkDict.getString(\"rel\")");
                list.add(string);
            } else if (linkDict.get("rel") instanceof JSONArray) {
                JSONArray array = linkDict.getJSONArray("rel");
                n3 = 0;
                n = array.length();
                while (n3 < n) {
                    void i;
                    String string = array.getString((int)i);
                    List<String> list = link.getRel();
                    String string3 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"string");
                    list.add(string3);
                    ++i;
                }
            }
        }
        if (linkDict.has("height")) {
            link.setHeight(linkDict.getInt("height"));
        }
        if (linkDict.has("width")) {
            link.setWidth(linkDict.getInt("width"));
        }
        if (linkDict.has("bitrate")) {
            link.setBitrate(linkDict.getInt("bitrate"));
        }
        if (linkDict.has("duration")) {
            link.setDuration(linkDict.getDouble("duration"));
        }
        if (linkDict.has("properties")) {
            Properties properties = new Properties();
            JSONObject propertiesDict = linkDict.getJSONObject("properties");
            if (propertiesDict.has("numberOfItems")) {
                properties.setNumberOfItems(propertiesDict.getInt("numberOfItems"));
            }
            if (propertiesDict.has("indirectAcquisition")) {
                JSONArray jSONArray = propertiesDict.getJSONArray("indirectAcquisition");
                if (jSONArray == null) {
                    throw (Throwable)new Exception(LinkError.InvalidLink.name());
                }
                JSONArray acquisitions = jSONArray;
                int string = 0;
                n2 = acquisitions.length();
                while (string < n2) {
                    void i;
                    JSONObject acquisition;
                    JSONObject jSONObject = acquisition = acquisitions.getJSONObject((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"acquisition");
                    IndirectAcquisition indirectAcquisition = IndirectAcquisitionKt.parseIndirectAcquisition(jSONObject);
                    properties.getIndirectAcquisition().add(indirectAcquisition);
                    ++i;
                }
            }
            if (propertiesDict.has("price")) {
                JSONObject priceDict = propertiesDict.getJSONObject("price");
                Object object2 = priceDict.get("currency");
                if (!(object2 instanceof String)) {
                    object2 = null;
                }
                String currency = (String)object2;
                Object object3 = priceDict.get("value");
                if (!(object3 instanceof Double)) {
                    object3 = null;
                }
                Double value = (Double)object3;
                if (priceDict == null || currency == null || value == null) {
                    throw (Throwable)new Exception(LinkError.InvalidLink.name());
                }
                Price price = new Price(currency, value);
                properties.setPrice(price);
            }
            link.setProperties(properties);
        }
        if (linkDict.has("children")) {
            object = linkDict.get("children");
            boolean bl = false;
            boolean bl2 = false;
            it = object;
            boolean bl3 = false;
            Object object4 = it;
            if (!(object4 instanceof JSONArray)) {
                object4 = null;
            }
            JSONArray jSONArray = (JSONArray)object4;
            if (jSONArray == null) {
                throw (Throwable)new Exception(LinkError.InvalidLink.name());
            }
            JSONArray children = jSONArray;
            int indirectAcquisition = 0;
            int n4 = children.length();
            while (indirectAcquisition < n4) {
                void i;
                JSONObject childLinkDict;
                JSONObject jSONObject = childLinkDict = children.getJSONObject((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"childLinkDict");
                Link childLink = LinkKt.parseLink$default(jSONObject, null, 2, null);
                link.getChildren().add(childLink);
                ++i;
            }
        }
        return link;
    }

    public static /* synthetic */ Link parseLink$default(JSONObject jSONObject, URL uRL, int n, Object object) {
        if ((n & 2) != 0) {
            uRL = null;
        }
        return LinkKt.parseLink(jSONObject, uRL);
    }
}

