/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/readium/r2/streamer/parser/epub/ClockValueParser;", "", "()V", "parse", "", "rawValue", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseClockvalue", "value", "parseTimecount", "metric", "(DLjava/lang/String;)Ljava/lang/Double;", "streamer_release"})
public final class ClockValueParser {
    @NotNull
    public static final ClockValueParser INSTANCE = new ClockValueParser();

    private ClockValueParser() {
    }

    @Nullable
    public final Double parse(@NotNull String rawValue) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        String value = ((Object)StringsKt.trim((CharSequence)rawValue)).toString();
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)":", (boolean)false, (int)2, null)) {
            d = this.parseClockvalue(value);
        } else {
            int metricStart;
            block6: {
                int n;
                CharSequence $this$indexOfFirst$iv = value;
                boolean $i$f$indexOfFirst = false;
                int n2 = 0;
                int n3 = $this$indexOfFirst$iv.length();
                while (n2 < n3) {
                    int index$iv = n2++;
                    char p0 = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!Character.isLetter(p0)) continue;
                    n = index$iv;
                    break block6;
                }
                n = metricStart = -1;
            }
            if (metricStart == -1) {
                d = this.parseTimecount(Double.parseDouble(value), "");
            } else {
                Double d2 = StringsKt.toDoubleOrNull((String)StringsKt.substring((String)value, (IntRange)RangesKt.until((int)0, (int)metricStart)));
                if (d2 == null) {
                    return null;
                }
                double count = d2;
                String metric = StringsKt.substring((String)value, (IntRange)RangesKt.until((int)metricStart, (int)value.length()));
                d = this.parseTimecount(count, metric);
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private final Double parseClockvalue(String value) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{":"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = StringsKt.toDoubleOrNull((String)it);
            if (d == null) {
                return null;
            }
            collection.add(Double.valueOf(d));
        }
        List parts = (List)destination$iv$iv;
        double min_sec = ((Number)CollectionsKt.last((List)parts)).doubleValue() + ((Number)parts.get(parts.size() - 2)).doubleValue() * (double)60;
        return parts.size() > 2 ? Double.valueOf(min_sec + ((Number)parts.get(parts.size() - 3)).doubleValue() * (double)3600) : Double.valueOf(min_sec);
    }

    private final Double parseTimecount(double value, String metric) {
        Double d;
        switch (metric) {
            case "h": {
                d = value * (double)3600;
                break;
            }
            case "min": {
                d = value * (double)60;
                break;
            }
            case "": 
            case "s": {
                d = value;
                break;
            }
            case "ms": {
                d = value / (double)1000;
                break;
            }
            default: {
                d = null;
            }
        }
        return d;
    }
}

