/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared.util.mediatype;

import android.content.ContentResolver;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.extensions.ContentResolverKt;
import org.readium.r2.shared.util.mediatype.MediaType;
import org.readium.r2.shared.util.mediatype.SnifferBytesContent;
import org.readium.r2.shared.util.mediatype.SnifferContent;
import org.readium.r2.shared.util.mediatype.SnifferContext;
import org.readium.r2.shared.util.mediatype.SnifferFileContent;
import org.readium.r2.shared.util.mediatype.SnifferUriContent;
import org.readium.r2.shared.util.mediatype.Sniffers;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u00016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010(\u001a\u00020\u0000H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0003J\u0010\u0010*\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0000J\u0013\u0010,\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0003J\u0010\u0010/\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\u0000J#\u00100\u001a\u00020\u000e2\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000302\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u00103J#\u00100\u001a\u00020\u000e2\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000002\"\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\u0003H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0018\u001a\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\fR\u0011\u0010$\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\fR\u0011\u0010&\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lorg/readium/r2/shared/util/mediatype/MediaType;", "", "string", "", "name", "fileExtension", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "getFileExtension", "()Ljava/lang/String;", "isAudio", "", "()Z", "isBitmap", "isHtml", "isJson", "isOpds", "isPublication", "isRwpm", "isVideo", "isZip", "mediaType", "getMediaType$annotations", "()V", "getMediaType", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "getName", "parameters", "", "getParameters", "()Ljava/util/Map;", "structuredSyntaxSuffix", "getStructuredSyntaxSuffix", "subtype", "getSubtype", "type", "getType", "canonicalMediaType", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "contains", "other", "equals", "hashCode", "", "matches", "matchesAny", "others", "", "([Ljava/lang/String;)Z", "([Lorg/readium/r2/shared/util/mediatype/MediaType;)Z", "toString", "Companion", "shared_release"})
public final class MediaType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String name;
    @Nullable
    private final String fileExtension;
    @NotNull
    private final String type;
    @NotNull
    private final String subtype;
    @NotNull
    private final Map<String, String> parameters;
    @NotNull
    private static final MediaType AAC = new MediaType("audio/aac", null, "aac", 2, null);
    @NotNull
    private static final MediaType ACSM = new MediaType("application/vnd.adobe.adept+xml", "Adobe Content Server Message", "acsm");
    @NotNull
    private static final MediaType AIFF = new MediaType("audio/aiff", null, "aiff", 2, null);
    @NotNull
    private static final MediaType AVI = new MediaType("video/x-msvideo", null, "avi", 2, null);
    @NotNull
    private static final MediaType AVIF = new MediaType("image/avif", null, "avif", 2, null);
    @NotNull
    private static final MediaType BINARY = new MediaType("application/octet-stream", null, null, 6, null);
    @NotNull
    private static final MediaType BMP = new MediaType("image/bmp", null, "bmp", 2, null);
    @NotNull
    private static final MediaType CBZ = new MediaType("application/vnd.comicbook+zip", "Comic Book Archive", "cbz");
    @NotNull
    private static final MediaType CSS = new MediaType("text/css", null, "css", 2, null);
    @NotNull
    private static final MediaType DIVINA = new MediaType("application/divina+zip", "Digital Visual Narratives", "divina");
    @NotNull
    private static final MediaType DIVINA_MANIFEST = new MediaType("application/divina+json", "Digital Visual Narratives", "json");
    @NotNull
    private static final MediaType EPUB = new MediaType("application/epub+zip", "EPUB", "epub");
    @NotNull
    private static final MediaType GIF = new MediaType("image/gif", null, "gif", 2, null);
    @NotNull
    private static final MediaType GZ = new MediaType("application/gzip", null, "gz", 2, null);
    @NotNull
    private static final MediaType HTML = new MediaType("text/html", null, "html", 2, null);
    @NotNull
    private static final MediaType JAVASCRIPT = new MediaType("text/javascript", null, "js", 2, null);
    @NotNull
    private static final MediaType JPEG = new MediaType("image/jpeg", null, "jpeg", 2, null);
    @NotNull
    private static final MediaType JSON = new MediaType("application/json", null, null, 6, null);
    @NotNull
    private static final MediaType JSON_PROBLEM_DETAILS = new MediaType("application/problem+json", "HTTP Problem Details", "json");
    @NotNull
    private static final MediaType JXL = new MediaType("image/jxl", null, "jxl", 2, null);
    @NotNull
    private static final MediaType LCP_LICENSE_DOCUMENT = new MediaType("application/vnd.readium.lcp.license.v1.0+json", "LCP License", "lcpl");
    @NotNull
    private static final MediaType LCP_PROTECTED_AUDIOBOOK = new MediaType("application/audiobook+lcp", "LCP Protected Audiobook", "lcpa");
    @NotNull
    private static final MediaType LCP_PROTECTED_PDF = new MediaType("application/pdf+lcp", "LCP Protected PDF", "lcpdf");
    @NotNull
    private static final MediaType LCP_STATUS_DOCUMENT = new MediaType("application/vnd.readium.license.status.v1.0+json", null, null, 6, null);
    @NotNull
    private static final MediaType LPF = new MediaType("application/lpf+zip", null, "lpf", 2, null);
    @NotNull
    private static final MediaType MP3 = new MediaType("audio/mpeg", null, "mp3", 2, null);
    @NotNull
    private static final MediaType MPEG = new MediaType("video/mpeg", null, "mpeg", 2, null);
    @NotNull
    private static final MediaType NCX = new MediaType("application/x-dtbncx+xml", null, "ncx", 2, null);
    @NotNull
    private static final MediaType OGG = new MediaType("audio/ogg", null, "oga", 2, null);
    @NotNull
    private static final MediaType OGV = new MediaType("video/ogg", null, "ogv", 2, null);
    @NotNull
    private static final MediaType OPDS1 = new MediaType("application/atom+xml;profile=opds-catalog", null, null, 6, null);
    @NotNull
    private static final MediaType OPDS1_ENTRY = new MediaType("application/atom+xml;type=entry;profile=opds-catalog", null, null, 6, null);
    @NotNull
    private static final MediaType OPDS2 = new MediaType("application/opds+json", null, null, 6, null);
    @NotNull
    private static final MediaType OPDS2_PUBLICATION = new MediaType("application/opds-publication+json", null, null, 6, null);
    @NotNull
    private static final MediaType OPDS_AUTHENTICATION = new MediaType("application/opds-authentication+json", null, null, 6, null);
    @NotNull
    private static final MediaType OPUS = new MediaType("audio/opus", null, "opus", 2, null);
    @NotNull
    private static final MediaType OTF = new MediaType("font/otf", null, "otf", 2, null);
    @NotNull
    private static final MediaType PDF = new MediaType("application/pdf", "PDF", "pdf");
    @NotNull
    private static final MediaType PNG = new MediaType("image/png", null, "png", 2, null);
    @NotNull
    private static final MediaType READIUM_AUDIOBOOK = new MediaType("application/audiobook+zip", "Readium Audiobook", "audiobook");
    @NotNull
    private static final MediaType READIUM_AUDIOBOOK_MANIFEST = new MediaType("application/audiobook+json", "Readium Audiobook", "json");
    @NotNull
    private static final MediaType READIUM_WEBPUB = new MediaType("application/webpub+zip", "Readium Web Publication", "webpub");
    @NotNull
    private static final MediaType READIUM_WEBPUB_MANIFEST = new MediaType("application/webpub+json", "Readium Web Publication", "json");
    @NotNull
    private static final MediaType SMIL = new MediaType("application/smil+xml", null, "smil", 2, null);
    @NotNull
    private static final MediaType SVG = new MediaType("image/svg+xml", null, "svg", 2, null);
    @NotNull
    private static final MediaType TEXT = new MediaType("text/plain", null, "txt", 2, null);
    @NotNull
    private static final MediaType TIFF = new MediaType("image/tiff", null, "tiff", 2, null);
    @NotNull
    private static final MediaType TTF = new MediaType("font/ttf", null, "ttf", 2, null);
    @NotNull
    private static final MediaType W3C_WPUB_MANIFEST = new MediaType("application/x.readium.w3c.wpub+json", "Web Publication", "json");
    @NotNull
    private static final MediaType WAV = new MediaType("audio/wav", null, "wav", 2, null);
    @NotNull
    private static final MediaType WEBM_AUDIO = new MediaType("audio/webm", null, "webm", 2, null);
    @NotNull
    private static final MediaType WEBM_VIDEO = new MediaType("video/webm", null, "webm", 2, null);
    @NotNull
    private static final MediaType WEBP = new MediaType("image/webp", null, "webp", 2, null);
    @NotNull
    private static final MediaType WOFF = new MediaType("font/woff", null, "woff", 2, null);
    @NotNull
    private static final MediaType WOFF2 = new MediaType("font/woff2", null, "woff2", 2, null);
    @NotNull
    private static final MediaType XHTML = new MediaType("application/xhtml+xml", null, "xhtml", 2, null);
    @NotNull
    private static final MediaType XML = new MediaType("application/xml", null, "xml", 2, null);
    @NotNull
    private static final MediaType ZAB = new MediaType("application/x.readium.zab+zip", "Zipped Audio Book", "zab");
    @NotNull
    private static final MediaType ZIP = new MediaType("application/zip", null, "zip", 2, null);
    @NotNull
    private static final List<Function2<SnifferContext, Continuation<? super MediaType>, Object>> sniffers = CollectionsKt.toMutableList((Collection)Sniffers.INSTANCE.getAll());

    /*
     * WARNING - void declaration
     */
    public MediaType(@NotNull String string2, @Nullable String name, @Nullable String fileExtension) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        String string3;
        Collection collection;
        Object $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        this.name = name;
        this.fileExtension = fileExtension;
        CharSequence charSequence = string2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid media type: ", (Object)string2));
        }
        Object object2 = new String[]{";"};
        object2 = StringsKt.split$default((CharSequence)string2, (String[])object2, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        String string4 = $this$map$iv2;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Iterator it2;
            Object item$iv$iv = iterator.next();
            String string5 = (String)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl2 = false;
            string3 = it2;
            boolean bl3 = false;
            void v0 = string3;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            collection.add(object);
        }
        List components = (List)destination$iv$iv22;
        Object $i$f$map22 = new String[]{"/"};
        List types = StringsKt.split$default((CharSequence)((CharSequence)components.get(0)), (String[])$i$f$map22, (boolean)false, (int)0, (int)6, null);
        if (types.size() != 2) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid media type: ", (Object)string2));
        }
        $i$f$map22 = (String)types.get(0);
        $this$mapTo$iv$iv2 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv2, (String)"ROOT");
        boolean destination$iv$iv22 = false;
        Object object3 = $i$f$map22;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = ((String)object3).toLowerCase((Locale)$this$mapTo$iv$iv2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        this.type = string6;
        $i$f$map22 = (String)types.get(1);
        $this$mapTo$iv$iv2 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv2, (String)"ROOT");
        destination$iv$iv22 = false;
        Object object4 = $i$f$map22;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = ((String)object4).toLowerCase((Locale)$this$mapTo$iv$iv2);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
        this.subtype = string7;
        $this$mapTo$iv$iv2 = CollectionsKt.drop((Iterable)components, (int)1);
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            string3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            String[] stringArray = new String[]{"="};
            object = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl5 = false;
            if (!(it.size() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            List it3 = (List)element$iv$iv;
            boolean bl6 = false;
            String string8 = (String)it3.get(0);
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            boolean bl7 = false;
            String string9 = string8;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase(locale)");
            it3 = new Pair((Object)string10, it3.get(1));
            boolean bl8 = false;
            map.put(it3.getFirst(), it3.getSecond());
        }
        Map parameters2 = MapsKt.toMutableMap((Map)destination$iv$iv3);
        string4 = (String)parameters2.get("charset");
        if (string4 != null) {
            Object object5;
            String string11 = string4;
            boolean bl9 = false;
            boolean bl10 = false;
            String it4 = string11;
            boolean bl11 = false;
            Map map = parameters2;
            string3 = "charset";
            try {
                object5 = Charset.forName(it4).name();
            }
            catch (Exception e) {
                object5 = it4;
            }
            String string12 = object5;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"try { Charset.forName(it\u2026tch (e: Exception) { it }");
            object5 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"ROOT");
            boolean bl12 = false;
            String string13 = string12.toUpperCase((Locale)object5);
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).toUpperCase(locale)");
            string12 = string13;
            boolean bl13 = false;
            map.put(string3, string12);
        }
        this.parameters = parameters2;
    }

    public /* synthetic */ MediaType(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            string4 = null;
        }
        this(string2, string3, string4);
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    @Nullable
    public final String getStructuredSyntaxSuffix() {
        String[] stringArray = new String[]{"+"};
        List parts = StringsKt.split$default((CharSequence)this.subtype, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return parts.size() > 1 ? Intrinsics.stringPlus((String)"+", (Object)CollectionsKt.last((List)parts)) : null;
    }

    @Nullable
    public final Charset getCharset() {
        Charset charset2;
        String string2 = this.parameters.get("charset");
        if (string2 == null) {
            charset2 = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            charset2 = Charset.forName(it);
        }
        return charset2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object canonicalMediaType(@NotNull Continuation<? super MediaType> var1_1) {
        if (!(var1_1 instanceof canonicalMediaType.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ MediaType this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.canonicalMediaType((Continuation<? super MediaType>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = org.readium.r2.shared.util.mediatype.MediaType$Companion.of$default(MediaType.Companion, this.toString(), null, null, (Continuation)$continuation, 6, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (MediaType)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return (var2_5 = (MediaType)v0) == null ? this : var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = this.parameters;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string2);
        }
        String params = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        CharSequence charSequence = params;
        boolean bl3 = false;
        if (charSequence.length() > 0) {
            params = Intrinsics.stringPlus((String)";", (Object)params);
        }
        return this.type + '/' + this.subtype + params;
    }

    public boolean equals(@Nullable Object other) {
        MediaType mediaType2 = other instanceof MediaType ? (MediaType)other : null;
        return Intrinsics.areEqual((Object)this.toString(), (Object)(mediaType2 == null ? null : mediaType2.toString()));
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + ((Object)this.parameters).hashCode();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(@Nullable MediaType other) {
        void $this$mapTo$iv$iv;
        String string2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (other == null || !Intrinsics.areEqual((Object)this.type, (Object)"*") && !Intrinsics.areEqual((Object)this.type, (Object)other.type) || !Intrinsics.areEqual((Object)this.subtype, (Object)"*") && !Intrinsics.areEqual((Object)this.subtype, (Object)other.subtype)) {
            return false;
        }
        Map<String, String> $this$map$iv = this.parameters;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_10 = $this$mapTo$iv$iv2;
        boolean bl = false;
        Iterator iterator = var8_10.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            string2 = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string2);
        }
        Set paramsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map<String, String> $this$map$iv2 = other.parameters;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        void var9_13 = $this$mapTo$iv$iv;
        boolean bl3 = false;
        Iterator iterator2 = var9_13.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            string2 = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string2);
        }
        Set otherParamsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return otherParamsSet.containsAll(paramsSet);
    }

    public final boolean contains(@Nullable String other) {
        MediaType mediaType2;
        String string2 = other;
        if (string2 == null) {
            mediaType2 = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            mediaType2 = org.readium.r2.shared.util.mediatype.MediaType$Companion.parse$default(Companion, it, null, null, 6, null);
        }
        MediaType mediaType3 = mediaType2;
        if (mediaType3 == null) {
            return false;
        }
        MediaType mediaType4 = mediaType3;
        return this.contains(mediaType4);
    }

    public final boolean matches(@Nullable MediaType other) {
        MediaType mediaType2;
        return this.contains(other) || ((mediaType2 = other) == null ? false : mediaType2.contains(this));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matches(@Nullable String other) {
        MediaType mediaType2;
        MediaType mediaType3 = this;
        String string2 = other;
        if (string2 == null) {
            mediaType2 = null;
        } else {
            void it;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            MediaType mediaType4 = mediaType3;
            boolean bl3 = false;
            MediaType mediaType5 = org.readium.r2.shared.util.mediatype.MediaType$Companion.parse$default(Companion, (String)it, null, null, 6, null);
            mediaType3 = mediaType4;
            mediaType2 = mediaType5;
        }
        return mediaType3.matches(mediaType2);
    }

    public final boolean matchesAny(MediaType ... others) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)others, (String)"others");
            MediaType[] $this$any$iv = others;
            boolean $i$f$any = false;
            MediaType[] mediaTypeArray = $this$any$iv;
            int n = mediaTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MediaType element$iv;
                MediaType it = element$iv = mediaTypeArray[i];
                boolean bl2 = false;
                if (!this.matches(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean matchesAny(String ... others) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)others, (String)"others");
            String[] $this$any$iv = others;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!this.matches(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean isZip() {
        MediaType[] mediaTypeArray = new MediaType[]{ZIP, LCP_PROTECTED_AUDIOBOOK, LCP_PROTECTED_PDF};
        return this.matchesAny(mediaTypeArray) || Intrinsics.areEqual((Object)this.getStructuredSyntaxSuffix(), (Object)"+zip");
    }

    public final boolean isJson() {
        return this.matches(JSON) || Intrinsics.areEqual((Object)this.getStructuredSyntaxSuffix(), (Object)"+json");
    }

    public final boolean isOpds() {
        MediaType[] mediaTypeArray = new MediaType[]{OPDS1, OPDS1_ENTRY, OPDS2, OPDS2_PUBLICATION, OPDS_AUTHENTICATION};
        return this.matchesAny(mediaTypeArray);
    }

    public final boolean isHtml() {
        MediaType[] mediaTypeArray = new MediaType[]{HTML, XHTML};
        return this.matchesAny(mediaTypeArray);
    }

    public final boolean isBitmap() {
        MediaType[] mediaTypeArray = new MediaType[]{BMP, GIF, JPEG, PNG, TIFF, WEBP};
        return this.matchesAny(mediaTypeArray);
    }

    public final boolean isAudio() {
        return Intrinsics.areEqual((Object)this.type, (Object)"audio");
    }

    public final boolean isVideo() {
        return Intrinsics.areEqual((Object)this.type, (Object)"video");
    }

    public final boolean isRwpm() {
        MediaType[] mediaTypeArray = new MediaType[]{READIUM_AUDIOBOOK_MANIFEST, DIVINA_MANIFEST, READIUM_WEBPUB_MANIFEST};
        return this.matchesAny(mediaTypeArray);
    }

    public final boolean isPublication() {
        MediaType[] mediaTypeArray = new MediaType[]{READIUM_AUDIOBOOK, READIUM_AUDIOBOOK_MANIFEST, CBZ, DIVINA, DIVINA_MANIFEST, EPUB, LCP_PROTECTED_AUDIOBOOK, LCP_PROTECTED_PDF, LPF, PDF, W3C_WPUB_MANIFEST, READIUM_WEBPUB, READIUM_WEBPUB_MANIFEST, ZAB};
        return this.matchesAny(mediaTypeArray);
    }

    @NotNull
    public final MediaType getMediaType() {
        return this;
    }

    @Deprecated(message="Format and MediaType got merged together", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getMediaType$annotations() {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0003\b\u008c\u0001\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0080\u0001\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u009b\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009c\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0007\u00f8\u0001\u0000J\u0086\u0001\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u009b\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009c\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0007\u00f8\u0001\u0000J\u0083\u0001\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0007\u00f8\u0001\u0000J\u0089\u0001\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0007\u00f8\u0001\u0000Jy\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0007\u00f8\u0001\u0000J\u007f\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0007\u00f8\u0001\u0000Jv\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00aa\u0001J|\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ab\u0001J\u0086\u0001\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u00042\n\u0010\u00ac\u0001\u001a\u0005\u0018\u00010\u00ad\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012A\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ae\u0001J\u0087\u0001\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u009b\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009c\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b0\u0001J\u008d\u0001\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u00042\u000f\u0010\u009b\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009c\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b1\u0001J\u0080\u0001\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b3\u0001J\u0086\u0001\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b4\u0001J\u0080\u0001\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00b5\u0001\u001a\u00030\u009f\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b6\u0001J\u0086\u0001\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00b5\u0001\u001a\u00030\u009f\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b7\u0001J\u008a\u0001\u0010\u00b8\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u00012\f\b\u0002\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b9\u0001J\u0090\u0001\u0010\u00b8\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u00012\u000f\u0010\u00a2\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012\u000f\u0010\u00a3\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u00a1\u00012C\b\u0002\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u00a1\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00ba\u0001J/\u0010\u00bb\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\u00bc\u0001\u001a\u00030\u009f\u00012\f\b\u0002\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u009f\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u001a\u00103\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010\u0002\u001a\u0004\b5\u0010\u0006R\u0011\u00106\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0006R\u0011\u00108\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0006R\u0011\u0010:\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0006R\u0011\u0010<\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0006R\u0011\u0010>\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0006R\u0011\u0010@\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0006R\u0011\u0010B\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0006R\u0011\u0010D\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0006R\u0011\u0010F\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0006R\u0011\u0010H\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0006R\u0011\u0010J\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0006R\u0011\u0010L\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0006R\u001a\u0010N\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bO\u0010\u0002\u001a\u0004\bP\u0010\u0006R\u0011\u0010Q\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0006R\u001a\u0010S\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bT\u0010\u0002\u001a\u0004\bU\u0010\u0006R\u0011\u0010V\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0006R\u0011\u0010X\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0006R\u0011\u0010Z\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0006R\u0011\u0010\\\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u0006R\u0011\u0010^\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u0006R\u0011\u0010`\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\u0006R\u0011\u0010b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\u0006R\u0011\u0010d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\u0006R\u0011\u0010f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\u0006R\u0011\u0010h\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\u0006R\u0011\u0010j\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\u0006R\u0011\u0010l\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\u0006R\u0011\u0010n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010\u0006R\u0011\u0010p\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010\u0006R\u0011\u0010r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010\u0006R\u0011\u0010t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\u0006R\u0011\u0010v\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\u0006R\u0011\u0010x\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010\u0006R\u0011\u0010z\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\u0006R\u0011\u0010|\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010\u0006R\u001b\u0010~\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\r\u0012\u0004\b\u007f\u0010\u0002\u001a\u0005\b\u0080\u0001\u0010\u0006R\u001d\u0010\u0081\u0001\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u0082\u0001\u0010\u0002\u001a\u0005\b\u0083\u0001\u0010\u0006R\u0013\u0010\u0084\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0001\u0010\u0006R\u0013\u0010\u0086\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010\u0006R\u0013\u0010\u0088\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0001\u0010\u0006R\u0013\u0010\u008a\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008b\u0001\u0010\u0006R\u0013\u0010\u008c\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0001\u0010\u0006R\u0013\u0010\u008e\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010\u0006RQ\u0010\u0090\u0001\u001a<\u00127\u00125\b\u0001\u0012\u0017\u0012\u00150\u0093\u0001\u00a2\u0006\u000f\b\u0094\u0001\u0012\n\b\u0095\u0001\u0012\u0005\b\b(\u0096\u0001\u0012\r\u0012\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0097\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0092\u00010\u0091\u0001\u00f8\u0001\u0000\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0098\u0001\u0010\u0099\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00bd\u0001"}, d2={"Lorg/readium/r2/shared/util/mediatype/MediaType$Companion;", "", "()V", "AAC", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "getAAC", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "ACSM", "getACSM", "AIFF", "getAIFF", "AUDIOBOOK", "getAUDIOBOOK$annotations", "getAUDIOBOOK", "AUDIOBOOK_MANIFEST", "getAUDIOBOOK_MANIFEST$annotations", "getAUDIOBOOK_MANIFEST", "AVI", "getAVI", "AVIF", "getAVIF", "BINARY", "getBINARY", "BMP", "getBMP", "CBZ", "getCBZ", "CSS", "getCSS", "DIVINA", "getDIVINA", "DIVINA_MANIFEST", "getDIVINA_MANIFEST", "EPUB", "getEPUB", "GIF", "getGIF", "GZ", "getGZ", "HTML", "getHTML", "JAVASCRIPT", "getJAVASCRIPT", "JPEG", "getJPEG", "JSON", "getJSON", "JSON_PROBLEM_DETAILS", "getJSON_PROBLEM_DETAILS", "JXL", "getJXL", "LCP_LICENSE", "getLCP_LICENSE$annotations", "getLCP_LICENSE", "LCP_LICENSE_DOCUMENT", "getLCP_LICENSE_DOCUMENT", "LCP_PROTECTED_AUDIOBOOK", "getLCP_PROTECTED_AUDIOBOOK", "LCP_PROTECTED_PDF", "getLCP_PROTECTED_PDF", "LCP_STATUS_DOCUMENT", "getLCP_STATUS_DOCUMENT", "LPF", "getLPF", "MP3", "getMP3", "MPEG", "getMPEG", "NCX", "getNCX", "OGG", "getOGG", "OGV", "getOGV", "OPDS1", "getOPDS1", "OPDS1_ENTRY", "getOPDS1_ENTRY", "OPDS1_FEED", "getOPDS1_FEED$annotations", "getOPDS1_FEED", "OPDS2", "getOPDS2", "OPDS2_FEED", "getOPDS2_FEED$annotations", "getOPDS2_FEED", "OPDS2_PUBLICATION", "getOPDS2_PUBLICATION", "OPDS_AUTHENTICATION", "getOPDS_AUTHENTICATION", "OPUS", "getOPUS", "OTF", "getOTF", "PDF", "getPDF", "PNG", "getPNG", "READIUM_AUDIOBOOK", "getREADIUM_AUDIOBOOK", "READIUM_AUDIOBOOK_MANIFEST", "getREADIUM_AUDIOBOOK_MANIFEST", "READIUM_WEBPUB", "getREADIUM_WEBPUB", "READIUM_WEBPUB_MANIFEST", "getREADIUM_WEBPUB_MANIFEST", "SMIL", "getSMIL", "SVG", "getSVG", "TEXT", "getTEXT", "TIFF", "getTIFF", "TTF", "getTTF", "W3C_WPUB_MANIFEST", "getW3C_WPUB_MANIFEST", "WAV", "getWAV", "WEBM_AUDIO", "getWEBM_AUDIO", "WEBM_VIDEO", "getWEBM_VIDEO", "WEBP", "getWEBP", "WEBPUB", "getWEBPUB$annotations", "getWEBPUB", "WEBPUB_MANIFEST", "getWEBPUB_MANIFEST$annotations", "getWEBPUB_MANIFEST", "WOFF", "getWOFF", "WOFF2", "getWOFF2", "XHTML", "getXHTML", "XML", "getXML", "ZAB", "getZAB", "ZIP", "getZIP", "sniffers", "", "Lkotlin/Function2;", "Lorg/readium/r2/shared/util/mediatype/SnifferContext;", "Lkotlin/ParameterName;", "name", "context", "Lkotlin/coroutines/Continuation;", "getSniffers", "()Ljava/util/List;", "of", "bytes", "Lkotlin/Function0;", "", "mediaType", "", "fileExtension", "", "mediaTypes", "fileExtensions", "uri", "Landroid/net/Uri;", "contentResolver", "Landroid/content/ContentResolver;", "file", "Ljava/io/File;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "content", "Lorg/readium/r2/shared/util/mediatype/SnifferContent;", "(Lorg/readium/r2/shared/util/mediatype/SnifferContent;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofBytes", "(Lkotlin/jvm/functions/Function0;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function0;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofFile", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ofUri", "(Landroid/net/Uri;Landroid/content/ContentResolver;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Landroid/net/Uri;Landroid/content/ContentResolver;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parse", "string", "shared_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MediaType parse(@NotNull String string2, @Nullable String name, @Nullable String fileExtension) {
            MediaType mediaType2;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
            boolean $i$f$tryOrNull = false;
            MediaType default$iv$iv = null;
            boolean $i$f$tryOr = false;
            try {
                boolean bl = false;
                mediaType2 = new MediaType(string2, name, fileExtension);
            }
            catch (Exception e$iv$iv) {
                mediaType2 = default$iv$iv;
            }
            return mediaType2;
        }

        public static /* synthetic */ MediaType parse$default(Companion companion, String string2, String string3, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                string4 = null;
            }
            return companion.parse(string2, string3, string4);
        }

        @NotNull
        public final MediaType getAAC() {
            return AAC;
        }

        @NotNull
        public final MediaType getACSM() {
            return ACSM;
        }

        @NotNull
        public final MediaType getAIFF() {
            return AIFF;
        }

        @NotNull
        public final MediaType getAVI() {
            return AVI;
        }

        @NotNull
        public final MediaType getAVIF() {
            return AVIF;
        }

        @NotNull
        public final MediaType getBINARY() {
            return BINARY;
        }

        @NotNull
        public final MediaType getBMP() {
            return BMP;
        }

        @NotNull
        public final MediaType getCBZ() {
            return CBZ;
        }

        @NotNull
        public final MediaType getCSS() {
            return CSS;
        }

        @NotNull
        public final MediaType getDIVINA() {
            return DIVINA;
        }

        @NotNull
        public final MediaType getDIVINA_MANIFEST() {
            return DIVINA_MANIFEST;
        }

        @NotNull
        public final MediaType getEPUB() {
            return EPUB;
        }

        @NotNull
        public final MediaType getGIF() {
            return GIF;
        }

        @NotNull
        public final MediaType getGZ() {
            return GZ;
        }

        @NotNull
        public final MediaType getHTML() {
            return HTML;
        }

        @NotNull
        public final MediaType getJAVASCRIPT() {
            return JAVASCRIPT;
        }

        @NotNull
        public final MediaType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final MediaType getJSON() {
            return JSON;
        }

        @NotNull
        public final MediaType getJSON_PROBLEM_DETAILS() {
            return JSON_PROBLEM_DETAILS;
        }

        @NotNull
        public final MediaType getJXL() {
            return JXL;
        }

        @NotNull
        public final MediaType getLCP_LICENSE_DOCUMENT() {
            return LCP_LICENSE_DOCUMENT;
        }

        @NotNull
        public final MediaType getLCP_PROTECTED_AUDIOBOOK() {
            return LCP_PROTECTED_AUDIOBOOK;
        }

        @NotNull
        public final MediaType getLCP_PROTECTED_PDF() {
            return LCP_PROTECTED_PDF;
        }

        @NotNull
        public final MediaType getLCP_STATUS_DOCUMENT() {
            return LCP_STATUS_DOCUMENT;
        }

        @NotNull
        public final MediaType getLPF() {
            return LPF;
        }

        @NotNull
        public final MediaType getMP3() {
            return MP3;
        }

        @NotNull
        public final MediaType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final MediaType getNCX() {
            return NCX;
        }

        @NotNull
        public final MediaType getOGG() {
            return OGG;
        }

        @NotNull
        public final MediaType getOGV() {
            return OGV;
        }

        @NotNull
        public final MediaType getOPDS1() {
            return OPDS1;
        }

        @NotNull
        public final MediaType getOPDS1_ENTRY() {
            return OPDS1_ENTRY;
        }

        @NotNull
        public final MediaType getOPDS2() {
            return OPDS2;
        }

        @NotNull
        public final MediaType getOPDS2_PUBLICATION() {
            return OPDS2_PUBLICATION;
        }

        @NotNull
        public final MediaType getOPDS_AUTHENTICATION() {
            return OPDS_AUTHENTICATION;
        }

        @NotNull
        public final MediaType getOPUS() {
            return OPUS;
        }

        @NotNull
        public final MediaType getOTF() {
            return OTF;
        }

        @NotNull
        public final MediaType getPDF() {
            return PDF;
        }

        @NotNull
        public final MediaType getPNG() {
            return PNG;
        }

        @NotNull
        public final MediaType getREADIUM_AUDIOBOOK() {
            return READIUM_AUDIOBOOK;
        }

        @NotNull
        public final MediaType getREADIUM_AUDIOBOOK_MANIFEST() {
            return READIUM_AUDIOBOOK_MANIFEST;
        }

        @NotNull
        public final MediaType getREADIUM_WEBPUB() {
            return READIUM_WEBPUB;
        }

        @NotNull
        public final MediaType getREADIUM_WEBPUB_MANIFEST() {
            return READIUM_WEBPUB_MANIFEST;
        }

        @NotNull
        public final MediaType getSMIL() {
            return SMIL;
        }

        @NotNull
        public final MediaType getSVG() {
            return SVG;
        }

        @NotNull
        public final MediaType getTEXT() {
            return TEXT;
        }

        @NotNull
        public final MediaType getTIFF() {
            return TIFF;
        }

        @NotNull
        public final MediaType getTTF() {
            return TTF;
        }

        @NotNull
        public final MediaType getW3C_WPUB_MANIFEST() {
            return W3C_WPUB_MANIFEST;
        }

        @NotNull
        public final MediaType getWAV() {
            return WAV;
        }

        @NotNull
        public final MediaType getWEBM_AUDIO() {
            return WEBM_AUDIO;
        }

        @NotNull
        public final MediaType getWEBM_VIDEO() {
            return WEBM_VIDEO;
        }

        @NotNull
        public final MediaType getWEBP() {
            return WEBP;
        }

        @NotNull
        public final MediaType getWOFF() {
            return WOFF;
        }

        @NotNull
        public final MediaType getWOFF2() {
            return WOFF2;
        }

        @NotNull
        public final MediaType getXHTML() {
            return XHTML;
        }

        @NotNull
        public final MediaType getXML() {
            return XML;
        }

        @NotNull
        public final MediaType getZAB() {
            return ZAB;
        }

        @NotNull
        public final MediaType getZIP() {
            return ZIP;
        }

        @NotNull
        public final List<Function2<SnifferContext, Continuation<? super MediaType>, Object>> getSniffers() {
            return sniffers;
        }

        @Nullable
        public final Object of(@Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.of(null, CollectionsKt.listOfNotNull((Object)mediaType2), (List<String>)CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object of$default(Companion companion, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of(string2, string3, list, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object of(@NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.of(null, mediaTypes, fileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object of$default(Companion companion, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 4) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of(list, (List<String>)list2, list3, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull File file, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.ofFile(file, (List<String>)CollectionsKt.listOfNotNull((Object)mediaType2), (List<String>)CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, File file, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofFile(file, string2, string3, list, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull File file, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.of(new SnifferFileContent(file), mediaTypes, (List<String>)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FilesKt.getExtension((File)file)), (Iterable)fileExtensions), sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, File file, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofFile(file, (List<String>)list, (List<String>)list2, list3, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull String path, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.ofFile(new File(path), mediaType2, fileExtension, sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, String string2, String string3, String string4, List list, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                string4 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofFile(string2, string3, string4, list, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofFile(@NotNull String path, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.ofFile(new File(path), mediaTypes, fileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object ofFile$default(Companion companion, String string2, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofFile(string2, (List<String>)list, (List<String>)list2, list3, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofBytes(@NotNull Function0<byte[]> bytes2, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.ofBytes(bytes2, CollectionsKt.listOfNotNull((Object)mediaType2), CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object ofBytes$default(Companion companion, Function0 function0, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofBytes((Function0<byte[]>)function0, string2, string3, list, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofBytes(@NotNull Function0<byte[]> bytes2, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.of(new SnifferBytesContent(bytes2), mediaTypes, fileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object ofBytes$default(Companion companion, Function0 function0, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofBytes((Function0<byte[]>)function0, list, list2, list3, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofUri(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            return this.ofUri(uri, contentResolver, CollectionsKt.listOfNotNull((Object)mediaType2), CollectionsKt.listOfNotNull((Object)fileExtension), sniffers, $completion);
        }

        public static /* synthetic */ Object ofUri$default(Companion companion, Uri uri, ContentResolver contentResolver, String string2, String string3, List list, Continuation continuation, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                list = Companion.getSniffers();
            }
            return companion.ofUri(uri, contentResolver, string2, string3, list, (Continuation<? super MediaType>)continuation);
        }

        @Nullable
        public final Object ofUri(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers, @NotNull Continuation<? super MediaType> $completion) {
            CharSequence charSequence;
            List allMediaTypes = CollectionsKt.toMutableList((Collection)mediaTypes);
            List allFileExtensions = CollectionsKt.toMutableList((Collection)fileExtensions);
            CharSequence charSequence2 = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            boolean bl = false;
            CharSequence charSequence3 = charSequence2;
            boolean bl2 = false;
            if (charSequence3.length() == 0) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String string2 = (String)charSequence;
            if (string2 != null) {
                charSequence2 = string2;
                bl = false;
                boolean bl4 = false;
                CharSequence it = charSequence2;
                boolean bl5 = false;
                allFileExtensions.add(0, it);
            }
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
                string2 = contentResolver.getType(uri);
                if (string2 != null) {
                    CharSequence charSequence4 = string2;
                    boolean bl6 = false;
                    boolean it = false;
                    String it2 = charSequence4;
                    boolean bl7 = false;
                    CharSequence charSequence5 = charSequence2 = !Companion.getBINARY().matches(it2) ? charSequence4 : null;
                    if (charSequence2 != null) {
                        charSequence4 = charSequence2;
                        bl6 = false;
                        it = false;
                        it2 = charSequence4;
                        boolean bl8 = false;
                        allMediaTypes.add(0, it2);
                    }
                }
                string2 = ContentResolverKt.queryProjection(contentResolver, uri, "_display_name");
                if (string2 != null) {
                    charSequence2 = string2;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    CharSequence filename = charSequence2;
                    boolean bl11 = false;
                    allFileExtensions.add(0, FilesKt.getExtension((File)new File((String)filename)));
                }
            }
            SnifferUriContent content = new SnifferUriContent(uri, contentResolver);
            return this.of(content, allMediaTypes, (List<String>)allFileExtensions, sniffers, $completion);
        }

        public static /* synthetic */ Object ofUri$default(Companion companion, Uri uri, ContentResolver contentResolver, List list, List list2, List list3, Continuation continuation, int n, Object object) {
            if ((n & 0x10) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.ofUri(uri, contentResolver, list, list2, list3, (Continuation<? super MediaType>)continuation);
        }

        /*
         * Unable to fully structure code
         */
        private final Object of(SnifferContent var1_1, List<String> var2_2, List<String> var3_3, List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> var4_4, Continuation<? super MediaType> var5_5) {
            block19: {
                block18: {
                    if (!(var5_5 instanceof of.3)) ** GOTO lbl-1000
                    var16_6 = var5_5;
                    if ((var16_6.label & -2147483648) != 0) {
                        var16_6.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var5_5){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            /* synthetic */ Object result;
                            final /* synthetic */ Companion this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return org.readium.r2.shared.util.mediatype.MediaType$Companion.access$of(this.this$0, null, null, null, null, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var17_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var6_9 = mediaTypes;
                            var7_10 = false;
                            if (!(var6_9.isEmpty() == false)) break;
                            context = new SnifferContext(null, mediaTypes, null, 5, null);
                            var7_11 = sniffers.iterator();
lbl17:
                            // 2 sources

                            while (var7_11.hasNext()) {
                                sniffer = (Function2)var7_11.next();
                                $continuation.L$0 = this;
                                $continuation.L$1 = content;
                                $continuation.L$2 = mediaTypes;
                                $continuation.L$3 = fileExtensions;
                                $continuation.L$4 = sniffers;
                                $continuation.L$5 = context;
                                $continuation.L$6 = var7_11;
                                $continuation.label = 1;
                                v0 = sniffer.invoke(context, $continuation);
                                if (v0 == var17_8) {
                                    return var17_8;
                                }
                                ** GOTO lbl42
                            }
                            break;
                        }
                        case 1: {
                            var7_11 = (Iterator<E>)$continuation.L$6;
                            context = (SnifferContext)$continuation.L$5;
                            sniffers = (List)$continuation.L$4;
                            fileExtensions = (List)$continuation.L$3;
                            mediaTypes = (List)$continuation.L$2;
                            content = (SnifferContent)$continuation.L$1;
                            this = (Companion)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl42:
                            // 2 sources

                            if ((mediaType = (MediaType)v0) == null) ** GOTO lbl17
                            return mediaType;
                        }
                    }
                    context = fileExtensions;
                    var7_10 = false;
                    if (!(context.isEmpty() == false)) break block18;
                    context = new SnifferContext(null, mediaTypes, fileExtensions, 1, null);
                    var7_12 = sniffers.iterator();
lbl49:
                    // 2 sources

                    while (var7_12.hasNext()) {
                        sniffer = (Function2)var7_12.next();
                        $continuation.L$0 = this;
                        $continuation.L$1 = content;
                        $continuation.L$2 = mediaTypes;
                        $continuation.L$3 = fileExtensions;
                        $continuation.L$4 = sniffers;
                        $continuation.L$5 = context;
                        $continuation.L$6 = var7_12;
                        $continuation.label = 2;
                        v1 = sniffer.invoke(context, $continuation);
                        if (v1 == var17_8) {
                            return var17_8;
                        }
                        ** GOTO lbl74
                    }
                    {
                        break;
                        case 2: {
                            var7_12 = (Iterator<E>)$continuation.L$6;
                            context = (SnifferContext)$continuation.L$5;
                            sniffers = (List)$continuation.L$4;
                            fileExtensions = (List)$continuation.L$3;
                            mediaTypes = (List)$continuation.L$2;
                            content = (SnifferContent)$continuation.L$1;
                            this = (Companion)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl74:
                            // 2 sources

                            if ((mediaType = (MediaType)v1) == null) ** GOTO lbl49
                            return mediaType;
                        }
                    }
                }
                if (content == null) break block19;
                context = new SnifferContext(content, mediaTypes, fileExtensions);
                var7_13 = sniffers.iterator();
lbl80:
                // 2 sources

                while (var7_13.hasNext()) {
                    sniffer = (Function2)var7_13.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = content;
                    $continuation.L$2 = mediaTypes;
                    $continuation.L$3 = fileExtensions;
                    $continuation.L$4 = context;
                    $continuation.L$5 = var7_13;
                    $continuation.L$6 = null;
                    $continuation.label = 3;
                    v2 = sniffer.invoke(context, $continuation);
                    if (v2 == var17_8) {
                        return var17_8;
                    }
                    ** GOTO lbl104
                }
                {
                    break;
                    case 3: {
                        var7_13 = (Iterator<E>)$continuation.L$5;
                        context = (SnifferContext)$continuation.L$4;
                        fileExtensions = (List)$continuation.L$3;
                        mediaTypes = (List)$continuation.L$2;
                        content = (SnifferContent)$continuation.L$1;
                        this = (Companion)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl104:
                        // 2 sources

                        if ((mediaType = (MediaType)v2) == null) ** GOTO lbl80
                        return mediaType;
                    }
                }
            }
            context = new SnifferContext(content, mediaTypes, fileExtensions);
            $continuation.L$0 = this;
            $continuation.L$1 = mediaTypes;
            $continuation.L$2 = null;
            $continuation.L$3 = null;
            $continuation.L$4 = null;
            $continuation.L$5 = null;
            $continuation.L$6 = null;
            $continuation.label = 4;
            v3 = Sniffers.INSTANCE.system((SnifferContext)context, (Continuation<? super MediaType>)$continuation);
            if (v3 == var17_8) {
                return var17_8;
            }
            ** GOTO lbl125
            {
                case 4: {
                    mediaTypes = (List)$continuation.L$1;
                    this = (Companion)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl125:
                    // 2 sources

                    if ((var7_14 = (MediaType)v3) != null) {
                        sniffer = var7_14;
                        var9_17 = false;
                        var10_18 = false;
                        it = sniffer;
                        $i$a$-let-MediaType$Companion$of$4 = false;
                        return it;
                    }
                    for (String mediaType : mediaTypes) {
                        var9_16 = org.readium.r2.shared.util.mediatype.MediaType$Companion.parse$default(this, mediaType, null, null, 6, null);
                        if (var9_16 == null) continue;
                        var10_19 = var9_16;
                        var11_21 = false;
                        var12_23 = false;
                        it = var10_19;
                        $i$a$-let-MediaType$Companion$of$5 = false;
                        return it;
                    }
                    return null;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final MediaType getAUDIOBOOK() {
            return this.getREADIUM_AUDIOBOOK();
        }

        @Deprecated(message="Use [READIUM_AUDIOBOOK] instead", replaceWith=@ReplaceWith(expression="MediaType.READIUM_AUDIOBOOK", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getAUDIOBOOK$annotations() {
        }

        @NotNull
        public final MediaType getAUDIOBOOK_MANIFEST() {
            return this.getREADIUM_AUDIOBOOK_MANIFEST();
        }

        @Deprecated(message="Use [READIUM_AUDIOBOOK_MANIFEST] instead", replaceWith=@ReplaceWith(expression="MediaType.READIUM_AUDIOBOOK_MANIFEST", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getAUDIOBOOK_MANIFEST$annotations() {
        }

        @NotNull
        public final MediaType getWEBPUB() {
            return this.getREADIUM_WEBPUB();
        }

        @Deprecated(message="Use [READIUM_WEBPUB] instead", replaceWith=@ReplaceWith(expression="MediaType.READIUM_WEBPUB", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getWEBPUB$annotations() {
        }

        @NotNull
        public final MediaType getWEBPUB_MANIFEST() {
            return this.getREADIUM_WEBPUB_MANIFEST();
        }

        @Deprecated(message="Use [READIUM_WEBPUB_MANIFEST] instead", replaceWith=@ReplaceWith(expression="MediaType.READIUM_WEBPUB_MANIFEST", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getWEBPUB_MANIFEST$annotations() {
        }

        @NotNull
        public final MediaType getOPDS1_FEED() {
            return this.getOPDS1();
        }

        @Deprecated(message="Use [OPDS1] instead", replaceWith=@ReplaceWith(expression="MediaType.OPDS1", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getOPDS1_FEED$annotations() {
        }

        @NotNull
        public final MediaType getOPDS2_FEED() {
            return this.getOPDS2();
        }

        @Deprecated(message="Use [OPDS2] instead", replaceWith=@ReplaceWith(expression="MediaType.OPDS2", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getOPDS2_FEED$annotations() {
        }

        @NotNull
        public final MediaType getLCP_LICENSE() {
            return this.getLCP_LICENSE_DOCUMENT();
        }

        @Deprecated(message="Use [LCP_LICENSE_DOCUMENT] instead", replaceWith=@ReplaceWith(expression="MediaType.LCP_LICENSE_DOCUMENT", imports={}), level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getLCP_LICENSE$annotations() {
        }

        @Deprecated(message="Renamed to [ofFile()]", replaceWith=@ReplaceWith(expression="MediaType.ofFile(file, mediaType, fileExtension, sniffers)", imports={}), level=DeprecationLevel.ERROR)
        @Nullable
        public final MediaType of(@NotNull File file, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(sniffers, (String)"sniffers");
            return null;
        }

        public static /* synthetic */ MediaType of$default(Companion companion, File file, String string2, String string3, List list, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of(file, string2, string3, list);
        }

        @Deprecated(message="Renamed to [ofFile()]", replaceWith=@ReplaceWith(expression="MediaType.ofFile(file, mediaTypes, fileExtensions, sniffers)", imports={}), level=DeprecationLevel.ERROR)
        @Nullable
        public final MediaType of(@NotNull File file, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkNotNullParameter(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkNotNullParameter(sniffers, (String)"sniffers");
            return null;
        }

        public static /* synthetic */ MediaType of$default(Companion companion, File file, List list, List list2, List list3, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of(file, (List<String>)list, (List<String>)list2, list3);
        }

        @Deprecated(message="Renamed to [ofBytes()]", replaceWith=@ReplaceWith(expression="MediaType.ofBytes(bytes, mediaType, fileExtension, sniffers)", imports={}), level=DeprecationLevel.ERROR)
        @Nullable
        public final MediaType of(@NotNull Function0<byte[]> bytes2, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers) {
            Intrinsics.checkNotNullParameter(bytes2, (String)"bytes");
            Intrinsics.checkNotNullParameter(sniffers, (String)"sniffers");
            return null;
        }

        public static /* synthetic */ MediaType of$default(Companion companion, Function0 function0, String string2, String string3, List list, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of((Function0<byte[]>)function0, string2, string3, list);
        }

        @Deprecated(message="Renamed to [ofBytes()]", replaceWith=@ReplaceWith(expression="MediaType.ofBytes(bytes, mediaTypes, fileExtensions, sniffers)", imports={}), level=DeprecationLevel.ERROR)
        @Nullable
        public final MediaType of(@NotNull Function0<byte[]> bytes2, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers) {
            Intrinsics.checkNotNullParameter(bytes2, (String)"bytes");
            Intrinsics.checkNotNullParameter(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkNotNullParameter(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkNotNullParameter(sniffers, (String)"sniffers");
            return null;
        }

        public static /* synthetic */ MediaType of$default(Companion companion, Function0 function0, List list, List list2, List list3, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of((Function0<byte[]>)function0, (List<String>)list, (List<String>)list2, list3);
        }

        @Deprecated(message="Renamed to [ofUri()]", replaceWith=@ReplaceWith(expression="MediaType.ofUri(uri, contentResolver, mediaType, fileExtension, sniffers)", imports={}), level=DeprecationLevel.ERROR)
        @Nullable
        public final MediaType of(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @Nullable String mediaType2, @Nullable String fileExtension, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
            Intrinsics.checkNotNullParameter(sniffers, (String)"sniffers");
            return null;
        }

        public static /* synthetic */ MediaType of$default(Companion companion, Uri uri, ContentResolver contentResolver, String string2, String string3, List list, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                list = Companion.getSniffers();
            }
            return companion.of(uri, contentResolver, string2, string3, list);
        }

        @Deprecated(message="Renamed to [ofUri()]", replaceWith=@ReplaceWith(expression="MediaType.ofUri(uri, contentResolver, mediaTypes, fileExtensions, sniffers)", imports={}), level=DeprecationLevel.ERROR)
        @Nullable
        public final MediaType of(@NotNull Uri uri, @NotNull ContentResolver contentResolver, @NotNull List<String> mediaTypes, @NotNull List<String> fileExtensions, @NotNull List<? extends Function2<? super SnifferContext, ? super Continuation<? super MediaType>, ? extends Object>> sniffers) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
            Intrinsics.checkNotNullParameter(mediaTypes, (String)"mediaTypes");
            Intrinsics.checkNotNullParameter(fileExtensions, (String)"fileExtensions");
            Intrinsics.checkNotNullParameter(sniffers, (String)"sniffers");
            return null;
        }

        public static /* synthetic */ MediaType of$default(Companion companion, Uri uri, ContentResolver contentResolver, List list, List list2, List list3, int n, Object object) {
            if ((n & 0x10) != 0) {
                list3 = Companion.getSniffers();
            }
            return companion.of(uri, contentResolver, (List<String>)list, list2, list3);
        }

        public static final /* synthetic */ Object access$of(Companion $this, SnifferContent content, List mediaTypes, List fileExtensions, List sniffers, Continuation $completion) {
            return $this.of(content, mediaTypes, (List<String>)fileExtensions, sniffers, (Continuation<? super MediaType>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

