/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.PrintStream;
import java.util.List;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTVersion;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;

public class HDT2RDF
implements ProgressListener {
    @Parameter(description="<input HDT> <output NT>")
    public List<String> parameters = Lists.newArrayList();
    @Parameter(names={"-version"}, description="Prints the HDT version number")
    public static boolean showVersion;
    public String hdtInput;
    public String rdfOutput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        PrintStream out = null;
        out = this.rdfOutput.equals("stdout") ? System.out : new PrintStream(this.rdfOutput, "UTF-8");
        try (HDT hdt = HDTManager.mapHDT((String)this.hdtInput, (ProgressListener)this);){
            IteratorTripleString it = hdt.search((CharSequence)"", (CharSequence)"", (CharSequence)"");
            StringBuilder build = new StringBuilder(1024);
            while (it.hasNext()) {
                TripleString triple = (TripleString)it.next();
                build.delete(0, build.length());
                triple.dumpNtriple((Appendable)build);
                out.print(build);
            }
            if (!this.rdfOutput.equals("stdout")) {
                out.close();
            }
        }
    }

    public void notifyProgress(float level, String message) {
    }

    public static void main(String[] args) throws Throwable {
        HDT2RDF hdt2rdf = new HDT2RDF();
        JCommander com = new JCommander((Object)hdt2rdf, args);
        com.setProgramName("hdt2rdf");
        if (showVersion) {
            System.out.println(HDTVersion.get_version_string((String)"."));
            System.exit(0);
        }
        try {
            hdt2rdf.hdtInput = hdt2rdf.parameters.get(0);
        }
        catch (Exception e) {
            com.usage();
            System.exit(1);
        }
        try {
            hdt2rdf.rdfOutput = hdt2rdf.parameters.get(1);
        }
        catch (Exception e) {
            hdt2rdf.rdfOutput = "stdout";
        }
        System.err.println("Converting " + hdt2rdf.hdtInput + " to RDF on " + hdt2rdf.rdfOutput);
        hdt2rdf.execute();
    }
}

