/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples;

import java.io.Serializable;
import org.rdfhdt.hdt.util.LongCompare;

public final class TripleID
implements Comparable<TripleID>,
Serializable {
    private static final long serialVersionUID = -4685524566493494912L;
    private long subject;
    private long predicate;
    private long object;

    public TripleID() {
    }

    public TripleID(long subject, long predicate, long object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public TripleID(TripleID other) {
        this.subject = other.subject;
        this.predicate = other.predicate;
        this.object = other.object;
    }

    public long getSubject() {
        return this.subject;
    }

    public void setSubject(long subject) {
        this.subject = subject;
    }

    public long getObject() {
        return this.object;
    }

    public void setObject(long object) {
        this.object = object;
    }

    public long getPredicate() {
        return this.predicate;
    }

    public void setPredicate(long predicate) {
        this.predicate = predicate;
    }

    public void setAll(long subject, long predicate, long object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public void assign(TripleID replacement) {
        this.subject = replacement.getSubject();
        this.object = replacement.getObject();
        this.predicate = replacement.getPredicate();
    }

    public void clear() {
        this.object = 0L;
        this.predicate = 0L;
        this.subject = 0L;
    }

    public String toString() {
        return Long.toString(this.subject) + " " + this.predicate + " " + this.object;
    }

    @Override
    public int compareTo(TripleID other) {
        int result = LongCompare.compare(this.subject, other.subject);
        if (result == 0) {
            result = LongCompare.compare(this.predicate, other.predicate);
            if (result == 0) {
                return LongCompare.compare(this.object, other.object);
            }
            return result;
        }
        return result;
    }

    public boolean match(TripleID pattern) {
        long subjectPattern = pattern.getSubject();
        long predicatePattern = pattern.getPredicate();
        long objectPattern = pattern.getObject();
        return !(subjectPattern != 0L && this.subject != subjectPattern || predicatePattern != 0L && this.predicate != predicatePattern || objectPattern != 0L && this.object != objectPattern);
    }

    public boolean isEmpty() {
        return this.subject == 0L && this.predicate == 0L && this.object == 0L;
    }

    public boolean isValid() {
        return this.subject > 0L && this.predicate > 0L && this.object > 0L;
    }

    public boolean isNoMatch() {
        return this.subject == -1L || this.predicate == -1L || this.object == -1L;
    }

    public String getPatternString() {
        return "" + (this.subject == 0L ? (char)'?' : 'S') + (this.predicate == 0L ? (char)'?' : 'P') + (this.object == 0L ? (char)'?' : 'O');
    }

    public static int size() {
        return 48;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TripleID)) {
            return false;
        }
        TripleID other = (TripleID)o;
        return this.subject == other.subject && this.predicate == other.predicate && this.object == other.object;
    }

    public int hashCode() {
        return (int)(this.subject * 13L + this.predicate * 17L + this.object * 31L);
    }
}

