/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.app.Dialog;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupComponent;
import razerdp.basepopup.BasePopupWindow;

public class BasePopupComponentX
implements BasePopupComponent {
    public View findDecorView(BasePopupWindow basePopupWindow, Activity activity) {
        DialogFragment d;
        if (basePopupWindow.mAttached == null) {
            return null;
        }
        Object object = basePopupWindow.mAttached.get();
        if (object instanceof DialogFragment && (d = (DialogFragment)object).getDialog() != null && d.getDialog().isShowing() && !d.isRemoving()) {
            return d.getView();
        }
        if (object instanceof Dialog && (d = (Dialog)object).isShowing() && d.getWindow() != null) {
            return d.getWindow().getDecorView();
        }
        return null;
    }

    public BasePopupWindow attachLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
        if (!(owner instanceof LifecycleOwner)) {
            return basePopupWindow;
        }
        ((LifecycleOwner)owner).getLifecycle().addObserver((LifecycleObserver)new BasePopupLifeCycleHolder(basePopupWindow));
        return basePopupWindow;
    }

    private class BasePopupLifeCycleHolder
    implements LifecycleEventObserver {
        WeakReference<BasePopupWindow> mBasePopupWindow;

        BasePopupLifeCycleHolder(BasePopupWindow target) {
            this.mBasePopupWindow = new WeakReference<BasePopupWindow>(target);
        }

        BasePopupWindow getPopup() {
            if (this.mBasePopupWindow == null) {
                return null;
            }
            return (BasePopupWindow)this.mBasePopupWindow.get();
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            BasePopupWindow popupWindow = this.getPopup();
            if (event == Lifecycle.Event.ON_DESTROY) {
                if (popupWindow == null) {
                    source.getLifecycle().removeObserver((LifecycleObserver)this);
                    this.mBasePopupWindow = null;
                    return;
                }
                if (popupWindow.isShowing()) {
                    popupWindow.forceDismiss();
                }
                popupWindow.onDestroy();
                this.mBasePopupWindow.clear();
                this.mBasePopupWindow = null;
                source.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        }
    }
}

