/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.PopupMaskLayout;
import razerdp.util.KeyboardUtils;
import razerdp.util.PopupUiUtils;
import razerdp.util.log.PopupLog;

final class PopupDecorViewProxy
extends ViewGroup
implements KeyboardUtils.OnKeyboardChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ClearMemoryObject {
    private static final String TAG = "PopupDecorViewProxy";
    private PopupMaskLayout mMaskLayout;
    private BasePopupHelper mHelper;
    private View mTarget;
    private int changedGravity = 0;
    private Rect popupRect = new Rect();
    private Rect anchorRect = new Rect();
    private int childLeftMargin;
    private int childTopMargin;
    private int childRightMargin;
    private int childBottomMargin;
    private int[] location = new int[2];
    private Rect lastKeyboardBounds = new Rect();
    private boolean isFirstLayoutComplete = false;
    private int layoutCount = 0;
    private View.OnClickListener emptyInterceptClickListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    private PopupDecorViewProxy(Context context) {
        super(context);
    }

    PopupDecorViewProxy(Context context, BasePopupHelper helper) {
        this(context);
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.init(helper);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(BasePopupHelper helper) {
        this.mHelper = helper;
        this.mHelper.mKeyboardStateChangeListener = this;
        this.setClipChildren(this.mHelper.isClipChildren());
        this.mMaskLayout = new PopupMaskLayout(this.getContext(), this.mHelper);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addViewInLayout((View)this.mMaskLayout, -1, new ViewGroup.LayoutParams(-1, -1));
        this.changedGravity = 0;
    }

    public void wrapPopupDecorView(View target, WindowManager.LayoutParams params) {
        if (target == null) {
            throw new NullPointerException("contentView\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (target.getParent() != null) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount >= 2) {
            this.removeViewsInLayout(1, childCount - 1);
        }
        this.mTarget = target;
        target.setOnClickListener(this.emptyInterceptClickListener);
        WindowManager.LayoutParams wp = new WindowManager.LayoutParams();
        wp.copyFrom(params);
        wp.x = 0;
        wp.y = 0;
        View contentView = target.findViewById(this.mHelper.contentRootId);
        if (contentView != null) {
            ViewGroup.LayoutParams lp = contentView.getLayoutParams();
            if (lp == null) {
                lp = new FrameLayout.LayoutParams(this.mHelper.getLayoutParams());
            } else {
                lp.width = this.mHelper.getLayoutParams().width;
                lp.height = this.mHelper.getLayoutParams().height;
                if (lp instanceof ViewGroup.MarginLayoutParams) {
                    ((ViewGroup.MarginLayoutParams)lp).leftMargin = this.mHelper.getLayoutParams().leftMargin;
                    ((ViewGroup.MarginLayoutParams)lp).topMargin = this.mHelper.getLayoutParams().topMargin;
                    ((ViewGroup.MarginLayoutParams)lp).rightMargin = this.mHelper.getLayoutParams().rightMargin;
                    ((ViewGroup.MarginLayoutParams)lp).bottomMargin = this.mHelper.getLayoutParams().bottomMargin;
                }
            }
            View parent = (View)contentView.getParent();
            if (PopupUiUtils.isPopupBackgroundView(parent)) {
                ViewGroup.LayoutParams p = parent.getLayoutParams();
                if (p == null) {
                    p = new ViewGroup.LayoutParams(lp);
                } else {
                    p.width = lp.width;
                    p.height = lp.height;
                }
                parent.setLayoutParams(p);
            }
            contentView.setLayoutParams(lp);
            if (contentView.isFocusable()) {
                if (contentView instanceof ViewGroup) {
                    ((ViewGroup)contentView).setDescendantFocusability(262144);
                }
                PopupUiUtils.requestFocus(contentView);
            }
            if (this.mHelper.isAutoShowInputMethod()) {
                EditText focusTarget = this.mHelper.mAutoShowInputEdittext;
                if (focusTarget == null) {
                    focusTarget = contentView.findFocus();
                }
                KeyboardUtils.open((View)(focusTarget == null ? contentView : focusTarget), 350L);
            }
        }
        wp.width = this.mHelper.getLayoutParams().width;
        wp.height = this.mHelper.getLayoutParams().height;
        this.childLeftMargin = this.mHelper.getLayoutParams().leftMargin;
        this.childTopMargin = this.mHelper.getLayoutParams().topMargin;
        this.childRightMargin = this.mHelper.getLayoutParams().rightMargin;
        this.childBottomMargin = this.mHelper.getLayoutParams().bottomMargin;
        this.addView(target, (ViewGroup.LayoutParams)wp);
    }

    private boolean isSystemPopupContainer(View v) {
        return PopupUiUtils.isPopupDecorView(v) && PopupUiUtils.isPopupBackgroundView(v) && PopupUiUtils.isPopupViewContainer(v);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        PopupLog.i("onMeasure", View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mMaskLayout) {
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                continue;
            }
            this.measureWrappedDecorView(child, widthMeasureSpec, heightMeasureSpec);
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    private void measureWrappedDecorView(View mTarget, int widthMeasureSpec, int heightMeasureSpec) {
        boolean isAlignAnchorMode;
        if (mTarget == null || mTarget.getVisibility() == 8) {
            return;
        }
        ViewGroup.LayoutParams lp = mTarget.getLayoutParams();
        widthMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
        heightMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int gravity = this.mHelper.getPopupGravity();
        boolean bl = isAlignAnchorMode = this.mHelper.getGravityMode() == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
        if (this.mHelper.isWithAnchor()) {
            Rect anchorBound = this.mHelper.getAnchorViewBound();
            int rl = anchorBound.left;
            int rt = anchorBound.top;
            int rr = widthSize - anchorBound.right;
            int rb = heightSize - anchorBound.bottom;
            if (isAlignAnchorMode) {
                rl = widthSize - anchorBound.left;
                rt = heightSize - anchorBound.top;
                rr = anchorBound.right;
                rb = anchorBound.bottom;
            }
            rb -= this.mHelper.getNavigationBarHeight();
            switch (gravity & 7) {
                case 3: {
                    if (lp.width == -1) {
                        widthSize = rl;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    widthSize = Math.min(widthSize, rl);
                    break;
                }
                case 5: {
                    if (lp.width == -1) {
                        widthSize = rr;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    widthSize = Math.min(widthSize, rr);
                    break;
                }
            }
            switch (gravity & 0x70) {
                case 48: {
                    if (lp.height == -1) {
                        heightSize = rt;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    heightSize = Math.min(heightSize, rt);
                    break;
                }
                case 80: {
                    if (lp.height == -1) {
                        heightSize = rb;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    heightSize = Math.min(heightSize, rb);
                    break;
                }
            }
        }
        if (this.mHelper.isAlignAnchorWidth()) {
            widthSize = this.mHelper.getAnchorViewBound().width();
            widthMode = 0x40000000;
        }
        if (this.mHelper.isAlignAnchorHeight()) {
            heightSize = this.mHelper.getAnchorViewBound().height();
            heightMode = 0x40000000;
        }
        if (this.mHelper.getMinWidth() > 0 && widthSize < this.mHelper.getMinWidth()) {
            widthSize = this.mHelper.getMinWidth();
            widthMode = 0x40000000;
        }
        if (this.mHelper.getMaxWidth() > 0 && widthSize > this.mHelper.getMaxWidth()) {
            widthSize = this.mHelper.getMaxWidth();
            widthMode = 0x40000000;
        }
        if (this.mHelper.getMinHeight() > 0 && heightSize < this.mHelper.getMinHeight()) {
            heightSize = this.mHelper.getMinHeight();
            heightMode = 0x40000000;
        }
        if (this.mHelper.getMaxHeight() > 0 && heightSize > this.mHelper.getMaxHeight()) {
            heightSize = this.mHelper.getMaxHeight();
            heightMode = 0x40000000;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        mTarget.measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        PopupLog.i("onLayout", changed, l, t, r, b);
        this.changedGravity = 0;
        this.layoutInternal(l, t, r, b);
        ++this.layoutCount;
        if (this.layoutCount >= 2) {
            this.isFirstLayoutComplete = true;
            this.layoutCount = 0;
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void layoutInternal(int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isOutsideScreen;
            boolean delayLayoutMask;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int parentWidth = this.getMeasuredWidth();
            int parentHeight = this.getMeasuredHeight();
            int gravity = this.mHelper.getPopupGravity();
            int childLeft = l;
            int childTop = t;
            int offsetX = this.mHelper.getOffsetX();
            int offsetY = this.mHelper.getOffsetY();
            boolean bl = delayLayoutMask = this.mHelper.isAlignBackground() && this.mHelper.getAlignBackgroundGravity() != 0;
            if (child == this.mMaskLayout) {
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
                continue;
            }
            parentHeight -= this.mHelper.getNavigationBarHeight();
            Rect anchorBound = this.mHelper.getAnchorViewBound();
            boolean isRelativeToAnchor = this.mHelper.isWithAnchor();
            boolean isAlignAnchorMode = this.mHelper.getGravityMode() == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
            switch (gravity & 7) {
                case 3: {
                    if (!isRelativeToAnchor) break;
                    childLeft = isAlignAnchorMode ? anchorBound.left : anchorBound.left - width;
                    break;
                }
                case 5: {
                    if (isRelativeToAnchor) {
                        childLeft = isAlignAnchorMode ? anchorBound.right - width : anchorBound.right;
                        break;
                    }
                    childLeft = r - width;
                    break;
                }
                case 1: {
                    if (isRelativeToAnchor) {
                        childLeft = anchorBound.left;
                        offsetX += anchorBound.centerX() - (childLeft + (width >> 1));
                        break;
                    }
                    childLeft = r - l - width >> 1;
                    break;
                }
                default: {
                    if (!isRelativeToAnchor) break;
                    childLeft = anchorBound.left;
                }
            }
            childLeft += this.childLeftMargin - this.childRightMargin;
            switch (gravity & 0x70) {
                case 48: {
                    if (!isRelativeToAnchor) break;
                    childTop = isAlignAnchorMode ? anchorBound.top : anchorBound.top - height;
                    break;
                }
                case 80: {
                    if (isRelativeToAnchor) {
                        childTop = isAlignAnchorMode ? anchorBound.bottom - height : anchorBound.bottom;
                        break;
                    }
                    childTop = b - height;
                    break;
                }
                case 16: {
                    if (isRelativeToAnchor) {
                        childTop = anchorBound.bottom;
                        offsetY += anchorBound.centerY() - (childTop + (height >> 1));
                        break;
                    }
                    childTop = b - height >> 1;
                    break;
                }
                default: {
                    if (!isRelativeToAnchor) break;
                    childTop = anchorBound.bottom;
                }
            }
            childTop = childTop + this.childTopMargin - this.childBottomMargin - (this.mHelper.isOverlayStatusbar() ? 0 : PopupUiUtils.getStatusBarHeight());
            if (this.mHelper.isAutoLocatePopup() && this.mHelper.isWithAnchor()) {
                int tRight = childLeft + width + offsetX;
                int tBottom = childTop + height + offsetY;
                switch (gravity & 0x70) {
                    case 48: {
                        int restHeight;
                        int n = restHeight = isAlignAnchorMode ? b - anchorBound.top : anchorBound.top;
                        if (height <= restHeight) break;
                        offsetY += isAlignAnchorMode ? 0 : anchorBound.bottom - childTop;
                        this.changedGravity = 80;
                        break;
                    }
                    default: {
                        int restHeight;
                        int n = restHeight = isAlignAnchorMode ? anchorBound.bottom : parentHeight - anchorBound.bottom;
                        if (height <= restHeight) break;
                        offsetY -= isAlignAnchorMode ? 0 : tBottom - anchorBound.top;
                        this.changedGravity = 48;
                    }
                }
            }
            int left = childLeft + offsetX;
            int top = childTop + offsetY;
            int right = left + width;
            int bottom = top + height;
            boolean bl2 = isOutsideScreen = left < 0 || top < 0 || right > parentWidth || bottom > parentHeight;
            if (isOutsideScreen) {
                if (left < 0 && right > parentWidth) {
                    left = 0;
                    right = parentWidth;
                } else {
                    int horizontalOffset = 0;
                    if (left < 0) {
                        horizontalOffset = -left;
                    } else if (right > parentWidth) {
                        horizontalOffset = Math.min(parentWidth - right, 0);
                    }
                    left = Math.max(left + horizontalOffset, 0);
                    right = Math.min(right + horizontalOffset, parentWidth);
                }
                if (top < 0 && bottom > parentHeight) {
                    top = 0;
                    bottom = parentHeight;
                } else {
                    int verticalOffset = 0;
                    if (top < 0) {
                        verticalOffset = -top;
                    } else if (bottom > parentHeight) {
                        verticalOffset = Math.min(parentHeight - bottom, 0);
                    }
                    top = Math.max(top + verticalOffset, 0);
                    bottom = Math.min(bottom + verticalOffset, parentHeight);
                }
            }
            child.layout(left, top, right, bottom);
            if (delayLayoutMask) {
                this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), left, top, right, bottom);
            }
            if (!isRelativeToAnchor) continue;
            this.popupRect.set(left, top, right, bottom);
            this.anchorRect.set(this.mHelper.getAnchorViewBound());
            this.mHelper.onPopupLayout(this.popupRect, this.anchorRect);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mMaskLayout != null) {
            this.mMaskLayout.handleStart(-2L);
        }
        if (this.mHelper != null) {
            this.mHelper.onAttachToWindow();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onInterceptTouchEvent(ev);
        if (intercept) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.mHelper != null) {
                PopupLog.i(TAG, "dispatchKeyEvent: >>> onBackPressed");
                return this.mHelper.onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mHelper != null && this.mHelper.onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
            if (this.mHelper != null) {
                PopupLog.i(TAG, "onTouchEvent:[ACTION_DOWN] >>> onOutSideTouch");
                return this.mHelper.onOutSideTouch();
            }
        } else if (event.getAction() == 4 && this.mHelper != null) {
            PopupLog.i(TAG, "onTouchEvent:[ACTION_OUTSIDE] >>> onOutSideTouch");
            return this.mHelper.onOutSideTouch();
        }
        return super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear(true);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void updateLayout() {
        if (this.mHelper != null) {
            this.mHelper.onUpdate();
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.update();
        }
        this.requestLayout();
    }

    public void onGlobalLayout() {
        if (this.changedGravity != 0 && this.mHelper.isAutoLocatePopup() && this.isFirstLayoutComplete) {
            this.mHelper.onAutoLocationChange(this.mHelper.popupGravity, this.changedGravity);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        PopupDecorViewProxy v = this;
        if (this.getContext() instanceof Activity) {
            v = ((Activity)this.getContext()).getWindow().getDecorView();
        }
        v.post(new Runnable(){

            @Override
            public void run() {
                PopupDecorViewProxy.this.updateLayout();
            }
        });
    }

    @Override
    public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
        boolean process;
        if (this.mHelper.isOutSideTouchable() && !this.mHelper.isOverlayStatusbar()) {
            return;
        }
        int offset = 0;
        boolean forceAdjust = (this.mHelper.flag & 0x100000) != 0;
        boolean bl = process = forceAdjust || PopupUiUtils.getScreenOrientation() != 2 && (this.mHelper.getSoftInputMode() == 32 || this.mHelper.getSoftInputMode() == 16);
        if (!process) {
            return;
        }
        View alignWhat = null;
        if ((this.mHelper.flag & 0x10000) != 0 && this.mHelper.keybaordAlignViewId != 0) {
            alignWhat = this.mTarget.findViewById(this.mHelper.keybaordAlignViewId);
        }
        if ((this.mHelper.flag & 0x20000) != 0 || alignWhat == null) {
            alignWhat = this.mTarget;
        }
        boolean animate = (this.mHelper.flag & 0x80000) != 0;
        alignWhat.getLocationOnScreen(this.location);
        int bottom = this.location[1] + alignWhat.getHeight();
        if (isVisible && keyboardBounds.height() > 0) {
            int gravity;
            offset = keyboardBounds.top - bottom;
            if (bottom <= keyboardBounds.top && (this.mHelper.flag & 0x40000) != 0 && this.lastKeyboardBounds.isEmpty()) {
                offset = 0;
            } else if (this.mHelper.isWithAnchor() && ((gravity = PopupUiUtils.computeGravity(this.popupRect, this.anchorRect)) & 0x70) == 48) {
                offset -= this.mHelper.getAnchorViewBound().height();
            }
        }
        if (animate) {
            this.animateTranslate(this.mTarget, isVisible, offset);
        } else {
            this.mTarget.setTranslationY(isVisible ? this.mTarget.getTranslationY() + (float)offset : 0.0f);
        }
        if (isVisible) {
            this.lastKeyboardBounds.set(keyboardBounds);
        } else {
            this.lastKeyboardBounds.setEmpty();
        }
    }

    private void animateTranslate(View target, boolean isVisible, int offset) {
        target.animate().cancel();
        if (isVisible) {
            target.animate().translationYBy((float)offset).setDuration(300L).start();
        } else {
            target.animate().translationY(0.0f).setDuration(200L).start();
        }
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mHelper != null) {
            this.mHelper.mKeyboardStateChangeListener = null;
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.clear(destroy);
        }
        if (this.mTarget != null) {
            this.mTarget.setOnClickListener(null);
        }
        this.isFirstLayoutComplete = false;
        this.layoutCount = 0;
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mHelper = null;
        this.mTarget = null;
    }
}

