/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.List;
import razerdp.basepopup.BasePopupSDK;
import razerdp.util.PopupUtils;
import razerdp.util.RomUtils;
import razerdp.util.log.PopupLog;

public class PopupUiUtils {
    public static final String POPUP_DECORVIEW = "android.widget.PopupWindow$PopupDecorView";
    public static final String POPUP_VIEWCONTAINER = "android.widget.PopupWindow$PopupViewContainer";
    public static final String POPUP_BACKGROUNDVIEW = "android.widget.PopupWindow$PopupBackgroundView";
    private static final List<String> NAVIGATION_BAR_NAMES = new ArrayList<String>();
    private static final SparseArray<Point> REAL_SIZE;
    private static int statusBarHeight;
    private static final String GESTURE_NAV_XVIVO = "navigation_gesture_on";
    private static final String GESTURE_NAV_XIAOMI = "force_fsg_nav_bar";
    private static final String GESTURE_NAVA_SAMSUNG = "navigationbar_hide_bar_enabled";

    public static boolean isPopupDecorView(View view) {
        return view != null && TextUtils.equals((CharSequence)view.getClass().getName(), (CharSequence)POPUP_DECORVIEW);
    }

    public static boolean isPopupViewContainer(View view) {
        return view != null && TextUtils.equals((CharSequence)view.getClass().getName(), (CharSequence)POPUP_VIEWCONTAINER);
    }

    public static boolean isPopupBackgroundView(View view) {
        return view != null && TextUtils.equals((CharSequence)view.getClass().getName(), (CharSequence)POPUP_BACKGROUNDVIEW);
    }

    public static int getNavigationBarHeight() {
        Resources resources = BasePopupSDK.getApplication().getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean hasNavigationBar(Context context) {
        Activity act = PopupUtils.getActivity(context);
        if (!PopupUtils.isActivityAlive(act)) {
            return false;
        }
        ViewGroup decorView = (ViewGroup)act.getWindow().getDecorView();
        int childCount = decorView.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = decorView.getChildAt(i);
            if (child.getId() == -1 || !child.isShown()) continue;
            try {
                String resourceEntryName = act.getResources().getResourceEntryName(child.getId());
                if (!NAVIGATION_BAR_NAMES.contains(resourceEntryName.toLowerCase()) || (decorView.getSystemUiVisibility() & 2) != 0) continue;
                return !PopupUiUtils.hasGestureNavigation();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getScreenHeightCompat() {
        PopupUiUtils.checkRealSize();
        int rotation = PopupUiUtils.getScreenRotation();
        int result = ((Point)PopupUiUtils.REAL_SIZE.get((int)PopupUiUtils.getScreenOrientation())).y;
        try {
            switch (rotation) {
                case 0: 
                case 2: {
                    result = ((Point)PopupUiUtils.REAL_SIZE.get((int)1)).y;
                    break;
                }
                case 1: 
                case 3: {
                    result = ((Point)PopupUiUtils.REAL_SIZE.get((int)2)).y;
                }
            }
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
        return result;
    }

    private static void checkRealSize() {
        Resources resources = BasePopupSDK.getApplication().getResources();
        int orientation = PopupUiUtils.getScreenOrientation();
        if (REAL_SIZE.get(orientation) != null) {
            return;
        }
        WindowManager windowManager = (WindowManager)BasePopupSDK.getApplication().getSystemService("window");
        Point point = new Point();
        if (windowManager == null || Build.VERSION.SDK_INT < 17) {
            point.x = resources.getDisplayMetrics().widthPixels;
            point.y = resources.getDisplayMetrics().heightPixels;
        } else {
            windowManager.getDefaultDisplay().getRealSize(point);
        }
        REAL_SIZE.put(orientation, (Object)point);
    }

    public static int getScreenWidthCompat() {
        PopupUiUtils.checkRealSize();
        int rotation = PopupUiUtils.getScreenRotation();
        int result = ((Point)PopupUiUtils.REAL_SIZE.get((int)PopupUiUtils.getScreenOrientation())).x;
        try {
            switch (rotation) {
                case 0: 
                case 2: {
                    result = ((Point)PopupUiUtils.REAL_SIZE.get((int)1)).x;
                    break;
                }
                case 1: 
                case 3: {
                    result = ((Point)PopupUiUtils.REAL_SIZE.get((int)2)).x;
                }
            }
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
        return result;
    }

    public static int getScreenOrientation() {
        return BasePopupSDK.getApplication().getResources().getConfiguration().orientation;
    }

    public static int getStatusBarHeight() {
        PopupUiUtils.checkStatusBarHeight();
        return statusBarHeight;
    }

    private static void checkStatusBarHeight() {
        if (statusBarHeight != 0) {
            return;
        }
        int result = 0;
        Resources resources = BasePopupSDK.getApplication().getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }

    public static int getScreenRotation() {
        try {
            return ((WindowManager)BasePopupSDK.getApplication().getSystemService("window")).getDefaultDisplay().getRotation();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void setBackground(View v, Drawable background) {
        if (v == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(background);
        } else {
            v.setBackgroundDrawable(background);
        }
    }

    public static void safeAddGlobalLayoutListener(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        try {
            v.getViewTreeObserver().addOnGlobalLayoutListener(listener);
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
    }

    public static void safeRemoveGlobalLayoutListener(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        try {
            v.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
    }

    private static boolean hasGestureNavigation() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        if (RomUtils.isXiaomi()) {
            return Settings.Global.getInt((ContentResolver)BasePopupSDK.getApplication().getContentResolver(), (String)GESTURE_NAV_XIAOMI, (int)0) != 0;
        }
        if (RomUtils.isVivo()) {
            return Settings.Secure.getInt((ContentResolver)BasePopupSDK.getApplication().getContentResolver(), (String)GESTURE_NAV_XVIVO, (int)0) != 0;
        }
        if (RomUtils.isSamsung()) {
            return Settings.Global.getInt((ContentResolver)BasePopupSDK.getApplication().getContentResolver(), (String)GESTURE_NAVA_SAMSUNG, (int)0) != 0;
        }
        return false;
    }

    static {
        NAVIGATION_BAR_NAMES.add("navigationbarbackground");
        NAVIGATION_BAR_NAMES.add("immersion_navigation_bar_view");
        REAL_SIZE = new SparseArray();
    }
}

