/*
 * Decompiled with CFR 0.152.
 */
package razerdp.blur;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import razerdp.blur.BlurHelper;
import razerdp.blur.PopupBlurOption;
import razerdp.blur.thread.ThreadPoolManager;
import razerdp.util.log.PopupLog;

public class BlurImageView
extends ImageView {
    private static final String TAG = "BlurImageView";
    private volatile boolean abortBlur = false;
    private WeakReference<PopupBlurOption> mBlurOption;
    private AtomicBoolean blurFinish = new AtomicBoolean(false);
    private volatile boolean isAnimating = false;
    private long startDuration;
    private CacheAction mCacheAction;
    private CacheAction mAttachedCache;
    private boolean isAttachedToWindow = false;

    public BlurImageView(Context context) {
        this(context, null);
    }

    public BlurImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BlurImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
    }

    public void applyBlurOption(PopupBlurOption option) {
        this.applyBlurOption(option, false);
    }

    private void applyBlurOption(PopupBlurOption option, boolean isOnUpdate) {
        if (option == null) {
            return;
        }
        this.mBlurOption = new WeakReference<PopupBlurOption>(option);
        View anchorView = option.getBlurView();
        if (anchorView == null) {
            PopupLog.e(TAG, "\u6a21\u7cca\u951a\u70b9View\u4e3a\u7a7a\uff0c\u653e\u5f03\u6a21\u7cca\u64cd\u4f5c...");
            this.destroy();
            return;
        }
        if (option.isBlurAsync() && !isOnUpdate) {
            PopupLog.i(TAG, "\u5b50\u7ebf\u7a0bblur");
            this.startBlurTask(anchorView);
        } else {
            try {
                PopupLog.i(TAG, "\u4e3b\u7ebf\u7a0bblur");
                if (!BlurHelper.renderScriptSupported()) {
                    PopupLog.e(TAG, "\u4e0d\u652f\u6301\u811a\u672c\u6a21\u7cca\u3002\u3002\u3002\u6700\u4f4e\u652f\u6301api 17(Android 4.2.2)\uff0c\u5c06\u91c7\u7528fastblur");
                }
                this.setImageBitmapOnUiThread(BlurHelper.blur(this.getContext(), anchorView, option.getBlurPreScaleRatio(), option.getBlurRadius(), option.isFullScreen()), isOnUpdate);
            }
            catch (Exception e) {
                PopupLog.e(TAG, "\u6a21\u7cca\u5f02\u5e38", e);
                e.printStackTrace();
                this.destroy();
            }
        }
    }

    PopupBlurOption getOption() {
        if (this.mBlurOption == null) {
            return null;
        }
        return (PopupBlurOption)this.mBlurOption.get();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.abortBlur = true;
    }

    public void update() {
        if (this.getOption() != null) {
            this.applyBlurOption(this.getOption(), true);
        }
    }

    public void start(long duration) {
        this.startDuration = duration;
        if (!this.blurFinish.get()) {
            if (this.mCacheAction == null) {
                this.mCacheAction = new CacheAction(new Runnable(){

                    @Override
                    public void run() {
                        BlurImageView.this.start(BlurImageView.this.startDuration);
                    }
                }, 0L);
                PopupLog.e(TAG, "\u7f13\u5b58\u6a21\u7cca\u52a8\u753b\uff0c\u7b49\u5f85\u6a21\u7cca\u5b8c\u6210");
            }
            return;
        }
        if (this.mCacheAction != null) {
            this.mCacheAction.destroy();
            this.mCacheAction = null;
        }
        if (this.isAnimating) {
            return;
        }
        PopupLog.i(TAG, "\u5f00\u59cb\u6a21\u7ccaalpha\u52a8\u753b");
        this.isAnimating = true;
        if (duration > 0L) {
            this.startAlphaInAnimation(duration);
        } else if (duration == -2L) {
            this.startAlphaInAnimation(this.getOption() == null ? 500L : this.getOption().getBlurInDuration());
        } else {
            this.setImageAlpha(255);
        }
    }

    private void startAlphaInAnimation(long duration) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, 255});
        valueAnimator.setDuration(duration);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BlurImageView.this.isAnimating = false;
            }
        });
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BlurImageView.this.setImageAlpha((Integer)animation.getAnimatedValue());
            }
        });
        valueAnimator.start();
    }

    public void dismiss(long duration) {
        this.isAnimating = false;
        PopupLog.i(TAG, "dismiss\u6a21\u7ccaimageview alpha\u52a8\u753b");
        if (duration > 0L) {
            this.startAlphaOutAnimation(duration);
        } else if (duration == -2L) {
            this.startAlphaOutAnimation(this.getOption() == null ? 500L : this.getOption().getBlurOutDuration());
        } else {
            this.setImageAlpha(0);
        }
    }

    private void startAlphaOutAnimation(long duration) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{255, 0});
        valueAnimator.setDuration(duration);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BlurImageView.this.isAnimating = false;
            }
        });
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BlurImageView.this.setImageAlpha((Integer)animation.getAnimatedValue());
            }
        });
        valueAnimator.start();
    }

    private void startBlurTask(View anchorView) {
        ThreadPoolManager.execute(new CreateBlurBitmapRunnable(anchorView));
    }

    private void setImageBitmapOnUiThread(final Bitmap blurBitmap, final boolean isOnUpdate) {
        if (this.isUiThread()) {
            this.handleSetImageBitmap(blurBitmap, isOnUpdate);
        } else if (!this.isAttachedToWindow) {
            this.mAttachedCache = new CacheAction(new Runnable(){

                @Override
                public void run() {
                    BlurImageView.this.handleSetImageBitmap(blurBitmap, isOnUpdate);
                }
            }, 0L);
        } else {
            this.post(new Runnable(){

                @Override
                public void run() {
                    BlurImageView.this.handleSetImageBitmap(blurBitmap, isOnUpdate);
                }
            });
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.mAttachedCache != null) {
            this.mAttachedCache.forceRestore();
        }
    }

    private void handleSetImageBitmap(Bitmap bitmap, boolean isOnUpdate) {
        if (bitmap != null) {
            PopupLog.i("bitmap: \u3010" + bitmap.getWidth() + "," + bitmap.getHeight() + "\u3011");
        }
        this.setImageAlpha(isOnUpdate ? 255 : 0);
        this.setImageBitmap(bitmap);
        PopupBlurOption option = this.getOption();
        if (option != null && !option.isFullScreen()) {
            View anchorView = option.getBlurView();
            if (anchorView == null) {
                return;
            }
            Rect rect = new Rect();
            anchorView.getGlobalVisibleRect(rect);
            Matrix matrix = this.getImageMatrix();
            matrix.setTranslate((float)rect.left, (float)rect.top);
            this.setImageMatrix(matrix);
        }
        this.blurFinish.compareAndSet(false, true);
        PopupLog.i(TAG, "\u8bbe\u7f6e\u6210\u529f\uff1a" + this.blurFinish.get());
        if (this.mCacheAction != null) {
            PopupLog.i(TAG, "\u6062\u590d\u7f13\u5b58\u52a8\u753b");
            this.mCacheAction.restore();
        }
        if (this.mAttachedCache != null) {
            this.mAttachedCache.destroy();
            this.mAttachedCache = null;
        }
    }

    private boolean isUiThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public void destroy() {
        this.setImageBitmap(null);
        this.abortBlur = true;
        if (this.mBlurOption != null) {
            this.mBlurOption.clear();
            this.mBlurOption = null;
        }
        if (this.mCacheAction != null) {
            this.mCacheAction.destroy();
            this.mCacheAction = null;
        }
        this.blurFinish.set(false);
        this.isAnimating = false;
        this.startDuration = 0L;
    }

    class CacheAction {
        private static final long BLUR_TASK_WAIT_TIMEOUT = 1000L;
        Runnable action;
        long delay;
        final long startTime;

        CacheAction(Runnable action, long delay) {
            this.action = action;
            this.delay = delay;
            this.startTime = System.currentTimeMillis();
        }

        void restore() {
            if (this.isOverTime()) {
                PopupLog.e(BlurImageView.TAG, "\u6a21\u7cca\u8d85\u65f6");
                this.destroy();
                return;
            }
            if (this.action != null) {
                BlurImageView.this.post(this.action);
            }
        }

        void forceRestore() {
            if (this.action != null) {
                BlurImageView.this.post(this.action);
            }
        }

        boolean isOverTime() {
            return System.currentTimeMillis() - this.startTime > 1000L;
        }

        public void destroy() {
            if (this.action != null) {
                BlurImageView.this.removeCallbacks(this.action);
            }
            this.action = null;
            this.delay = 0L;
        }

        public boolean matches(Runnable otherAction) {
            return otherAction == null && this.action == null || this.action != null && this.action.equals(otherAction);
        }
    }

    class CreateBlurBitmapRunnable
    implements Runnable {
        private int outWidth;
        private int outHeight;
        private Bitmap mBitmap;

        CreateBlurBitmapRunnable(View target) {
            this.outWidth = target.getWidth();
            this.outHeight = target.getHeight();
            this.mBitmap = BlurHelper.getViewBitmap(target, BlurImageView.this.getOption().getBlurPreScaleRatio(), BlurImageView.this.getOption().isFullScreen());
        }

        @Override
        public void run() {
            if (BlurImageView.this.abortBlur || BlurImageView.this.getOption() == null) {
                PopupLog.e(BlurImageView.TAG, "\u653e\u5f03\u6a21\u7cca\uff0c\u53ef\u80fd\u662f\u5df2\u7ecf\u79fb\u9664\u4e86\u5e03\u5c40");
                return;
            }
            PopupLog.i(BlurImageView.TAG, "\u5b50\u7ebf\u7a0b\u6a21\u7cca\u6267\u884c");
            BlurImageView.this.setImageBitmapOnUiThread(BlurHelper.blur(BlurImageView.this.getContext(), this.mBitmap, this.outWidth, this.outHeight, BlurImageView.this.getOption().getBlurRadius()), false);
        }
    }
}

