/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupSupporterManager;
import razerdp.basepopup.PopupTouchController;
import razerdp.basepopup.PopupWindowLocationListener;
import razerdp.basepopup.PopupWindowProxy;
import razerdp.blur.PopupBlurOption;
import razerdp.interceptor.PopupWindowEventInterceptor;
import razerdp.util.InputMethodUtils;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;
import razerdp.util.SimpleAnimationUtils;
import razerdp.util.log.PopupLog;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener,
PopupTouchController,
PopupWindowLocationListener {
    private static final String TAG = "BasePopupWindow";
    public static int DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#8f000000");
    public static boolean DEBUG = false;
    private static final int MAX_RETRY_SHOW_TIME = 3;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    private BasePopupHelper mHelper;
    private WeakReference<Context> mContext;
    private PopupWindowEventInterceptor mEventInterceptor;
    private PopupWindowProxy mPopupWindow;
    private View mContentView;
    private View mDisplayAnimateView;
    private volatile boolean isExitAnimatePlaying = false;
    private int retryCounter;
    private EditText mAutoShowInputEdittext;
    private GlobalLayoutListenerWrapper mGlobalLayoutListenerWrapper;
    private LinkedViewLayoutChangeListenerWrapper mLinkedViewLayoutChangeListenerWrapper;
    private WeakReference<View> mLinkedViewRef;
    private DelayInitCached mDelayInitCached;
    Object lifeCycleObserver;

    public BasePopupWindow(Context context) {
        this(context, false);
    }

    public BasePopupWindow(Context context, boolean delayInit) {
        this(context, -2, -2, delayInit);
    }

    public BasePopupWindow(Context context, int width, int height) {
        this(context, width, height, false);
    }

    public BasePopupWindow(Context context, int width, int height, boolean delayInit) {
        this.mContext = new WeakReference<Context>(context);
        if (!delayInit) {
            this.initView(width, height);
        } else {
            this.mDelayInitCached = new DelayInitCached();
            this.mDelayInitCached.width = width;
            this.mDelayInitCached.height = height;
        }
    }

    public void delayInit() {
        if (this.mDelayInitCached == null) {
            return;
        }
        this.initView(this.mDelayInitCached.width, this.mDelayInitCached.height);
        this.mDelayInitCached = null;
    }

    private void initView(int width, int height) {
        this.attachLifeCycle(this.getContext());
        this.mHelper = new BasePopupHelper(this);
        this.registerListener(this.mHelper);
        this.mContentView = this.onCreateContentView();
        this.mHelper.setContentRootId(this.mContentView);
        if (this.mHelper.getParaseFromXmlParams() == null) {
            Log.e((String)TAG, (String)"\u4e3a\u4e86\u66f4\u51c6\u786e\u7684\u9002\u914d\u60a8\u7684\u5e03\u5c40\uff0cBasePopupWindow\u5efa\u8bae\u60a8\u4f7f\u7528createPopupById()\u8fdb\u884cinflate");
        }
        this.mDisplayAnimateView = this.onCreateAnimateView();
        if (this.mDisplayAnimateView == null) {
            this.mDisplayAnimateView = this.mContentView;
        }
        this.setWidth(width);
        this.setHeight(height);
        if (this.mHelper.getParaseFromXmlParams() != null) {
            width = this.mHelper.getParaseFromXmlParams().width;
            height = this.mHelper.getParaseFromXmlParams().height;
        }
        this.mPopupWindow = new PopupWindowProxy(this.mContentView, width, height, this.mHelper);
        this.mPopupWindow.setOnDismissListener(this);
        this.mPopupWindow.attachPopupHelper(this.mHelper);
        this.setOutSideDismiss(true);
        this.setPopupAnimationStyle(0);
        this.mHelper.setPopupViewWidth(width);
        this.mHelper.setPopupViewHeight(height);
        this.hookContentViewDismissClick(width, height);
        this.preMeasurePopupView(width, height);
        this.mHelper.setShowAnimation(this.onCreateShowAnimation()).setShowAnimator(this.onCreateShowAnimator()).setDismissAnimation(this.onCreateDismissAnimation()).setDismissAnimator(this.onCreateDismissAnimator());
    }

    private void registerListener(BasePopupHelper helper) {
        helper.registerLocationLisener(this);
    }

    private void hookContentViewDismissClick(int w, int h) {
        if (w != -1 || h != -1) {
            return;
        }
        if (this.mContentView != null && !(this.mContentView instanceof AdapterView) && this.mContentView instanceof ViewGroup) {
            ViewGroup vp = (ViewGroup)this.mContentView;
            int childCount = vp.getChildCount();
            final ArrayList<Pair> protectViews = new ArrayList<Pair>(childCount);
            for (int i = 0; i < childCount; ++i) {
                View child = vp.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                protectViews.add(Pair.create(new WeakReference<View>(child), (Object)new Rect()));
            }
            this.mContentView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            return BasePopupWindow.this.isAllowDismissWhenTouchOutside();
                        }
                        case 1: {
                            if (!BasePopupWindow.this.isAllowDismissWhenTouchOutside()) break;
                            v.performClick();
                            int x = (int)event.getX();
                            int y = (int)event.getY();
                            boolean interceptDismiss = false;
                            for (Pair protectView : protectViews) {
                                if (protectView.first == null || ((WeakReference)protectView.first).get() == null || protectView.second == null) continue;
                                View ignoreTarget = (View)((WeakReference)protectView.first).get();
                                Rect bounds = (Rect)protectView.second;
                                ignoreTarget.getGlobalVisibleRect(bounds);
                                if (!bounds.contains(x, y)) continue;
                                interceptDismiss = true;
                                break;
                            }
                            if (interceptDismiss) break;
                            BasePopupWindow.this.dismiss();
                        }
                    }
                    return false;
                }
            });
        }
    }

    private void preMeasurePopupView(int w, int h) {
        if (this.mContentView != null) {
            boolean breakPreMeasure;
            boolean bl = breakPreMeasure = this.mEventInterceptor != null && this.mEventInterceptor.onPreMeasurePopupView(this, this.mContentView, w, h);
            if (!breakPreMeasure) {
                int measureWidth = View.MeasureSpec.makeMeasureSpec((int)w, (int)(w == -2 ? 0 : 0x40000000));
                int measureHeight = View.MeasureSpec.makeMeasureSpec((int)h, (int)(h == -2 ? 0 : 0x40000000));
                this.mContentView.measure(measureWidth, measureHeight);
            }
            this.mHelper.setPreMeasureWidth(this.mContentView.getMeasuredWidth()).setPreMeasureHeight(this.mContentView.getMeasuredHeight());
            this.mContentView.setFocusableInTouchMode(true);
        }
    }

    protected Animation onCreateShowAnimation() {
        return null;
    }

    protected Animation onCreateDismissAnimation() {
        return null;
    }

    protected Animator onCreateShowAnimator() {
        return null;
    }

    protected View onCreateAnimateView() {
        return null;
    }

    protected Animator onCreateDismissAnimator() {
        return null;
    }

    public BasePopupWindow setPopupFadeEnable(boolean isPopupFadeAnimate) {
        this.mHelper.setPopupFadeEnable(this.mPopupWindow, isPopupFadeAnimate);
        return this;
    }

    public boolean isPopupFadeEnable() {
        return this.mHelper.isPopupFadeEnable();
    }

    public BasePopupWindow setPopupAnimationStyle(int animationStyleRes) {
        this.mPopupWindow.setAnimationStyle(animationStyleRes);
        return this;
    }

    public void showPopupWindow() {
        if (this.checkPerformShow(null)) {
            this.mHelper.setShowAsDropDown(false);
            this.tryToShowPopup(null, false, false);
        }
    }

    public void showPopupWindow(int anchorViewResid) {
        Context context = this.getContext();
        assert (context != null) : "context is null";
        if (context instanceof Activity) {
            View v = ((Activity)context).findViewById(anchorViewResid);
            this.showPopupWindow(v);
        } else {
            Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
        }
    }

    public void showPopupWindow(View anchorView) {
        if (this.checkPerformShow(anchorView)) {
            if (anchorView != null) {
                this.mHelper.setShowAsDropDown(true);
            }
            this.tryToShowPopup(anchorView, false, false);
        }
    }

    public void showPopupWindow(int x, int y) {
        if (this.checkPerformShow(null)) {
            this.mHelper.setShowLocation(x, y);
            this.mHelper.setShowAsDropDown(true);
            this.tryToShowPopup(null, true, false);
        }
    }

    public void update() {
        this.tryToUpdate(null, false);
    }

    public void update(View anchorView) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.tryToUpdate(anchorView, false);
    }

    public void update(int x, int y) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.mHelper.setShowLocation(x, y);
        this.mHelper.setShowAsDropDown(true);
        this.tryToUpdate(null, true);
    }

    public void update(float width, float height) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.setWidth((int)width).setHeight((int)height).update();
    }

    public void update(int x, int y, float width, float height) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.mHelper.setShowLocation(x, y);
        this.mHelper.setShowAsDropDown(true);
        this.setWidth((int)width).setHeight((int)height).tryToUpdate(null, true);
    }

    private void tryToShowPopup(View v, boolean positionMode, boolean abortAnimate) {
        this.addListener();
        this.mHelper.handleShow();
        this.mHelper.prepare(v, positionMode);
        if (this.mEventInterceptor != null && this.mEventInterceptor.onTryToShowPopup(this, this.mPopupWindow, v, this.mHelper.getPopupGravity(), this.mHelper.getOffsetX(), this.mHelper.getOffsetY())) {
            return;
        }
        try {
            if (this.isShowing()) {
                return;
            }
            if (v != null) {
                if (this.mHelper.isShowAsDropDown()) {
                    this.mPopupWindow.showAsDropDownProxy(v, 0, 0, this.getPopupGravity());
                } else {
                    this.mPopupWindow.showAtLocationProxy(v, this.getPopupGravity(), 0, 0);
                }
            } else {
                Context context = this.getContext();
                assert (context != null) : "context is null ! please make sure your activity is not be destroyed";
                Activity activity = PopupUtils.scanForActivity(context, 50);
                if (activity == null) {
                    Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
                } else {
                    this.mPopupWindow.showAtLocationProxy(this.findDecorView(activity), 0, 0, 0);
                }
            }
            this.mHelper.onShow(this.mHelper.getShowAnimation() != null || this.mHelper.getShowAnimator() != null);
            if (this.mDisplayAnimateView != null && !abortAnimate) {
                if (this.mHelper.getShowAnimation() != null) {
                    this.mHelper.getShowAnimation().cancel();
                    this.mDisplayAnimateView.startAnimation(this.mHelper.getShowAnimation());
                } else if (this.mHelper.getShowAnimator() != null) {
                    this.mHelper.getShowAnimator().start();
                }
            }
            if (this.mHelper.isAutoShowInputMethod() && this.mAutoShowInputEdittext != null) {
                this.mAutoShowInputEdittext.requestFocus();
                InputMethodUtils.showInputMethod((View)this.mAutoShowInputEdittext, 350L);
            }
            this.retryCounter = 0;
        }
        catch (Exception e) {
            this.retryToShowPopup(v, positionMode, abortAnimate);
            PopupLog.e(TAG, e);
            e.printStackTrace();
        }
    }

    private View findDecorView(Activity activity) {
        View result = this.onFindDecorView(activity);
        if (result == null) {
            result = BasePopupSupporterManager.getInstance().findDecorView(this, activity);
        }
        return result == null ? activity.findViewById(0x1020002) : result;
    }

    protected View onFindDecorView(Activity activity) {
        return null;
    }

    private void tryToUpdate(View v, boolean positionMode) {
        if (!this.isShowing() || this.getContentView() == null) {
            return;
        }
        this.mHelper.prepare(v, positionMode);
        this.mPopupWindow.update();
    }

    private void addListener() {
        this.addGlobalListener();
        this.addLinkedLayoutListener();
    }

    private void addGlobalListener() {
        if (this.mGlobalLayoutListenerWrapper != null && this.mGlobalLayoutListenerWrapper.isAttached()) {
            return;
        }
        Activity activity = PopupUtils.scanForActivity(this.getContext(), 50);
        if (activity == null) {
            return;
        }
        View decorView = ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        this.mGlobalLayoutListenerWrapper = new GlobalLayoutListenerWrapper(decorView, new OnKeyboardStateChangeListener(){

            @Override
            public void onKeyboardChange(int keyboardHeight, boolean isVisible) {
                BasePopupWindow.this.mHelper.onKeyboardChange(keyboardHeight, isVisible);
            }
        });
        this.mGlobalLayoutListenerWrapper.addSelf();
    }

    private void addLinkedLayoutListener() {
        if (this.mLinkedViewLayoutChangeListenerWrapper != null && this.mLinkedViewLayoutChangeListenerWrapper.isAdded) {
            return;
        }
        this.mLinkedViewLayoutChangeListenerWrapper = new LinkedViewLayoutChangeListenerWrapper();
        this.mLinkedViewLayoutChangeListenerWrapper.addSelf();
    }

    private void removeGlobalListener() {
        if (this.mGlobalLayoutListenerWrapper != null) {
            this.mGlobalLayoutListenerWrapper.remove();
        }
        this.mHelper.handleDismiss();
    }

    private void removeLinkedLayoutListener() {
        if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
            this.mLinkedViewLayoutChangeListenerWrapper.removeListener();
        }
    }

    private void retryToShowPopup(final View v, final boolean positionMode, final boolean abortAnimate) {
        boolean available;
        Activity act;
        if (this.retryCounter > 3) {
            return;
        }
        PopupLog.e("catch an exception on showing popupwindow ...now retrying to show ... retry count  >>  " + this.retryCounter, new Object[0]);
        if (this.mPopupWindow.callSuperIsShowing()) {
            this.mPopupWindow.callSuperDismiss();
        }
        if ((act = this.mPopupWindow.scanForActivity(this.getContext())) == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            available = !act.isFinishing() && !act.isDestroyed();
        } else {
            boolean bl = available = !act.isFinishing();
        }
        if (available) {
            View rootView = act.getWindow().getDecorView();
            if (rootView == null) {
                return;
            }
            rootView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BasePopupWindow.this.retryCounter++;
                    BasePopupWindow.this.tryToShowPopup(v, positionMode, abortAnimate);
                    PopupLog.e(BasePopupWindow.TAG, "retry to show >> " + BasePopupWindow.this.retryCounter);
                }
            }, 350L);
        }
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust) {
        this.setAdjustInputMethod(needAdjust, 16);
        return this;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust, int flag) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(flag);
            this.setSoftInputMode(flag);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
            this.setSoftInputMode(48);
        }
        return this;
    }

    public BasePopupWindow setAutoShowInputMethod(EditText editText, boolean autoShow) {
        this.mHelper.autoShowInputMethod(this.mPopupWindow, autoShow);
        this.mAutoShowInputEdittext = editText;
        return this;
    }

    public BasePopupWindow setSoftInputMode(int softInputMode) {
        this.mHelper.setSoftInputMode(softInputMode);
        return this;
    }

    public BasePopupWindow setBackPressEnable(boolean backPressEnable) {
        this.mHelper.backPressEnable(this.mPopupWindow, backPressEnable);
        return this;
    }

    public View createPopupById(int layoutId) {
        return this.mHelper.inflate(this.getContext(), layoutId);
    }

    public <T extends View> T findViewById(int id2) {
        if (this.mContentView != null && id2 != 0) {
            return (T)this.mContentView.findViewById(id2);
        }
        return null;
    }

    public BasePopupWindow setPopupWindowFullScreen(boolean isFullScreen) {
        this.mHelper.fullScreen(isFullScreen);
        return this;
    }

    public BasePopupWindow setBackgroundColor(int color) {
        this.mHelper.setPopupBackground((Drawable)new ColorDrawable(color));
        return this;
    }

    public BasePopupWindow setBackground(int drawableIds) {
        if (drawableIds == 0) {
            return this.setBackground(null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return this.setBackground(this.getContext().getDrawable(drawableIds));
        }
        return this.setBackground(this.getContext().getResources().getDrawable(drawableIds));
    }

    public BasePopupWindow setBackground(Drawable background) {
        this.mHelper.setPopupBackground(background);
        return this;
    }

    public BasePopupWindow setBackgroundView(View backgroundView) {
        this.mHelper.setBackgroundView(backgroundView);
        return this;
    }

    public Drawable getPopupBackground() {
        return this.mHelper.getPopupBackground();
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blurBackgroundEnable) {
        return this.setBlurBackgroundEnable(blurBackgroundEnable, null);
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blurBackgroundEnable, OnBlurOptionInitListener optionInitListener) {
        if (!(this.getContext() instanceof Activity)) {
            PopupLog.e(TAG, "\u65e0\u6cd5\u914d\u7f6e\u9ed8\u8ba4\u6a21\u7cca\u811a\u672c\uff0c\u56e0\u4e3acontext\u4e0d\u662factivity");
            return this;
        }
        PopupBlurOption option = null;
        if (blurBackgroundEnable) {
            View decorView;
            option = new PopupBlurOption();
            option.setFullScreen(true).setBlurInDuration(-1L).setBlurOutDuration(-1L);
            if (optionInitListener != null) {
                optionInitListener.onCreateBlurOption(option);
            }
            if ((decorView = this.findDecorView((Activity)this.getContext())) instanceof ViewGroup && decorView.getId() == 0x1020002) {
                option.setBlurView(((ViewGroup)((Activity)this.getContext()).getWindow().getDecorView()).getChildAt(0));
                option.setFullScreen(true);
            } else {
                option.setBlurView(decorView);
            }
        }
        return this.setBlurOption(option);
    }

    public BasePopupWindow setBlurOption(PopupBlurOption option) {
        this.mHelper.applyBlur(option);
        return this;
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mHelper.getOnDismissListener();
    }

    public BasePopupWindow setOnDismissListener(OnDismissListener onDismissListener) {
        this.mHelper.setOnDismissListener(onDismissListener);
        return this;
    }

    public OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mHelper.getOnBeforeShowCallback();
    }

    public BasePopupWindow setOnBeforeShowCallback(OnBeforeShowCallback mOnBeforeShowCallback) {
        this.mHelper.setOnBeforeShowCallback(mOnBeforeShowCallback);
        return this;
    }

    public BasePopupWindow setShowAnimation(Animation showAnimation) {
        this.mHelper.setShowAnimation(showAnimation);
        return this;
    }

    public Animation getShowAnimation() {
        return this.mHelper.getShowAnimation();
    }

    public BasePopupWindow setShowAnimator(Animator showAnimator) {
        this.mHelper.setShowAnimator(showAnimator);
        return this;
    }

    public Animator getShowAnimator() {
        return this.mHelper.getShowAnimator();
    }

    public BasePopupWindow setDismissAnimation(Animation dismissAnimation) {
        this.mHelper.setDismissAnimation(dismissAnimation);
        return this;
    }

    public Animation getDismissAnimation() {
        return this.mHelper.getDismissAnimation();
    }

    public BasePopupWindow setDismissAnimator(Animator dismissAnimator) {
        this.mHelper.setDismissAnimator(dismissAnimator);
        return this;
    }

    public Animator getDismissAnimator() {
        return this.mHelper.getDismissAnimator();
    }

    public Context getContext() {
        return this.mContext == null ? null : (Context)this.mContext.get();
    }

    public View getContentView() {
        return this.mContentView;
    }

    public View getDisplayAnimateView() {
        return this.mDisplayAnimateView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getOffsetX() {
        return this.mHelper.getOffsetX();
    }

    public BasePopupWindow setOffsetX(int offsetX) {
        this.mHelper.setOffsetX(offsetX);
        return this;
    }

    public int getOffsetY() {
        return this.mHelper.getOffsetY();
    }

    public BasePopupWindow setOffsetY(int offsetY) {
        this.mHelper.setOffsetY(offsetY);
        return this;
    }

    public int getPopupGravity() {
        return this.mHelper.getPopupGravity();
    }

    public BasePopupWindow setPopupGravity(int popupGravity) {
        return this.setPopupGravity(GravityMode.RELATIVE_TO_ANCHOR, popupGravity);
    }

    public BasePopupWindow setPopupGravity(GravityMode mode, int popupGravity) {
        this.mHelper.setPopupGravity(mode, popupGravity);
        return this;
    }

    public boolean isAutoLocatePopup() {
        return this.mHelper.isAutoLocatePopup();
    }

    public BasePopupWindow setAutoLocatePopup(boolean isAutoLocatePopup) {
        this.mHelper.autoLocatePopup(isAutoLocatePopup);
        return this;
    }

    public int getHeight() {
        if (this.mContentView == null) {
            return this.mHelper.getPreMeasureHeight();
        }
        return this.mContentView.getHeight() <= 0 ? this.mHelper.getPreMeasureHeight() : this.mContentView.getHeight();
    }

    public int getWidth() {
        if (this.mContentView == null) {
            return this.mHelper.getPreMeasureWidth();
        }
        return this.mContentView.getWidth() <= 0 ? this.mHelper.getPreMeasureWidth() : this.mContentView.getWidth();
    }

    @Deprecated
    public BasePopupWindow setAllowDismissWhenTouchOutside(boolean dismissWhenTouchOutside) {
        this.setOutSideDismiss(dismissWhenTouchOutside);
        return this;
    }

    public BasePopupWindow setOutSideDismiss(boolean outSideDismiss) {
        this.mHelper.dismissOutSideTouch(this.mPopupWindow, outSideDismiss);
        return this;
    }

    @Deprecated
    public BasePopupWindow setAllowInterceptTouchEvent(boolean touchable) {
        this.setOutSideTouchable(!touchable);
        return this;
    }

    public BasePopupWindow setOutSideTouchable(boolean touchable) {
        this.mHelper.outSideTouchable(this.mPopupWindow, touchable);
        return this;
    }

    public BasePopupWindow setClipChildren(boolean clipChildren) {
        this.mHelper.setClipChildren(clipChildren);
        return this;
    }

    public BasePopupWindow setClipToScreen(boolean clipToScreen) {
        this.mHelper.setClipToScreen(clipToScreen);
        return this;
    }

    public boolean isAllowDismissWhenTouchOutside() {
        return this.mHelper.isOutSideDismiss();
    }

    @Deprecated
    public boolean isAllowInterceptTouchEvent() {
        return !this.mHelper.isOutSideTouchable();
    }

    public boolean isOutSideTouchable() {
        return this.mHelper.isOutSideTouchable();
    }

    public BasePopupWindow setAlignBackground(boolean isAlignBackground) {
        this.mHelper.setAlignBackgound(isAlignBackground);
        return this;
    }

    public BasePopupWindow setAlignBackgroundGravity(int gravity) {
        this.mHelper.setAlignBackgroundGravity(gravity);
        return this;
    }

    public BasePopupWindow linkTo(View anchorView) {
        if (anchorView == null) {
            if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
                this.mLinkedViewLayoutChangeListenerWrapper.removeListener();
                this.mLinkedViewLayoutChangeListenerWrapper = null;
            }
            if (this.mLinkedViewRef != null) {
                this.mLinkedViewRef.clear();
                this.mLinkedViewRef = null;
                return this;
            }
        }
        this.mLinkedViewRef = new WeakReference<View>(anchorView);
        return this;
    }

    public BasePopupWindow setWidth(int width) {
        this.mHelper.setPopupViewWidth(width);
        return this;
    }

    public BasePopupWindow setHeight(int height) {
        this.mHelper.setPopupViewHeight(height);
        return this;
    }

    public BasePopupWindow setMaxWidth(int maxWidth) {
        this.mHelper.setMaxWidth(maxWidth);
        return this;
    }

    public BasePopupWindow setMaxHeight(int maxHeight) {
        this.mHelper.setMaxHeight(maxHeight);
        return this;
    }

    public BasePopupWindow setMinWidth(int minWidth) {
        this.mHelper.setMinWidth(minWidth);
        return this;
    }

    public BasePopupWindow setMinHeight(int minHeight) {
        this.mHelper.setMinHeight(minHeight);
        return this;
    }

    public BasePopupWindow setKeepSize(boolean keepSize) {
        this.mHelper.keepSize(keepSize);
        return this;
    }

    public BasePopupWindow attachLifeCycle(Object owner) {
        return BasePopupSupporterManager.getInstance().attachLifeCycle(this, owner);
    }

    public BasePopupWindow removeLifeCycle(Object owner) {
        return BasePopupSupporterManager.getInstance().removeLifeCycle(this, owner);
    }

    public <P extends BasePopupWindow> BasePopupWindow setEventInterceptor(PopupWindowEventInterceptor<P> eventInterceptor) {
        this.mEventInterceptor = eventInterceptor;
        this.mHelper.setEventInterceptor(eventInterceptor);
        return this;
    }

    public void dismiss() {
        this.dismiss(true);
    }

    /*
     * Unable to fully structure code
     */
    public void dismiss(boolean animateDismiss) {
        if (animateDismiss) {
            try {
                if (this.mAutoShowInputEdittext == null || !this.mHelper.isAutoShowInputMethod()) ** GOTO lbl14
                InputMethodUtils.close((View)this.mAutoShowInputEdittext);
            }
            catch (Exception e) {
                PopupLog.e("BasePopupWindow", new Object[]{e});
                e.printStackTrace();
            }
            finally {
                this.mPopupWindow.dismiss();
            }
        } else {
            this.dismissWithOutAnimate();
        }
lbl14:
        // 4 sources

        this.removeListener();
    }

    void removeListener() {
        this.removeGlobalListener();
        this.removeLinkedLayoutListener();
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.checkPerformDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        long duration = -1L;
        if (this.mHelper.getDismissAnimation() != null && this.mDisplayAnimateView != null) {
            if (!this.isExitAnimatePlaying) {
                duration = this.mHelper.getDismissAnimation().getDuration();
                this.mHelper.getDismissAnimation().cancel();
                this.mDisplayAnimateView.startAnimation(this.mHelper.getDismissAnimation());
                this.callDismissAnimationStart();
                this.isExitAnimatePlaying = true;
            }
        } else if (this.mHelper.getDismissAnimator() != null && !this.isExitAnimatePlaying) {
            duration = this.mHelper.getDismissAnimator().getDuration();
            this.mHelper.getDismissAnimator().start();
            this.callDismissAnimationStart();
            this.isExitAnimatePlaying = true;
        }
        this.mContentView.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupWindow.this.isExitAnimatePlaying = false;
                BasePopupWindow.this.mPopupWindow.callSuperDismiss();
            }
        }, Math.max(this.mHelper.getDismissAnimationDuration(), duration));
        this.mHelper.onDismiss(duration > -1L);
        return duration <= 0L;
    }

    private void callDismissAnimationStart() {
        if (this.getOnDismissListener() != null) {
            this.getOnDismissListener().onDismissAnimationStart();
        }
    }

    public void dismissWithOutAnimate() {
        if (!this.checkPerformDismiss()) {
            return;
        }
        if (this.mHelper.getDismissAnimation() != null && this.mDisplayAnimateView != null) {
            this.mHelper.getDismissAnimation().cancel();
        }
        if (this.mHelper.getDismissAnimator() != null) {
            this.mHelper.getDismissAnimator().cancel();
        }
        if (this.mAutoShowInputEdittext != null && this.mHelper.isAutoShowInputMethod()) {
            InputMethodUtils.close((View)this.mAutoShowInputEdittext);
        }
        this.mPopupWindow.callSuperDismiss();
        this.mHelper.onDismiss(false);
        this.removeListener();
    }

    void forceDismiss() {
        if (this.mHelper.getDismissAnimation() != null && this.mDisplayAnimateView != null) {
            this.mHelper.getDismissAnimation().cancel();
        }
        if (this.mHelper.getDismissAnimator() != null) {
            this.mHelper.getDismissAnimator().cancel();
        }
        if (this.mAutoShowInputEdittext != null && this.mHelper.isAutoShowInputMethod()) {
            InputMethodUtils.close((View)this.mAutoShowInputEdittext);
        }
        this.mPopupWindow.callSuperDismiss();
        this.mHelper.onDismiss(false);
        this.removeListener();
    }

    private boolean checkPerformDismiss() {
        boolean callDismiss = true;
        if (this.mHelper.getOnDismissListener() != null) {
            callDismiss = this.mHelper.getOnDismissListener().onBeforeDismiss();
        }
        return callDismiss && !this.isExitAnimatePlaying;
    }

    private boolean checkPerformShow(View v) {
        boolean result = true;
        if (this.mHelper.getOnBeforeShowCallback() != null) {
            result = this.mHelper.getOnBeforeShowCallback().onBeforeShow(this.mContentView, v, this.mHelper.getShowAnimation() != null || this.mHelper.getShowAnimator() != null);
        }
        return result;
    }

    @Override
    public boolean onDispatchKeyEvent(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        if (this.mHelper.isBackPressEnable()) {
            this.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public boolean onOutSideTouch() {
        boolean result = false;
        if (this.mHelper.isOutSideDismiss()) {
            this.dismiss();
            result = true;
        } else if (!this.mHelper.isOutSideTouchable()) {
            result = true;
        }
        return result;
    }

    protected Animation getTranslateVerticalAnimation(int start, int end, int durationMillis) {
        return SimpleAnimationUtils.getTranslateVerticalAnimation(start, end, durationMillis);
    }

    protected Animation getTranslateVerticalAnimation(float start, float end, int durationMillis) {
        return SimpleAnimationUtils.getTranslateVerticalAnimation(start, end, durationMillis);
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        return SimpleAnimationUtils.getScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
    }

    protected Animation getDefaultScaleAnimation() {
        return this.getDefaultScaleAnimation(true);
    }

    protected Animation getDefaultScaleAnimation(boolean in) {
        return SimpleAnimationUtils.getDefaultScaleAnimation(in);
    }

    protected Animation getDefaultAlphaAnimation() {
        return this.getDefaultAlphaAnimation(true);
    }

    protected Animation getDefaultAlphaAnimation(boolean in) {
        return SimpleAnimationUtils.getDefaultAlphaAnimation(in);
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        return SimpleAnimationUtils.getDefaultSlideFromBottomAnimationSet(this.mDisplayAnimateView);
    }

    public int getScreenHeight() {
        return PopupUiUtils.getScreenHeightCompat(this.getContext());
    }

    public int getScreenWidth() {
        return PopupUiUtils.getScreenWidthCompat(this.getContext());
    }

    @Override
    public void onAnchorTop() {
    }

    @Override
    public void onAnchorBottom() {
    }

    @Deprecated
    public void onAnchorTop(View mPopupView, View anchorView) {
    }

    @Deprecated
    public void onAnchorBottom(View mPopupView, View anchorView) {
    }

    public void onDismiss() {
        if (this.mHelper.getOnDismissListener() != null) {
            this.mHelper.getOnDismissListener().onDismiss();
        }
        this.isExitAnimatePlaying = false;
    }

    protected float dipToPx(float dip) {
        if (this.getContext() == null) {
            return dip;
        }
        return dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f;
    }

    public static void setDebugMode(boolean debugMode) {
        DEBUG = debugMode;
        PopupLog.setOpenLog(debugMode);
    }

    private class DelayInitCached {
        int width;
        int height;

        private DelayInitCached() {
        }
    }

    private class LinkedViewLayoutChangeListenerWrapper
    implements ViewTreeObserver.OnPreDrawListener {
        private boolean isAdded;
        private float lastX;
        private float lastY;
        private int lastWidth;
        private int lastHeight;
        private int lastVisible;
        private boolean lastShowState;
        private boolean hasChange;
        Rect lastLocationRect = new Rect();
        Rect newLocationRect = new Rect();

        private LinkedViewLayoutChangeListenerWrapper() {
        }

        void addSelf() {
            if (BasePopupWindow.this.mLinkedViewRef == null || BasePopupWindow.this.mLinkedViewRef.get() == null || this.isAdded) {
                return;
            }
            View target = (View)BasePopupWindow.this.mLinkedViewRef.get();
            target.getGlobalVisibleRect(this.lastLocationRect);
            this.refreshViewParams();
            target.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.isAdded = true;
        }

        void removeListener() {
            if (BasePopupWindow.this.mLinkedViewRef == null || BasePopupWindow.this.mLinkedViewRef.get() == null || !this.isAdded) {
                return;
            }
            ((View)BasePopupWindow.this.mLinkedViewRef.get()).getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.isAdded = false;
        }

        void refreshViewParams() {
            if (BasePopupWindow.this.mLinkedViewRef == null || BasePopupWindow.this.mLinkedViewRef.get() == null) {
                return;
            }
            View target = (View)BasePopupWindow.this.mLinkedViewRef.get();
            float curX = target.getX();
            float curY = target.getY();
            int curWidth = target.getWidth();
            int curHeight = target.getHeight();
            int curVisible = target.getVisibility();
            boolean isShow = target.isShown();
            boolean bl = this.hasChange = (curX != this.lastX || curY != this.lastY || curWidth != this.lastWidth || curHeight != this.lastHeight || curVisible != this.lastVisible) && this.isAdded;
            if (!this.hasChange) {
                target.getGlobalVisibleRect(this.newLocationRect);
                if (!this.newLocationRect.equals((Object)this.lastLocationRect)) {
                    this.lastLocationRect.set(this.newLocationRect);
                    if (!this.handleShowChange(target, this.lastShowState, isShow)) {
                        this.hasChange = true;
                    }
                }
            }
            this.lastX = curX;
            this.lastY = curY;
            this.lastWidth = curWidth;
            this.lastHeight = curHeight;
            this.lastVisible = curVisible;
            this.lastShowState = isShow;
        }

        private boolean handleShowChange(View target, boolean lastShowState, boolean isShow) {
            if (lastShowState && !isShow) {
                if (BasePopupWindow.this.isShowing()) {
                    BasePopupWindow.this.dismiss(false);
                    return true;
                }
            } else if (!lastShowState && isShow && !BasePopupWindow.this.isShowing()) {
                BasePopupWindow.this.tryToShowPopup(target, false, true);
                return true;
            }
            return false;
        }

        public boolean onPreDraw() {
            if (BasePopupWindow.this.mLinkedViewRef == null || BasePopupWindow.this.mLinkedViewRef.get() == null) {
                return true;
            }
            this.refreshViewParams();
            if (this.hasChange) {
                BasePopupWindow.this.update((View)BasePopupWindow.this.mLinkedViewRef.get());
            }
            return true;
        }
    }

    private static class GlobalLayoutListenerWrapper
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> target;
        private OnKeyboardStateChangeListener mListener;
        int preKeyboardHeight = -1;
        Rect rect = new Rect();
        boolean preVisible = false;
        private volatile boolean isAttached;

        GlobalLayoutListenerWrapper(View target, OnKeyboardStateChangeListener listener) {
            this.target = new WeakReference<View>(target);
            this.mListener = listener;
            this.isAttached = false;
        }

        boolean isAttached() {
            return this.isAttached;
        }

        void addSelf() {
            if (this.getTarget() != null && !this.isAttached) {
                this.getTarget().getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.isAttached = true;
            }
        }

        void remove() {
            if (this.getTarget() != null && this.isAttached) {
                this.getTarget().getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.isAttached = false;
            }
        }

        View getTarget() {
            return this.target == null ? null : (View)this.target.get();
        }

        public void onGlobalLayout() {
            boolean isVisible;
            View mTarget = this.getTarget();
            if (mTarget == null) {
                return;
            }
            this.rect.setEmpty();
            mTarget.getWindowVisibleDisplayFrame(this.rect);
            int displayHeight = this.rect.height();
            int windowHeight = mTarget.getHeight();
            int keyboardHeight = windowHeight - displayHeight;
            boolean bl = isVisible = (float)keyboardHeight > (float)windowHeight * 0.15f;
            if (isVisible == this.preVisible && this.preKeyboardHeight == keyboardHeight) {
                return;
            }
            if (this.mListener != null) {
                this.mListener.onKeyboardChange(keyboardHeight, isVisible);
            }
            this.preVisible = isVisible;
            this.preKeyboardHeight = keyboardHeight;
        }
    }

    static interface OnKeyboardStateChangeListener {
        public void onKeyboardChange(int var1, boolean var2);
    }

    public static abstract class OnDismissListener
    implements PopupWindow.OnDismissListener {
        public boolean onBeforeDismiss() {
            return true;
        }

        public void onDismissAnimationStart() {
        }
    }

    public static interface OnBlurOptionInitListener {
        public void onCreateBlurOption(PopupBlurOption var1);
    }

    public static interface OnBeforeShowCallback {
        public boolean onBeforeShow(View var1, View var2, boolean var3);
    }

    public static enum GravityMode {
        RELATIVE_TO_ANCHOR,
        ALIGN_TO_ANCHOR_SIDE;

    }
}

