/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.HackPopupDecorView;
import razerdp.basepopup.InnerPopupWindowStateListener;
import razerdp.basepopup.PopupMaskLayout;
import razerdp.basepopup.PopupTouchController;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

final class HackWindowManager
extends InnerPopupWindowStateListener
implements WindowManager {
    private static final String TAG = "HackWindowManager";
    private WindowManager mWindowManager;
    private WeakReference<PopupTouchController> mPopupController;
    private WeakReference<HackPopupDecorView> mHackPopupDecorView;
    private WeakReference<BasePopupHelper> mPopupHelper;
    private WeakReference<PopupMaskLayout> mMaskLayout;
    private static int statusBarHeight;

    public HackWindowManager(WindowManager windowManager, PopupTouchController popupTouchController) {
        this.mWindowManager = windowManager;
        this.mPopupController = new WeakReference<PopupTouchController>(popupTouchController);
    }

    public Display getDefaultDisplay() {
        return this.mWindowManager == null ? null : this.mWindowManager.getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeViewImmediate  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getHackPopupDecorView() != null) {
            if (this.getMaskLayout() != null) {
                try {
                    this.mWindowManager.removeViewImmediate((View)this.getMaskLayout());
                    this.mMaskLayout.clear();
                    this.mMaskLayout = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            if (Build.VERSION.SDK_INT >= 19 && !hackPopupDecorView.isAttachedToWindow()) {
                return;
            }
            this.mWindowManager.removeViewImmediate((View)hackPopupDecorView);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.mWindowManager.removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.addView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view)) {
            BasePopupHelper helper = this.getBasePopupHelper();
            HackPopupDecorView hackPopupDecorView = new HackPopupDecorView(view.getContext());
            params = hackPopupDecorView.addPopupDecorView(view, params, helper, this.getPopupController());
            this.mMaskLayout = new WeakReference<PopupMaskLayout>(PopupMaskLayout.create(view.getContext(), helper, this.fitLayoutParamsPosition(params)));
            this.mHackPopupDecorView = new WeakReference<HackPopupDecorView>(hackPopupDecorView);
            if (this.getPopupController() instanceof BasePopupWindow) {
                ((BasePopupWindow)this.getPopupController()).setOnInnerPopupWindowStateListener(this);
            }
            hackPopupDecorView.setOnAttachListener(new HackPopupDecorView.OnAttachListener(){

                @Override
                public void onAttachtoWindow() {
                    if (HackWindowManager.this.getMaskLayout() != null) {
                        HackWindowManager.this.getMaskLayout().handleStart(-2L);
                    }
                }
            });
            if (this.getMaskLayout() != null) {
                this.mWindowManager.addView((View)this.getMaskLayout(), this.createBlurBackgroundWindowParams(params));
            }
            this.mWindowManager.addView((View)hackPopupDecorView, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.addView(view, params);
        }
    }

    private ViewGroup.LayoutParams fitLayoutParamsPosition(ViewGroup.LayoutParams params) {
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            p.type = 1002;
            BasePopupHelper helper = this.getBasePopupHelper();
            if (helper != null && helper.isShowAsDropDown() && p.y <= helper.getAnchorY()) {
                int y = helper.getAnchorY() + helper.getAnchorHeight() + helper.getInternalOffsetY();
                p.y = y <= 0 ? 0 : y;
            }
        }
        return params;
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.updateViewLayout  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getHackPopupDecorView() != null) {
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.mWindowManager.updateViewLayout((View)hackPopupDecorView, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.updateViewLayout(view, params);
        }
    }

    public void removeView(View view) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getHackPopupDecorView() != null) {
            if (this.getMaskLayout() != null) {
                try {
                    this.mWindowManager.removeView((View)this.getMaskLayout());
                    if (this.mMaskLayout != null) {
                        this.mMaskLayout.clear();
                        this.mMaskLayout = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.mWindowManager.removeView((View)hackPopupDecorView);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.mWindowManager.removeView(view);
        }
    }

    public void clear() {
        try {
            this.removeViewImmediate((View)this.mHackPopupDecorView.get());
            this.removeViewImmediate((View)this.getMaskLayout());
            this.mHackPopupDecorView.clear();
            if (this.mMaskLayout != null) {
                this.mMaskLayout.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ViewGroup.LayoutParams createBlurBackgroundWindowParams(ViewGroup.LayoutParams params) {
        ViewGroup.LayoutParams result = new ViewGroup.LayoutParams(params);
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams mResults = new WindowManager.LayoutParams();
            mResults.copyFrom((WindowManager.LayoutParams)params);
            mResults.flags |= 8;
            mResults.flags |= 0x10;
            mResults.flags |= 0x100;
            mResults.windowAnimations = 0;
            mResults.x = 0;
            mResults.y = 0;
            mResults.format = 1;
            result = mResults;
        }
        result.width = -1;
        result.height = -1;
        return result;
    }

    private boolean isPopupInnerDecorView(View v) {
        if (v == null) {
            return false;
        }
        String viewSimpleClassName = v.getClass().getSimpleName();
        return TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupDecorView") || TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupViewContainer");
    }

    private HackPopupDecorView getHackPopupDecorView() {
        if (this.mHackPopupDecorView == null) {
            return null;
        }
        return (HackPopupDecorView)((Object)this.mHackPopupDecorView.get());
    }

    private PopupTouchController getPopupController() {
        if (this.mPopupController == null) {
            return null;
        }
        return (PopupTouchController)this.mPopupController.get();
    }

    private BasePopupHelper getBasePopupHelper() {
        if (this.mPopupHelper == null) {
            return null;
        }
        return (BasePopupHelper)this.mPopupHelper.get();
    }

    private PopupMaskLayout getMaskLayout() {
        if (this.mMaskLayout == null) {
            return null;
        }
        return (PopupMaskLayout)((Object)this.mMaskLayout.get());
    }

    void bindPopupHelper(BasePopupHelper helper) {
        this.mPopupHelper = new WeakReference<BasePopupHelper>(helper);
    }

    private void checkStatusBarHeight(Context context) {
        if (statusBarHeight != 0 || context == null) {
            return;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }

    @Override
    void onAnimateDismissStart() {
        if (this.getMaskLayout() != null) {
            this.getMaskLayout().handleDismiss(-2L);
        }
    }

    @Override
    void onNoAnimateDismiss() {
        if (this.getMaskLayout() != null) {
            this.getMaskLayout().handleDismiss(0L);
        }
    }
}

