/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupBackgroundView;
import razerdp.blur.BlurImageView;
import razerdp.util.PopupUtil;

class PopupMaskLayout
extends FrameLayout {
    private PopupBackgroundView mBackgroundView;
    private BlurImageView mBlurImageView;

    private PopupMaskLayout(Context context) {
        this(context, null);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static PopupMaskLayout create(Context context, BasePopupHelper helper, ViewGroup.LayoutParams params) {
        PopupMaskLayout view = new PopupMaskLayout(context);
        view.init(context, helper, params);
        return view;
    }

    private void init(Context context, BasePopupHelper mHelper, ViewGroup.LayoutParams params) {
        if (mHelper == null) {
            this.setVisibility(8);
            return;
        }
        this.setLayoutAnimation(null);
        this.setVisibility(0);
        if (mHelper.isAllowToBlur()) {
            this.mBlurImageView = new BlurImageView(context);
            this.mBlurImageView.applyBlurOption(mHelper.getBlurOption());
            this.addViewInLayout((View)this.mBlurImageView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        if (!PopupUtil.isBackgroundInvalidated(mHelper.getPopupBackground())) {
            this.mBackgroundView = PopupBackgroundView.creaete(context, mHelper);
            FrameLayout.LayoutParams backgroundViewParams = this.generateDefaultLayoutParams();
            if (mHelper.isAlignBackground() && params instanceof WindowManager.LayoutParams) {
                backgroundViewParams.topMargin = ((WindowManager.LayoutParams)params).y;
            }
            this.addViewInLayout(this.mBackgroundView, -1, (ViewGroup.LayoutParams)backgroundViewParams);
        }
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void handleStart(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.start(duration);
        }
    }

    public void handleDismiss(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.dismiss(duration);
        }
        if (this.mBackgroundView != null) {
            this.mBackgroundView.handleAnimateDismiss();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllViews();
        if (this.mBackgroundView != null) {
            this.mBackgroundView.destroy();
            this.mBackgroundView = null;
        }
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
            this.mBlurImageView = null;
        }
    }
}

