/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.widget.PopupWindow;
import razerdp.basepopup.BasePopupWindow;
import razerdp.blur.PopupBlurOption;
import razerdp.library.R;

final class BasePopupHelper {
    private boolean autoShowInputMethod = false;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mDismissAnimation;
    private Animator mDismissAnimator;
    private BasePopupWindow.OnDismissListener mOnDismissListener;
    private BasePopupWindow.OnBeforeShowCallback mOnBeforeShowCallback;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int internalOffsetX;
    private int internalOffsetY;
    private int preMeasureWidth;
    private int preMeasureHeight;
    private int popupViewWidth;
    private int popupViewHeight;
    private int[] mAnchorViewLocation;
    private int mAnchorViewHeight;
    private boolean isAutoLocatePopup;
    private boolean isShowAsDropDown;
    private boolean dismissWhenTouchOutside;
    private boolean fullScreen = false;
    private volatile boolean isPopupFadeEnable = true;
    private boolean backPressEnable = true;
    private boolean interceptOutSideTouchEvent = true;
    private PopupBlurOption mBlurOption;
    private boolean mAlignBackground = true;
    private Drawable mBackgroundDrawable = new ColorDrawable(Color.parseColor((String)"#8f000000"));

    BasePopupHelper() {
        this.mAnchorViewLocation = new int[2];
    }

    Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    BasePopupHelper setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation == showAnimation) {
            return this;
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
        }
        this.mShowAnimation = showAnimation;
        return this;
    }

    Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    BasePopupHelper setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator == showAnimator) {
            return this;
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        this.mShowAnimator = showAnimator;
        return this;
    }

    Animation getDismissAnimation() {
        return this.mDismissAnimation;
    }

    BasePopupHelper setDismissAnimation(Animation dismissAnimation) {
        if (this.mDismissAnimation == dismissAnimation) {
            return this;
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        this.mDismissAnimation = dismissAnimation;
        return this;
    }

    Animator getDismissAnimator() {
        return this.mDismissAnimator;
    }

    BasePopupHelper setDismissAnimator(Animator dismissAnimator) {
        if (this.mDismissAnimator == dismissAnimator) {
            return this;
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        this.mDismissAnimator = dismissAnimator;
        return this;
    }

    int getPopupViewWidth() {
        return this.popupViewWidth;
    }

    BasePopupHelper setPopupViewWidth(int popupViewWidth) {
        this.popupViewWidth = popupViewWidth;
        return this;
    }

    int getPopupViewHeight() {
        return this.popupViewHeight;
    }

    BasePopupHelper setPopupViewHeight(int popupViewHeight) {
        this.popupViewHeight = popupViewHeight;
        return this;
    }

    int getPreMeasureWidth() {
        return this.preMeasureWidth;
    }

    BasePopupHelper setPreMeasureWidth(int preMeasureWidth) {
        this.preMeasureWidth = preMeasureWidth;
        return this;
    }

    int getPreMeasureHeight() {
        return this.preMeasureHeight;
    }

    BasePopupHelper setPreMeasureHeight(int preMeasureHeight) {
        this.preMeasureHeight = preMeasureHeight;
        return this;
    }

    boolean isPopupFadeEnable() {
        return this.isPopupFadeEnable;
    }

    BasePopupHelper setPopupFadeEnable(PopupWindow popupWindow, boolean needPopupFadeAnima) {
        if (popupWindow == null) {
            return this;
        }
        this.isPopupFadeEnable = needPopupFadeAnima;
        popupWindow.setAnimationStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
        return this;
    }

    boolean isShowAsDropDown() {
        return this.isShowAsDropDown;
    }

    BasePopupHelper setShowAsDropDown(boolean showAsDropDown) {
        this.isShowAsDropDown = showAsDropDown;
        return this;
    }

    int getPopupGravity() {
        return this.popupGravity;
    }

    BasePopupHelper setPopupGravity(int popupGravity) {
        this.popupGravity = popupGravity;
        return this;
    }

    int getOffsetX() {
        return this.offsetX;
    }

    BasePopupHelper setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    int getOffsetY() {
        return this.offsetY;
    }

    BasePopupHelper setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    boolean isAutoShowInputMethod() {
        return this.autoShowInputMethod;
    }

    BasePopupHelper setAutoShowInputMethod(PopupWindow popupWindow, boolean autoShowInputMethod) {
        if (popupWindow == null) {
            return this;
        }
        this.autoShowInputMethod = autoShowInputMethod;
        popupWindow.setSoftInputMode(autoShowInputMethod ? 16 : 1);
        return this;
    }

    boolean isAutoLocatePopup() {
        return this.isAutoLocatePopup;
    }

    BasePopupHelper setAutoLocatePopup(boolean autoLocatePopup) {
        this.isAutoLocatePopup = autoLocatePopup;
        return this;
    }

    BasePopupWindow.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    BasePopupHelper setOnDismissListener(BasePopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    BasePopupWindow.OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    BasePopupHelper setOnBeforeShowCallback(BasePopupWindow.OnBeforeShowCallback onBeforeShowCallback) {
        this.mOnBeforeShowCallback = onBeforeShowCallback;
        return this;
    }

    boolean isDismissWhenTouchOutside() {
        return this.dismissWhenTouchOutside;
    }

    BasePopupHelper setDismissWhenTouchOutside(PopupWindow popupWindow, boolean dismissWhenTouchOutside) {
        if (popupWindow == null) {
            return this;
        }
        this.dismissWhenTouchOutside = dismissWhenTouchOutside;
        return this;
    }

    boolean isInterceptTouchEvent() {
        return this.interceptOutSideTouchEvent;
    }

    BasePopupHelper setInterceptTouchEvent(PopupWindow popupWindow, boolean intecept) {
        if (popupWindow == null) {
            return this;
        }
        this.interceptOutSideTouchEvent = intecept;
        return this;
    }

    BasePopupHelper getAnchorLocation(View v) {
        if (v == null) {
            return this;
        }
        v.getLocationOnScreen(this.mAnchorViewLocation);
        this.mAnchorViewHeight = v.getHeight();
        return this;
    }

    int getAnchorHeight() {
        return this.mAnchorViewHeight;
    }

    int getAnchorX() {
        return this.mAnchorViewLocation[0];
    }

    int getAnchorY() {
        return this.mAnchorViewLocation[1];
    }

    int getInternalOffsetX() {
        return this.internalOffsetX + this.offsetX;
    }

    BasePopupHelper setInternalOffsetX(int internalOffsetX) {
        this.internalOffsetX = internalOffsetX;
        return this;
    }

    int getInternalOffsetY() {
        return this.internalOffsetY + this.offsetY;
    }

    BasePopupHelper setInternalOffsetY(int internalOffsetY) {
        this.internalOffsetY = internalOffsetY;
        return this;
    }

    public boolean isBackPressEnable() {
        return this.backPressEnable;
    }

    BasePopupHelper setBackPressEnable(PopupWindow popupWindow, boolean backPressEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.backPressEnable = backPressEnable;
        return this;
    }

    boolean isFullScreen() {
        return this.fullScreen;
    }

    BasePopupHelper setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
        return this;
    }

    PopupBlurOption getBlurOption() {
        return this.mBlurOption;
    }

    BasePopupHelper applyBlur(PopupBlurOption option) {
        this.mBlurOption = option;
        return this;
    }

    long getShowAnimationDuration() {
        long duration = 0L;
        if (this.mShowAnimation != null) {
            duration = this.mShowAnimation.getDuration();
        } else if (this.mShowAnimator != null) {
            duration = this.mShowAnimator.getDuration();
        }
        return duration < 0L ? 300L : duration;
    }

    long getExitAnimationDuration() {
        long duration = 0L;
        if (this.mDismissAnimation != null) {
            duration = this.mDismissAnimation.getDuration();
        } else if (this.mDismissAnimator != null) {
            duration = this.mDismissAnimator.getDuration();
        }
        return duration < 0L ? 300L : duration;
    }

    public Drawable getPopupBackground() {
        return this.mBackgroundDrawable;
    }

    public BasePopupHelper setPopupBackground(Drawable background) {
        this.mBackgroundDrawable = background;
        return this;
    }

    public boolean isAlignBackground() {
        return this.mAlignBackground;
    }

    public BasePopupHelper setAlignBackgound(boolean mAlignBackground) {
        this.mAlignBackground = mAlignBackground;
        return this;
    }

    public boolean isAllowToBlur() {
        return this.mBlurOption != null && this.mBlurOption.isAllowToBlur();
    }
}

