/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.InnerPopupWindowStateListener;
import razerdp.basepopup.PopupController;
import razerdp.basepopup.PopupWindowProxy;
import razerdp.blur.PopupBlurOption;
import razerdp.util.InputMethodUtils;
import razerdp.util.SimpleAnimationUtils;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener,
PopupController {
    private static final String TAG = "BasePopupWindow";
    private static final int MAX_RETRY_SHOW_TIME = 3;
    private BasePopupHelper mHelper;
    private PopupWindowProxy mPopupWindow;
    private View mPopupView;
    private WeakReference<Context> mContext;
    protected View mAnimaView;
    protected View mDismissView;
    private volatile boolean isExitAnimaPlaying = false;
    private volatile int retryCounter;
    private InnerPopupWindowStateListener mStateListener;
    private Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = true;
            if (BasePopupWindow.this.mStateListener != null) {
                BasePopupWindow.this.mStateListener.onAnimaDismissStart();
            }
        }

        public void onAnimationEnd(Animator animation) {
            BasePopupWindow.this.mPopupView.post(new Runnable(){

                @Override
                public void run() {
                    BasePopupWindow.this.mPopupWindow.callSuperDismiss();
                    BasePopupWindow.this.isExitAnimaPlaying = false;
                }
            });
        }

        public void onAnimationCancel(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }
    };
    private Animation.AnimationListener mAnimationListener = new SimpleAnimationUtils.AnimationListenerAdapter(){

        @Override
        public void onAnimationStart(Animation animation) {
            BasePopupWindow.this.isExitAnimaPlaying = true;
            if (BasePopupWindow.this.mStateListener != null) {
                BasePopupWindow.this.mStateListener.onAnimaDismissStart();
            }
        }

        @Override
        public void onAnimationEnd(Animation animation) {
            BasePopupWindow.this.mPopupView.post(new Runnable(){

                @Override
                public void run() {
                    BasePopupWindow.this.mPopupWindow.callSuperDismiss();
                    BasePopupWindow.this.isExitAnimaPlaying = false;
                }
            });
        }
    };

    public BasePopupWindow(Context context) {
        this.initView(context, -1, -1);
    }

    public BasePopupWindow(Context context, int w, int h) {
        this.initView(context, w, h);
    }

    private void initView(Context context, int w, int h) {
        this.mContext = new WeakReference<Context>(context);
        this.mHelper = new BasePopupHelper();
        this.mPopupView = this.onCreatePopupView();
        this.mAnimaView = this.initAnimaView();
        if (this.mAnimaView != null) {
            this.mHelper.setPopupLayoutId(this.mAnimaView.getId());
        }
        this.checkPopupAnimaView();
        this.mPopupWindow = new PopupWindowProxy(this.mPopupView, w, h, (PopupController)this);
        this.mPopupWindow.setOnDismissListener(this);
        this.mPopupWindow.bindPopupHelper(this.mHelper);
        this.setDismissWhenTouchOutside(true);
        this.mHelper.setPopupViewWidth(w);
        this.mHelper.setPopupViewHeight(h);
        this.preMeasurePopupView(w, h);
        this.setNeedPopupFade(Build.VERSION.SDK_INT <= 22);
        this.mDismissView = this.getClickToDismissView();
        if (this.mDismissView != null && !(this.mDismissView instanceof AdapterView)) {
            this.mDismissView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BasePopupWindow.this.dismiss();
                }
            });
        }
        if (this.mAnimaView != null && !(this.mAnimaView instanceof AdapterView)) {
            this.mAnimaView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
        this.mHelper.setShowAnimation(this.initShowAnimation()).setShowAnimator(this.initShowAnimator()).setExitAnimation(this.initExitAnimation()).setExitAnimator(this.initExitAnimator());
    }

    private void checkPopupAnimaView() {
        if (this.mPopupView != null && this.mAnimaView != null && this.mPopupView == this.mAnimaView) {
            try {
                this.mPopupView = new FrameLayout(this.getContext());
                int mPopupLayoutId = this.mHelper.getPopupLayoutId();
                if (mPopupLayoutId == 0) {
                    ((FrameLayout)this.mPopupView).addView(this.mAnimaView);
                } else {
                    this.mAnimaView = View.inflate((Context)this.getContext(), (int)mPopupLayoutId, (ViewGroup)((FrameLayout)this.mPopupView));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void preMeasurePopupView(int w, int h) {
        if (this.mPopupView != null) {
            if (Build.VERSION.SDK_INT <= 18) {
                int contentViewHeight = -1;
                ViewGroup.LayoutParams layoutParams = this.mPopupView.getLayoutParams();
                if (layoutParams != null && layoutParams.height == -2) {
                    contentViewHeight = -2;
                }
                ViewGroup.LayoutParams p = new ViewGroup.LayoutParams(-1, contentViewHeight);
                this.mPopupView.setLayoutParams(p);
            }
            this.mPopupView.measure(w, h);
            this.mHelper.setPreMeasureWidth(this.mPopupView.getMeasuredWidth()).setPreMeasureHeight(this.mPopupView.getMeasuredHeight());
            this.mPopupView.setFocusableInTouchMode(true);
        }
    }

    protected abstract Animation initShowAnimation();

    public abstract View getClickToDismissView();

    protected Animator initShowAnimator() {
        return null;
    }

    public EditText getInputView() {
        return null;
    }

    protected Animation initExitAnimation() {
        return null;
    }

    protected Animator initExitAnimator() {
        return null;
    }

    public BasePopupWindow setNeedPopupFade(boolean needPopupFadeAnima) {
        this.mHelper.setNeedPopupFadeAnima(this.mPopupWindow, needPopupFadeAnima);
        return this;
    }

    public boolean isNeedPopupFade() {
        return this.mHelper.isNeedPopupFadeAnima();
    }

    public BasePopupWindow setPopupAnimaStyle(int animaStyleRes) {
        this.mPopupWindow.setAnimationStyle(animaStyleRes);
        return this;
    }

    public void showPopupWindow() {
        if (this.checkPerformShow(null)) {
            this.mHelper.setShowAtDown(false);
            this.tryToShowPopup(null);
        }
    }

    public void showPopupWindow(int anchorViewResid) {
        Context context = this.getContext();
        assert (context != null) : "context is null";
        if (context instanceof Activity) {
            View v = ((Activity)context).findViewById(anchorViewResid);
            this.showPopupWindow(v);
        } else {
            Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
        }
    }

    public void showPopupWindow(View v) {
        if (this.checkPerformShow(v)) {
            this.mHelper.setShowAtDown(true);
            this.tryToShowPopup(v);
        }
    }

    private void tryToShowPopup(View v) {
        try {
            if (this.isShowing()) {
                return;
            }
            if (v != null) {
                int[] offset = this.calculateOffset(v);
                if (this.mHelper.isShowAtDown()) {
                    this.mPopupWindow.showAsDropDownProxy(v, offset[0], offset[1]);
                } else {
                    this.mPopupWindow.showAtLocationProxy(v, this.mHelper.getPopupGravity(), offset[0], offset[1]);
                }
            } else {
                Context context = this.getContext();
                assert (context != null) : "context is null ! please make sure your activity is not be destroyed";
                if (context instanceof Activity) {
                    this.mPopupWindow.showAtLocationProxy(((Activity)context).findViewById(0x1020002), this.mHelper.getPopupGravity(), this.mHelper.getOffsetX(), this.mHelper.getOffsetY());
                } else {
                    Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
                }
            }
            if (this.mStateListener != null) {
                this.mStateListener.onTryToShow(this.mHelper.getShowAnimation() != null || this.mHelper.getShowAnimator() != null);
            }
            if (this.mAnimaView != null) {
                if (this.mHelper.getShowAnimation() != null) {
                    this.mHelper.getShowAnimation().cancel();
                    this.mAnimaView.startAnimation(this.mHelper.getShowAnimation());
                } else if (this.mHelper.getShowAnimator() != null) {
                    this.mHelper.getShowAnimator().start();
                }
            }
            if (this.mHelper.isAutoShowInputMethod() && this.getInputView() != null) {
                this.getInputView().requestFocus();
                InputMethodUtils.showInputMethod((View)this.getInputView(), 350L);
            }
            this.retryCounter = 0;
        }
        catch (Exception e) {
            if (this.retryCounter > 3) {
                Log.e((String)TAG, (String)("show error\n" + e.getMessage()));
                e.printStackTrace();
                return;
            }
            this.retryToShowPopup(v);
        }
    }

    private void retryToShowPopup(final View v) {
        Context context;
        if (this.retryCounter > 3) {
            return;
        }
        Log.e((String)TAG, (String)("catch an exception on showing popupwindow ...now retrying to show ... retry count  >>  " + this.retryCounter));
        if (this.isShowing()) {
            this.mPopupWindow.callSuperDismiss();
        }
        if ((context = this.getContext()) instanceof Activity) {
            boolean availabled;
            Activity act = (Activity)context;
            if (Build.VERSION.SDK_INT >= 17) {
                availabled = !act.isFinishing() && !act.isDestroyed();
            } else {
                boolean bl = availabled = !act.isFinishing();
            }
            if (availabled) {
                View rootView = act.findViewById(0x1020002);
                if (rootView == null) {
                    return;
                }
                rootView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BasePopupWindow.this.retryCounter++;
                        BasePopupWindow.this.tryToShowPopup(v);
                    }
                }, 350L);
            }
        }
    }

    private int[] calculateOffset(View anchorView) {
        int[] offset = new int[]{this.mHelper.getOffsetX(), this.mHelper.getOffsetY()};
        this.mHelper.getAnchorLocation(anchorView);
        if (this.mHelper.isAutoLocatePopup()) {
            boolean onTop;
            boolean bl = onTop = this.getScreenHeight() - (this.mHelper.getAnchorY() + offset[1]) < this.getHeight();
            if (onTop) {
                offset[1] = -anchorView.getHeight() - this.getHeight() - offset[1];
                this.showOnTop(this.mPopupView, anchorView);
            } else {
                this.showOnDown(this.mPopupView, anchorView);
            }
        }
        return offset;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust) {
        this.setAdjustInputMethod(needAdjust, 16);
        return this;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust, int flag) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(flag);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
        }
        return this;
    }

    public BasePopupWindow setAutoShowInputMethod(boolean autoShow) {
        this.mHelper.setAutoShowInputMethod(this.mPopupWindow, autoShow);
        return this;
    }

    public BasePopupWindow setBackPressEnable(boolean backPressEnable) {
        this.mHelper.setBackPressEnable(this.mPopupWindow, backPressEnable);
        return this;
    }

    public View createPopupById(int resId) {
        if (resId != 0) {
            this.mHelper.setPopupLayoutId(resId);
            return LayoutInflater.from((Context)this.getContext()).inflate(resId, null);
        }
        return null;
    }

    protected View findViewById(int id2) {
        if (this.mPopupView != null && id2 != 0) {
            return this.mPopupView.findViewById(id2);
        }
        return null;
    }

    public BasePopupWindow setPopupWindowFullScreen(boolean needFullScreen) {
        this.mHelper.setFullScreen(needFullScreen);
        return this;
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blur) {
        return this.setBlurBackgroundEnable(blur, null);
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blur, OnBlurOptionInitListener l) {
        if (!(this.getContext() instanceof Activity)) {
            PopupLogUtil.trace(LogTag.e, TAG, "\u65e0\u6cd5\u914d\u7f6e\u9ed8\u8ba4\u6a21\u7cca\u811a\u672c\uff0c\u56e0\u4e3acontext\u4e0d\u662factivity");
            return this;
        }
        PopupBlurOption option = null;
        if (blur) {
            View decorView;
            option = new PopupBlurOption();
            option.setFullScreen(true).setBlurInDuration(this.mHelper.getShowAnimationDuration()).setBlurOutDuration(this.mHelper.getExitAnimationDuration());
            if (l != null) {
                l.onCreateBlurOption(option);
            }
            if ((decorView = ((Activity)this.getContext()).getWindow().getDecorView()) instanceof ViewGroup) {
                option.setBlurView(((ViewGroup)decorView).getChildAt(0));
            } else {
                option.setBlurView(decorView);
            }
        }
        return this.setBlurOption(option);
    }

    public BasePopupWindow setBlurOption(PopupBlurOption option) {
        this.mHelper.applyBlur(option);
        return this;
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mHelper.getOnDismissListener();
    }

    public BasePopupWindow setOnDismissListener(OnDismissListener onDismissListener) {
        this.mHelper.setOnDismissListener(onDismissListener);
        return this;
    }

    public OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mHelper.getOnBeforeShowCallback();
    }

    public BasePopupWindow setOnBeforeShowCallback(OnBeforeShowCallback mOnBeforeShowCallback) {
        this.mHelper.setOnBeforeShowCallback(mOnBeforeShowCallback);
        return this;
    }

    public BasePopupWindow setShowAnimation(Animation showAnimation) {
        this.mHelper.setShowAnimation(showAnimation);
        return this;
    }

    public Animation getShowAnimation() {
        return this.mHelper.getShowAnimation();
    }

    public BasePopupWindow setShowAnimator(Animator showAnimator) {
        this.mHelper.setShowAnimator(showAnimator);
        return this;
    }

    public Animator getShowAnimator() {
        return this.mHelper.getShowAnimator();
    }

    public BasePopupWindow setExitAnimation(Animation exitAnimation) {
        this.mHelper.setExitAnimation(exitAnimation);
        return this;
    }

    public Animation getExitAnimation() {
        return this.mHelper.getExitAnimation();
    }

    public BasePopupWindow setExitAnimator(Animator exitAnimator) {
        this.mHelper.setExitAnimator(exitAnimator);
        return this;
    }

    public Animator getExitAnimator() {
        return this.mHelper.getExitAnimator();
    }

    public Context getContext() {
        return this.mContext == null ? null : (Context)this.mContext.get();
    }

    public View getPopupWindowView() {
        return this.mPopupView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getOffsetX() {
        return this.mHelper.getOffsetX();
    }

    public BasePopupWindow setOffsetX(int offsetX) {
        this.mHelper.setOffsetX(offsetX);
        return this;
    }

    public int getOffsetY() {
        return this.mHelper.getOffsetY();
    }

    public BasePopupWindow setOffsetY(int offsetY) {
        this.mHelper.setOffsetY(offsetY);
        return this;
    }

    public int getPopupGravity() {
        return this.mHelper.getPopupGravity();
    }

    public BasePopupWindow setPopupGravity(int popupGravity) {
        this.mHelper.setPopupGravity(popupGravity);
        return this;
    }

    public boolean isAutoLocatePopup() {
        return this.mHelper.isAutoLocatePopup();
    }

    public BasePopupWindow setAutoLocatePopup(boolean autoLocatePopup) {
        this.mHelper.setShowAtDown(true).setAutoLocatePopup(true);
        return this;
    }

    public int getHeight() {
        return this.mPopupWindow.getHeight() <= 0 ? this.mHelper.getPreMeasureHeight() : this.mPopupWindow.getHeight();
    }

    public int getWidth() {
        return this.mPopupWindow.getWidth() <= 0 ? this.mHelper.getPreMeasureWidth() : this.mPopupWindow.getWidth();
    }

    public BasePopupWindow setDismissWhenTouchOutside(boolean dismissWhenTouchOutside) {
        this.mHelper.setDismissWhenTouchOutside(this.mPopupWindow, dismissWhenTouchOutside);
        return this;
    }

    public BasePopupWindow setInterceptTouchEvent(boolean touchable) {
        this.mHelper.setInterceptTouchEvent(this.mPopupWindow, touchable);
        return this;
    }

    public boolean isDismissWhenTouchOutside() {
        return this.mHelper.isDismissWhenTouchOutside();
    }

    public boolean isInterceptTouchEvent() {
        return this.mHelper.isInterceptTouchEvent();
    }

    void setOnInnerPopupWIndowStateListener(InnerPopupWindowStateListener listener) {
        this.mStateListener = listener;
    }

    public void dismiss() {
        try {
            this.mPopupWindow.dismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.checkPerformDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        boolean hasAnima = false;
        if (this.mHelper.getExitAnimation() != null && this.mAnimaView != null) {
            if (!this.isExitAnimaPlaying) {
                this.mHelper.getExitAnimation().setAnimationListener(this.mAnimationListener);
                this.mHelper.getExitAnimation().cancel();
                this.mAnimaView.startAnimation(this.mHelper.getExitAnimation());
                this.isExitAnimaPlaying = true;
                hasAnima = true;
            }
        } else if (this.mHelper.getExitAnimator() != null && !this.isExitAnimaPlaying) {
            this.mHelper.getExitAnimator().removeListener(this.mAnimatorListener);
            this.mHelper.getExitAnimator().addListener(this.mAnimatorListener);
            this.mHelper.getExitAnimator().start();
            this.isExitAnimaPlaying = true;
            hasAnima = true;
        }
        if (!hasAnima && this.mStateListener != null) {
            this.mStateListener.onWithAnimaDismiss();
        }
        return !hasAnima;
    }

    public void dismissWithOutAnima() {
        if (!this.checkPerformDismiss()) {
            return;
        }
        if (this.mHelper.getExitAnimation() != null && this.mAnimaView != null) {
            this.mHelper.getExitAnimation().cancel();
        }
        if (this.mHelper.getExitAnimator() != null) {
            this.mHelper.getExitAnimator().removeAllListeners();
        }
        this.mPopupWindow.callSuperDismiss();
        if (this.mStateListener != null) {
            this.mStateListener.onWithAnimaDismiss();
        }
    }

    private boolean checkPerformDismiss() {
        boolean callDismiss = true;
        if (this.mHelper.getOnDismissListener() != null) {
            callDismiss = this.mHelper.getOnDismissListener().onBeforeDismiss();
        }
        return callDismiss && !this.isExitAnimaPlaying;
    }

    private boolean checkPerformShow(View v) {
        boolean result = true;
        if (this.mHelper.getOnBeforeShowCallback() != null) {
            result = this.mHelper.getOnBeforeShowCallback().onBeforeShow(this.mPopupView, v, this.mHelper.getShowAnimation() != null || this.mHelper.getShowAnimator() != null);
        }
        return result;
    }

    @Override
    public boolean onDispatchKeyEvent(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        if (this.mHelper.isBackPressEnable()) {
            this.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public boolean onOutSideTouch() {
        boolean result = false;
        if (this.mHelper.isDismissWhenTouchOutside()) {
            this.dismiss();
            result = true;
        } else if (this.mHelper.isInterceptTouchEvent()) {
            result = true;
        }
        return result;
    }

    protected Animation getTranslateVerticalAnimation(int start, int end, int durationMillis) {
        return SimpleAnimationUtils.getTranslateVerticalAnimation(start, end, durationMillis);
    }

    protected Animation getTranslateVerticalAnimation(float start, float end, int durationMillis) {
        return SimpleAnimationUtils.getTranslateVerticalAnimation(start, end, durationMillis);
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        return SimpleAnimationUtils.getScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
    }

    protected Animation getDefaultScaleAnimation() {
        return this.getDefaultScaleAnimation(true);
    }

    protected Animation getDefaultScaleAnimation(boolean in) {
        return SimpleAnimationUtils.getDefaultScaleAnimation(in);
    }

    protected Animation getDefaultAlphaAnimation() {
        return this.getDefaultAlphaAnimation(true);
    }

    protected Animation getDefaultAlphaAnimation(boolean in) {
        return SimpleAnimationUtils.getDefaultAlphaAnimation(in);
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        return SimpleAnimationUtils.getDefaultSlideFromBottomAnimationSet(this.mAnimaView);
    }

    public int getScreenHeight() {
        return this.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public int getScreenWidth() {
        return this.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    protected void showOnTop(View mPopupView, View anchorView) {
    }

    protected void showOnDown(View mPopupView, View anchorView) {
    }

    public void onDismiss() {
        if (this.mHelper.getOnDismissListener() != null) {
            this.mHelper.getOnDismissListener().onDismiss();
        }
        this.isExitAnimaPlaying = false;
    }

    protected float dipToPx(float dip) {
        if (this.getContext() == null) {
            return dip;
        }
        return dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f;
    }

    public static void debugLog(boolean printLog) {
        PopupLogUtil.setOpenLog(printLog);
    }

    public static abstract class OnDismissListener
    implements PopupWindow.OnDismissListener {
        public boolean onBeforeDismiss() {
            return true;
        }
    }

    public static interface OnBlurOptionInitListener {
        public void onCreateBlurOption(PopupBlurOption var1);
    }

    public static interface OnBeforeShowCallback {
        public boolean onBeforeShow(View var1, View var2, boolean var3);
    }
}

