/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.View;
import razerdp.basepopup.BasePopupWindowProxy;

final class PopupCompatManager {
    private static final String TAG = "PopupCompatManager";
    private static final PopupWindowImpl IMPL;

    PopupCompatManager() {
    }

    public static void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
        if (IMPL != null) {
            IMPL.showAsDropDown(popupWindow, anchor, xoff, yoff, gravity);
        }
    }

    public static void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
        if (IMPL != null) {
            IMPL.showAtLocation(popupWindow, parent, gravity, x, y);
        }
    }

    static {
        int buildVersion = Build.VERSION.SDK_INT;
        IMPL = buildVersion == 24 ? new Impl24() : (buildVersion > 24 ? new ImplOver24() : new ImplBefore24());
    }

    static class ImplOver24
    extends BaseImpl {
        ImplOver24() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            popupWindow.setHeight(-2);
            popupWindow.callSuperShowAsDropDown(anchor, xoff, yoff, gravity);
            this.initSystemBar(popupWindow.getContentView());
        }

        @Override
        public void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            if (!this.checkPopupNotShowing(popupWindow)) {
                return;
            }
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
            this.initSystemBar(popupWindow.getContentView());
        }
    }

    static class Impl24
    extends BaseImpl {
        Impl24() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            int[] anchorLocation = new int[2];
            anchor.getLocationInWindow(anchorLocation);
            xoff = anchorLocation[0] + xoff;
            yoff = anchorLocation[1] + anchor.getHeight() + yoff;
            popupWindow.callSuperShowAtLocation(activity.getWindow().getDecorView(), 0, xoff, yoff);
            this.initSystemBar(popupWindow.getContentView());
        }

        @Override
        public void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            if (!this.checkPopupNotShowing(popupWindow)) {
                return;
            }
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
            this.initSystemBar(popupWindow.getContentView());
        }
    }

    static class ImplBefore24
    extends BaseImpl {
        ImplBefore24() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
        }

        @Override
        public void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            if (!this.checkPopupNotShowing(popupWindow)) {
                return;
            }
            popupWindow.callSuperShowAsDropDown(anchor, xoff, yoff, gravity);
            this.initSystemBar(popupWindow.getContentView());
        }

        @Override
        public void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            if (!this.checkPopupNotShowing(popupWindow)) {
                return;
            }
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
            this.initSystemBar(popupWindow.getContentView());
        }
    }

    static abstract class BaseImpl
    implements PopupWindowImpl {
        BaseImpl() {
        }

        abstract void showAsDropDownImpl(Activity var1, BasePopupWindowProxy var2, View var3, int var4, int var5, int var6);

        @Override
        public void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            if (!this.checkPopupNotShowing(popupWindow)) {
                return;
            }
            Activity activity = popupWindow.scanForActivity(anchor.getContext());
            if (activity == null) {
                Log.e((String)PopupCompatManager.TAG, (String)"please make sure that context is instance of activity");
                return;
            }
            popupWindow.resetTryScanActivityCount();
            this.showAsDropDownImpl(activity, popupWindow, anchor, xoff, yoff, gravity);
        }

        boolean checkPopupNotShowing(BasePopupWindowProxy popupWindow) {
            return popupWindow != null && !popupWindow.callSuperIsShowing();
        }

        void initSystemBar(View view) {
            try {
                if (Build.VERSION.SDK_INT >= 19) {
                    boolean isFullScreen;
                    int uiOptions = 5894;
                    boolean bl = isFullScreen = view.getSystemUiVisibility() == uiOptions;
                    if (isFullScreen) {
                        this.hideSystemUI(view);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void hideSystemUI(View view) {
            if (view == null) {
                return;
            }
            try {
                if (Build.VERSION.SDK_INT >= 19) {
                    int uiOptions = 5894;
                    view.setSystemUiVisibility(uiOptions);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void showSystemUI(View view) {
            try {
                if (Build.VERSION.SDK_INT >= 19) {
                    int uiOptions = 1792;
                    view.setSystemUiVisibility(uiOptions);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static interface PopupWindowImpl {
        public void showAsDropDown(BasePopupWindowProxy var1, View var2, int var3, int var4, int var5);

        public void showAtLocation(BasePopupWindowProxy var1, View var2, int var3, int var4, int var5);
    }
}

