/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.HackWindowManager;
import razerdp.basepopup.PopupController;

abstract class BasePopupWindowProxy
extends PopupWindow {
    private static final String TAG = "BasePopupWindowProxy";
    private static final int MAX_SCAN_ACTIVITY_COUNT = 50;
    private volatile int tryScanActivityCount = 0;
    private PopupController mController;
    private HackWindowManager hackWindowManager;

    public BasePopupWindowProxy(Context context, PopupController mController) {
        super(context);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, PopupController mController) {
        super(context, attrs);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, PopupController mController) {
        super(context, attrs, defStyleAttr);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, PopupController mController) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(View contentView, PopupController mController) {
        super(contentView);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(int width, int height, PopupController mController) {
        super(width, height);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(View contentView, int width, int height, PopupController mController) {
        super(contentView, width, height);
        this.mController = mController;
        this.init();
    }

    public BasePopupWindowProxy(View contentView, int width, int height, boolean focusable, PopupController mController) {
        super(contentView, width, height, focusable);
        this.mController = mController;
        this.init();
    }

    void bindPopupHelper(BasePopupHelper mHelper) {
        if (this.hackWindowManager == null) {
            this.tryToProxyWindowManagerMethod(this);
        }
        this.hackWindowManager.bindPopupHelper(mHelper);
    }

    private void init() {
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.tryToProxyWindowManagerMethod(this);
    }

    public void setContentView(View contentView) {
        super.setContentView(contentView);
        this.tryToProxyWindowManagerMethod(this);
    }

    void callSuperShowAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        Activity activity = this.scanForActivity(anchor.getContext());
        if (activity == null) {
            Log.e((String)TAG, (String)"please make sure that context is instance of activity");
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            super.showAsDropDown(anchor, xoff, yoff, gravity);
        } else {
            super.showAsDropDown(anchor, xoff, yoff);
        }
    }

    void callSuperShowAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
    }

    boolean callSuperIsShowing() {
        return super.isShowing();
    }

    void resetTryScanActivityCount() {
        this.tryScanActivityCount = 0;
    }

    Activity scanForActivity(Context cont) {
        if (cont == null) {
            return null;
        }
        if (cont instanceof Activity) {
            return (Activity)cont;
        }
        if (cont instanceof ContextWrapper) {
            if (this.tryScanActivityCount > 50) {
                return null;
            }
            ++this.tryScanActivityCount;
            return this.scanForActivity(((ContextWrapper)cont).getBaseContext());
        }
        return null;
    }

    public void dismiss() {
        if (this.mController == null) {
            return;
        }
        boolean performDismiss = this.mController.onBeforeDismiss();
        if (!performDismiss) {
            return;
        }
        boolean dismissAtOnce = this.mController.callDismissAtOnce();
        if (dismissAtOnce) {
            this.callSuperDismiss();
        }
    }

    void callSuperDismiss() {
        try {
            super.dismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
            e.printStackTrace();
        }
    }

    private void tryToProxyWindowManagerMethod(PopupWindow popupWindow) {
        try {
            if (this.mController == null || this.hackWindowManager != null) {
                return;
            }
            Field fieldWindowManager = PopupWindow.class.getDeclaredField("mWindowManager");
            fieldWindowManager.setAccessible(true);
            WindowManager windowManager = (WindowManager)fieldWindowManager.get(popupWindow);
            if (windowManager == null) {
                return;
            }
            this.hackWindowManager = new HackWindowManager(windowManager, this.mController);
            fieldWindowManager.set(popupWindow, this.hackWindowManager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

