/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.server;

import com.runjva.sourceforge.jsocks.protocol.InetRange;
import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.server.Ident;
import com.runjva.sourceforge.jsocks.server.ServerAuthenticator;
import com.runjva.sourceforge.jsocks.server.ServerAuthenticatorBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IdentAuthenticator
extends ServerAuthenticatorBase {
    Vector<InetRange> hosts;
    Vector<Hashtable<?, ?>> users;
    String user;

    public IdentAuthenticator() {
        this.hosts = new Vector();
        this.users = new Vector();
    }

    IdentAuthenticator(InputStream in, OutputStream out, String user) {
        super(in, out);
        this.user = user;
    }

    public synchronized void add(InetRange hostRange, Hashtable<?, ?> users) {
        this.hosts.addElement(hostRange);
        this.users.addElement(users);
    }

    @Override
    public ServerAuthenticator startSession(Socket s) throws IOException {
        int ind = this.getRangeIndex(s.getInetAddress());
        String user = null;
        if (ind < 0) {
            return null;
        }
        ServerAuthenticator serverAuthenticator = super.startSession(s);
        ServerAuthenticatorBase auth = (ServerAuthenticatorBase)serverAuthenticator;
        if (auth == null) {
            return null;
        }
        Hashtable<?, ?> user_names = this.users.elementAt(ind);
        if (user_names != null) {
            Ident ident = new Ident(s);
            if (!ident.successful) {
                return null;
            }
            if (!user_names.containsKey(ident.userName)) {
                return null;
            }
            user = ident.userName;
        }
        return new IdentAuthenticator(auth.in, auth.out, user);
    }

    public boolean checkRequest(ProxyMessage msg, Socket s) {
        if (msg.version == 5 || this.user == null) {
            return true;
        }
        if (msg.version != 4) {
            return false;
        }
        return this.user.equals(msg.user);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.hosts.size(); ++i) {
            s = s + "(Range:" + this.hosts.elementAt(i) + "," + " Users:" + this.userNames(i) + ") ";
        }
        return s;
    }

    private int getRangeIndex(InetAddress ip) {
        int index = 0;
        Enumeration<InetRange> enumx = this.hosts.elements();
        while (enumx.hasMoreElements()) {
            InetRange ir = enumx.nextElement();
            if (ir.contains(ip)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String userNames(int i) {
        if (this.users.elementAt(i) == null) {
            return "Everybody is permitted.";
        }
        Enumeration<?> enumx = this.users.elementAt(i).keys();
        if (!enumx.hasMoreElements()) {
            return "";
        }
        String s = enumx.nextElement().toString();
        while (enumx.hasMoreElements()) {
            s = s + "; " + enumx.nextElement();
        }
        return s;
    }
}

