/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.main;

import com.runjva.sourceforge.jsocks.protocol.InetRange;
import com.runjva.sourceforge.jsocks.protocol.ProxyServer;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.server.IdentAuthenticator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOCKS {
    private static final int DEFAULT_LISTENING_PORT = 1080;
    private static final Logger log = LoggerFactory.getLogger(SOCKS.class);

    public static void usage() {
        System.out.println("Usage: java SOCKS [inifile1 inifile2 ...]\nIf none inifile is given, uses socks.properties.\n");
    }

    public static void main(String[] args) {
        int port = 1080;
        String logFile = null;
        String host = null;
        IdentAuthenticator auth = new IdentAuthenticator();
        InetAddress localIP = null;
        String[] file_names = args.length == 0 ? new String[]{"socks.properties"} : args;
        SOCKS.inform("Loading properties");
        for (int i = 0; i < file_names.length; ++i) {
            SOCKS.inform("Reading file " + file_names[i]);
            Properties pr = SOCKS.loadProperties(file_names[i]);
            if (pr == null) {
                System.err.println("Loading of properties from " + file_names[i] + "failed.");
                SOCKS.usage();
                return;
            }
            if (!SOCKS.addAuth(auth, pr)) {
                System.err.println("Error in file " + file_names[i] + ".");
                SOCKS.usage();
                return;
            }
            if (i != 0) continue;
            String port_s = (String)pr.get("port");
            if (port_s != null) {
                try {
                    port = Integer.parseInt(port_s);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse port: " + port_s);
                    return;
                }
            }
            SOCKS.serverInit(pr);
            logFile = (String)pr.get("log");
            host = (String)pr.get("host");
        }
        if (logFile != null) {
            System.err.println("log property not supported anymore.");
        }
        if (host != null) {
            try {
                localIP = InetAddress.getByName(host);
            }
            catch (UnknownHostException uhe) {
                System.err.println("Can't resolve local ip: " + host);
                return;
            }
        }
        SOCKS.inform("Using Ident Authentication scheme: " + auth);
        ProxyServer server = new ProxyServer(auth);
        server.start(port, 5, localIP);
    }

    static Properties loadProperties(String file_name) {
        Properties pr = new Properties();
        try {
            FileInputStream fin = new FileInputStream(file_name);
            pr.load(fin);
            ((InputStream)fin).close();
        }
        catch (IOException ioe) {
            return null;
        }
        return pr;
    }

    static boolean addAuth(IdentAuthenticator ident, Properties pr) {
        String range = (String)pr.get("range");
        if (range == null) {
            return false;
        }
        InetRange irange = SOCKS.parseInetRange(range);
        String users = (String)pr.get("users");
        if (users == null) {
            ident.add(irange, null);
            return true;
        }
        Hashtable<String, String> uhash = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(users, ";");
        while (st.hasMoreTokens()) {
            uhash.put(st.nextToken(), "");
        }
        ident.add(irange, uhash);
        return true;
    }

    static void serverInit(Properties props) {
        int val = SOCKS.readInt(props, "iddleTimeout");
        if (val >= 0) {
            ProxyServer.setIddleTimeout(val);
            SOCKS.inform("Setting iddle timeout to " + val + " ms.");
        }
        if ((val = SOCKS.readInt(props, "acceptTimeout")) >= 0) {
            ProxyServer.setAcceptTimeout(val);
            SOCKS.inform("Setting accept timeout to " + val + " ms.");
        }
        if ((val = SOCKS.readInt(props, "udpTimeout")) >= 0) {
            ProxyServer.setUDPTimeout(val);
            SOCKS.inform("Setting udp timeout to " + val + " ms.");
        }
        if ((val = SOCKS.readInt(props, "datagramSize")) >= 0) {
            ProxyServer.setDatagramSize(val);
            SOCKS.inform("Setting datagram size to " + val + " bytes.");
        }
        SOCKS.proxyInit(props);
    }

    static void proxyInit(Properties props) {
        SocksProxyBase proxy = null;
        String proxy_list = (String)props.get("proxy");
        if (proxy_list == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(proxy_list, ";");
        while (st.hasMoreTokens()) {
            String proxy_entry = st.nextToken();
            SocksProxyBase p = SocksProxyBase.parseProxy(proxy_entry);
            if (p == null) {
                SOCKS.exit("Can't parse proxy entry:" + proxy_entry);
            }
            SOCKS.inform("Adding Proxy:" + p);
            if (proxy != null) {
                p.setChainProxy(proxy);
            }
            proxy = p;
        }
        if (proxy == null) {
            return;
        }
        String direct_hosts = (String)props.get("directHosts");
        if (direct_hosts != null) {
            InetRange ir = SOCKS.parseInetRange(direct_hosts);
            SOCKS.inform("Setting direct hosts:" + ir);
            proxy.setDirect(ir);
        }
        ProxyServer.setProxy(proxy);
    }

    static InetRange parseInetRange(String source) {
        InetRange irange = new InetRange();
        StringTokenizer st = new StringTokenizer(source, ";");
        while (st.hasMoreTokens()) {
            irange.add(st.nextToken());
        }
        return irange;
    }

    static int readInt(Properties props, String name) {
        int result = -1;
        String val = (String)props.get(name);
        if (val == null) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(val);
        if (!st.hasMoreElements()) {
            return -1;
        }
        try {
            result = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            SOCKS.inform("Bad value for " + name + ":" + val);
        }
        return result;
    }

    static void inform(String s) {
        log.info(s);
    }

    static void exit(String msg) {
        System.err.println("Error:" + msg);
        System.err.println("Aborting operation");
        System.exit(0);
    }
}

