/*
 * Decompiled with CFR 0.152.
 */
package com.apt7.rxpermissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.apt7.rxpermissions.Permission;
import com.apt7.rxpermissions.PermissionsIgnoreList;
import com.apt7.rxpermissions.ShadowActivity;
import com.apt7.rxpermissions.SharedPrefHandler;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PermissionObservable {
    private static PermissionsIgnoreList permissionsIgnoreList;
    private static PermissionObservable permissionObservable;
    private Map<String, PublishSubject<Permission>> publishSubjectHashMap = new HashMap<String, PublishSubject<Permission>>();
    private static SharedPrefHandler sharedPrefHandler;

    private PermissionObservable() {
    }

    public static PermissionObservable getInstance() {
        if (permissionObservable == null) {
            permissionObservable = new PermissionObservable();
            permissionsIgnoreList = PermissionsIgnoreList.getInstance();
            sharedPrefHandler = SharedPrefHandler.getInstance();
        }
        return permissionObservable;
    }

    public Observable<Permission> checkThePermissionStatus(final Context context, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return Observable.error((Throwable)new IllegalArgumentException("request/requestEach requires at least one input permission"));
        }
        if (context == null) {
            return Observable.error((Throwable)new NullPointerException("Context cant be null"));
        }
        return Observable.fromArray((Object[])permissions).flatMap((Function)new Function<String, Observable<Permission>>(){

            public Observable<Permission> apply(final String permission) throws Exception {
                return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Permission>(){

                    public void subscribe(ObservableEmitter<Permission> e) throws Exception {
                        e.onNext((Object)new Permission(permission, permissionsIgnoreList.validate(permission) ? PermissionObservable.this.checkPermission(context, permission) : 1));
                        e.onComplete();
                    }
                });
            }
        });
    }

    public Observable<Permission> request(final Context context, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return Observable.error((Throwable)new IllegalArgumentException("request/requestEach requires at least one input permission"));
        }
        if (context == null) {
            return Observable.error((Throwable)new NullPointerException("Context cant be null"));
        }
        return Observable.just(permissionsIgnoreList.validate(this.validate(context, permissions))).flatMap((Function)new Function<List<String>, Observable<Permission>>(){

            public Observable<Permission> apply(List<String> permissions) throws Exception {
                PermissionObservable.this.requestPermission(context, permissions.toArray(new String[permissions.size()]));
                return Observable.fromIterable(permissions).flatMap((Function)new Function<String, Observable<Permission>>(){

                    public Observable<Permission> apply(String permission) throws Exception {
                        return PermissionObservable.this.responseHolder(permission);
                    }
                });
            }
        });
    }

    public ObservableTransformer<Object, Permission> requestAsTransformer(final Context context, final String ... permissions) {
        this.checkForNull(context, permissions);
        return new ObservableTransformer<Object, Permission>(){

            public Observable<Permission> apply(Observable<Object> o) {
                return PermissionObservable.this.request(context, permissions);
            }
        };
    }

    private Observable<Permission> responseHolder(String permission) {
        if (!this.publishSubjectHashMap.containsKey(permission)) {
            return this.getJustNull();
        }
        return (Observable)this.publishSubjectHashMap.get(permission);
    }

    private Observable<Permission> getJustNull() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Permission>(){

            public void subscribe(ObservableEmitter<Permission> e) throws Exception {
                e.onNext((Object)new Permission("", 0));
            }
        });
    }

    private void requestPermission(Context context, String[] permissions) {
        for (String permission : permissions) {
            PublishSubject subject = this.publishSubjectHashMap.get(permission);
            if (subject != null) continue;
            subject = PublishSubject.create();
            this.publishSubjectHashMap.put(permission, (PublishSubject<Permission>)subject);
        }
        this.startShadowActivity(context, permissions);
    }

    private List<String> validate(Context context, String ... permissions) {
        ArrayList<String> requestList = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.getPermissionStatus(context, permissions).entrySet()) {
            if (entry.getValue() != 0) continue;
            requestList.add(entry.getKey());
        }
        return requestList;
    }

    private void startShadowActivity(Context context, String[] permissions) {
        if (permissions != null && permissions.length > 0) {
            Intent intent = new Intent(context, ShadowActivity.class);
            intent.putExtra("permissions", permissions);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    @TargetApi(value=23)
    private boolean isGranted(Context context, String permission) {
        return Build.VERSION.SDK_INT < 23 || context.checkSelfPermission(permission) == 0;
    }

    @TargetApi(value=23)
    private boolean isRevoked(Context context, String permission) {
        return Build.VERSION.SDK_INT < 23 || sharedPrefHandler.getPref(context, permission);
    }

    private Map<String, Integer> getPermissionStatus(Context context, String ... permissions) {
        HashMap<String, Integer> permissionMap = new HashMap<String, Integer>();
        for (String permission : permissions) {
            permissionMap.put(permission, this.checkPermission(context, permission));
        }
        return permissionMap;
    }

    private void checkForNull(Context context, String ... permissions) {
        if (context == null) {
            throw new NullPointerException("Context cant be null");
        }
        if (permissions == null) {
            throw new NullPointerException("Permission cant be null");
        }
    }

    private int checkPermission(Context context, String permission) {
        if (this.isGranted(context, permission)) {
            sharedPrefHandler.resetPref(context, permission);
            return 1;
        }
        if (this.isRevoked(context, permission)) {
            return -1;
        }
        return 0;
    }

    void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 42) {
            int size = permissions.length;
            for (int i = 0; i < size; ++i) {
                boolean granted;
                PublishSubject<Permission> subject = this.publishSubjectHashMap.get(permissions[i]);
                if (subject == null) {
                    throw new IllegalStateException("onRequestPermissionsResult invoked but didn't find the corresponding permission request.");
                }
                this.publishSubjectHashMap.remove(permissions[i]);
                boolean bl = granted = grantResults[i] == 0;
                if (!granted && Build.VERSION.SDK_INT >= 23 && !activity.shouldShowRequestPermissionRationale(permissions[i])) {
                    sharedPrefHandler.setPref((Context)activity, permissions[i], true);
                }
                subject.onNext((Object)new Permission(permissions[i], granted ? 1 : 0));
                subject.onComplete();
            }
        }
    }
}

