/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.ControlCharacter;
import rst.pdfbox.layout.text.ControlCharacters;
import rst.pdfbox.layout.text.Indent;
import rst.pdfbox.layout.text.SpaceUnit;
import rst.pdfbox.layout.util.CompatibilityHelper;
import rst.pdfbox.layout.util.Enumerator;
import rst.pdfbox.layout.util.EnumeratorFactory;

public class IndentCharacters {
    public static ControlCharacters.ControlCharacterFactory INDENT_FACTORY = new IndentCharacterFactory();
    public static IndentCharacter UNINDENT_CHARACTER = new IndentCharacter("0", "0", "pt");

    public static void main(String[] args) {
        Pattern PATTERN = Pattern.compile("^-(!)|^([ ]*)-(-)(\\{(\\d*)(em|pt)?\\})?|^([ ]*)-(\\+)(\\{(.)?:(\\d*)(em|pt)?\\})?|^([ ]*)-(#)(\\{((?!:).)?(.+)?:((\\d*))((em|pt))?\\})?");
        Matcher matcher = PATTERN.matcher("  -#{d:3em}");
        System.out.println("matches: " + matcher.find());
        if (!matcher.matches()) {
            System.err.println("exit");
            return;
        }
        System.out.println("start: " + matcher.start());
        System.out.println("end: " + matcher.end());
        System.out.println("groups: " + matcher.groupCount());
        for (int i = 0; i < matcher.groupCount(); ++i) {
            System.out.println("group " + i + ": '" + matcher.group(i) + "'");
        }
    }

    private static class IndentCharacterFactory
    implements ControlCharacters.ControlCharacterFactory {
        private static final Pattern PATTERN = Pattern.compile("^-(!)|^([ ]*)-(-)(\\{(\\d*)(em|pt)?\\})?|^([ ]*)-(\\+)(\\{(.+)?:(\\d*)(em|pt)?\\})?|^([ ]*)-(#)(\\{((?!:).)?(.+)?:((\\d*))((em|pt))?\\})?");
        private static final Pattern UNESCAPE_PATTERN = Pattern.compile("^\\\\([ ]*-[-|+|#])");
        private static final String TO_ESCAPE = "--";

        private IndentCharacterFactory() {
        }

        @Override
        public ControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            if ("!".equals(matcher.group(1))) {
                return UNINDENT_CHARACTER;
            }
            if ("-".equals(matcher.group(3))) {
                return new IndentCharacter(matcher.group(2), matcher.group(5), matcher.group(6));
            }
            if ("+".equals(matcher.group(8))) {
                return new ListCharacter(matcher.group(7), matcher.group(11), matcher.group(12), matcher.group(10));
            }
            if ("#".equals(matcher.group(14))) {
                return new EnumerationCharacter(matcher.group(13), matcher.group(18), matcher.group(20), matcher.group(16), matcher.group(17));
            }
            throw new IllegalArgumentException("unkown indentation " + text);
        }

        @Override
        public Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public String unescape(String text) {
            Matcher matcher = UNESCAPE_PATTERN.matcher(text);
            if (!matcher.find()) {
                return text;
            }
            return matcher.group(1) + text.substring(matcher.end());
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return true;
        }
    }

    public static class EnumerationCharacter
    extends IndentCharacter {
        protected Enumerator enumerator;
        protected String separator;

        protected EnumerationCharacter(String level, String indentWidth, String indentUnit, String enumerationType, String separator) {
            super(level, indentWidth, indentUnit);
            if (enumerationType == null) {
                enumerationType = "1";
            }
            this.enumerator = EnumeratorFactory.createEnumerator(enumerationType);
            this.separator = separator != null ? separator : this.enumerator.getDefaultSeperator();
        }

        @Override
        protected String nextLabel() {
            String next = this.enumerator.next();
            StringBuilder bob = new StringBuilder(next.length() + this.separator.length() + 1);
            bob.append(next);
            bob.append(this.separator);
            if (!this.separator.endsWith(" ")) {
                bob.append(" ");
            }
            return bob.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.enumerator == null ? 0 : this.enumerator.hashCode());
            result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumerationCharacter other = (EnumerationCharacter)obj;
            if (this.enumerator == null) {
                if (other.enumerator != null) {
                    return false;
                }
            } else {
                if (other.enumerator == null) {
                    return false;
                }
                if (!this.enumerator.getClass().equals(other.enumerator.getClass())) {
                    return false;
                }
            }
            return !(this.separator == null ? other.separator != null : !this.separator.equals(other.separator));
        }
    }

    public static class ListCharacter
    extends IndentCharacter {
        protected String label;

        protected ListCharacter(String level, String indentWidth, String indentUnit, String bulletCharacter) {
            super(level, indentWidth, indentUnit);
            if (bulletCharacter != null) {
                this.label = bulletCharacter;
                if (!this.label.endsWith(" ")) {
                    this.label = this.label + " ";
                }
            } else {
                this.label = CompatibilityHelper.getBulletCharacter(this.getLevel()) + " ";
            }
        }

        @Override
        protected String nextLabel() {
            return this.label;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListCharacter other = (ListCharacter)obj;
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }
    }

    public static class IndentCharacter
    extends ControlCharacter {
        protected int level = 1;
        protected float indentWidth = 4.0f;
        protected SpaceUnit indentUnit = SpaceUnit.em;

        public IndentCharacter(String level, String indentWidth, String indentUnit) {
            super("INDENT", "--");
            try {
                this.level = level == null ? 0 : level.length() + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.indentUnit = indentUnit == null ? SpaceUnit.em : SpaceUnit.valueOf(indentUnit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            float defaultIndent = this.indentUnit == SpaceUnit.em ? 4.0f : 10.0f;
            try {
                this.indentWidth = indentWidth == null ? defaultIndent : (float)Integer.parseInt(indentWidth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public int getLevel() {
            return this.level;
        }

        protected String nextLabel() {
            return "";
        }

        public Indent createNewIndent(float fontSize, PDFont font, Color color) throws IOException {
            return new Indent(this.nextLabel(), (float)this.level * this.indentWidth, this.indentUnit, fontSize, font, Alignment.Right, color);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indentUnit == null ? 0 : this.indentUnit.hashCode());
            result = 31 * result + Float.floatToIntBits(this.indentWidth);
            result = 31 * result + this.level;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndentCharacter other = (IndentCharacter)obj;
            if (this.indentUnit != other.indentUnit) {
                return false;
            }
            if (Float.floatToIntBits(this.indentWidth) != Float.floatToIntBits(other.indentWidth)) {
                return false;
            }
            return this.level == other.level;
        }
    }
}

