/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import org.apache.pdfbox.pdmodel.common.PDRectangle;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.Orientation;
import rst.pdfbox.layout.text.Constants;

public class PageFormat
implements Element {
    private final float marginLeft;
    private final float marginRight;
    private final float marginTop;
    private final float marginBottom;
    private final PDRectangle mediaBox;
    private final Orientation orientation;
    private final int rotation;

    public PageFormat() {
        this(Constants.A4);
    }

    public PageFormat(PDRectangle mediaBox) {
        this(mediaBox, Orientation.Portrait);
    }

    public PageFormat(PDRectangle mediaBox, Orientation orientation) {
        this(mediaBox, orientation, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public PageFormat(PDRectangle mediaBox, Orientation orientation, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this(mediaBox, orientation, 0, marginLeft, marginRight, marginTop, marginBottom);
    }

    public PageFormat(PDRectangle mediaBox, Orientation orientation, int rotation, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.mediaBox = mediaBox;
        this.orientation = orientation;
        this.rotation = rotation;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    public Orientation getOrientation() {
        if (this.orientation != null) {
            return this.orientation;
        }
        if (this.getMediaBox().getWidth() > this.getMediaBox().getHeight()) {
            return Orientation.Landscape;
        }
        return Orientation.Portrait;
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public static PageFormatBuilder with() {
        return new PageFormatBuilder();
    }

    public static class PageFormatBuilder {
        private float marginLeft;
        private float marginRight;
        private float marginTop;
        private float marginBottom;
        private PDRectangle mediaBox = Constants.A4;
        private Orientation orientation;
        private int rotation;

        protected PageFormatBuilder() {
        }

        public PageFormat build() {
            return new PageFormat(this.mediaBox, this.orientation, this.rotation, this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
        }

        public PageFormatBuilder marginLeft(float marginLeft) {
            this.marginLeft = marginLeft;
            return this;
        }

        public PageFormatBuilder marginRight(float marginRight) {
            this.marginRight = marginRight;
            return this;
        }

        public PageFormatBuilder marginTop(float marginTop) {
            this.marginTop = marginTop;
            return this;
        }

        public PageFormatBuilder marginBottom(float marginBottom) {
            this.marginBottom = marginBottom;
            return this;
        }

        public PageFormatBuilder margins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
            this.marginLeft = marginLeft;
            this.marginRight = marginRight;
            this.marginTop = marginTop;
            this.marginBottom = marginBottom;
            return this;
        }

        public PageFormatBuilder mediaBox(PDRectangle mediaBox) {
            this.mediaBox = mediaBox;
            return this;
        }

        public PageFormatBuilder A0() {
            this.mediaBox = Constants.A0;
            return this;
        }

        public PageFormatBuilder A1() {
            this.mediaBox = Constants.A1;
            return this;
        }

        public PageFormatBuilder A2() {
            this.mediaBox = Constants.A2;
            return this;
        }

        public PageFormatBuilder A3() {
            this.mediaBox = Constants.A3;
            return this;
        }

        public PageFormatBuilder A4() {
            this.mediaBox = Constants.A4;
            return this;
        }

        public PageFormatBuilder A5() {
            this.mediaBox = Constants.A5;
            return this;
        }

        public PageFormatBuilder A6() {
            this.mediaBox = Constants.A6;
            return this;
        }

        public PageFormatBuilder letter() {
            this.mediaBox = Constants.Letter;
            return this;
        }

        public PageFormatBuilder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        public PageFormatBuilder portrait() {
            this.orientation = Orientation.Portrait;
            return this;
        }

        public PageFormatBuilder landscape() {
            this.orientation = Orientation.Landscape;
            return this;
        }

        public PageFormatBuilder rotation(int angle) {
            this.rotation = angle;
            return this;
        }
    }
}

