/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.BaseFont;
import rst.pdfbox.layout.text.ControlCharacter;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFlow;

public class TextFlowUtil {
    public static TextFlow createTextFlow(String text, float fontSize, PDFont font) {
        Iterable<CharSequence> parts = TextFlowUtil.fromPlainText(text);
        return TextFlowUtil.createTextFlow(parts, fontSize, font, font, font, font);
    }

    public static TextFlow createTextFlowFromMarkup(String markup, float fontSize, BaseFont baseFont) {
        return TextFlowUtil.createTextFlowFromMarkup(markup, fontSize, baseFont.getPlainFont(), baseFont.getBoldFont(), baseFont.getItalicFont(), baseFont.getBoldItalicFont());
    }

    public static TextFlow createTextFlowFromMarkup(String markup, float fontSize, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) {
        Iterable<CharSequence> parts = TextFlowUtil.fromMarkup(markup);
        return TextFlowUtil.createTextFlow(parts, fontSize, plainFont, boldFont, italicFont, boldItalicFont);
    }

    protected static TextFlow createTextFlow(Iterable<CharSequence> parts, float fontSize, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) {
        TextFlow result = new TextFlow();
        boolean bold = false;
        boolean italic = false;
        for (CharSequence fragment : parts) {
            if (fragment instanceof ControlCharacter) {
                if (fragment == ControlCharacter.NEWLINE) {
                    result.add(new NewLine(fontSize));
                }
                if (fragment == ControlCharacter.BOLD) {
                    boolean bl = bold = !bold;
                }
                if (fragment != ControlCharacter.ITALIC) continue;
                italic = !italic;
                continue;
            }
            PDFont font = TextFlowUtil.getFont(bold, italic, plainFont, boldFont, italicFont, boldItalicFont);
            StyledText styledText = new StyledText(fragment.toString(), fontSize, font);
            result.add(styledText);
        }
        return result;
    }

    protected static PDFont getFont(boolean bold, boolean italic, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) {
        PDFont font = plainFont;
        if (bold && !italic) {
            font = boldFont;
        } else if (!bold && italic) {
            font = italicFont;
        } else if (bold && italic) {
            font = boldItalicFont;
        }
        return font;
    }

    public static Iterable<CharSequence> fromPlainText(CharSequence text) {
        return TextFlowUtil.fromPlainText(Collections.singleton(text));
    }

    public static Iterable<CharSequence> fromPlainText(Iterable<CharSequence> text) {
        return TextFlowUtil.splitByControlCharacter(ControlCharacter.NEWLINE, text, true);
    }

    public static Iterable<CharSequence> fromMarkup(CharSequence markup) {
        return TextFlowUtil.fromMarkup(Collections.singleton(markup));
    }

    public static Iterable<CharSequence> fromMarkup(Iterable<CharSequence> markup) {
        Iterable<CharSequence> text = markup;
        text = TextFlowUtil.splitByControlCharacter(ControlCharacter.BOLD, text, false);
        text = TextFlowUtil.splitByControlCharacter(ControlCharacter.ITALIC, text, false);
        text = TextFlowUtil.splitByControlCharacter(ControlCharacter.NEWLINE, text, true);
        return text;
    }

    protected static Iterable<CharSequence> splitByControlCharacter(ControlCharacter ctrl, Iterable<CharSequence> markup, boolean unescapeBackslash) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence current : markup) {
            if (current instanceof String) {
                String string = (String)current;
                String[] parts = ctrl.getPattern().split(string, -1);
                for (int i = 0; i < parts.length; ++i) {
                    if (i > 0) {
                        result.add(ctrl);
                    }
                    if (parts[i].isEmpty()) continue;
                    String unescaped = ctrl.unescape(parts[i]);
                    if (unescapeBackslash) {
                        unescaped = ControlCharacter.unescapeBackslash(unescaped);
                    }
                    result.add(unescaped);
                }
                continue;
            }
            result.add(current);
        }
        return result;
    }
}

