/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.util.regex.Pattern;

public class ControlCharacter
implements CharSequence {
    public static final ControlCharacter BOLD = new ControlCharacter("BOLD", "(?<!\\\\)(\\\\\\\\)*\\*", "*");
    public static final ControlCharacter ITALIC = new ControlCharacter("ITALIC", "(?<!\\\\)(\\\\\\\\)*_", "_");
    public static final ControlCharacter NEWLINE = new ControlCharacter("NEWLINE", "(\r\n|\n)", null);
    private String description;
    private Pattern pattern;
    private String charaterToEscape;

    public static String unescapeBackslash(String text) {
        return text.replaceAll(Pattern.quote("\\\\"), "\\\\");
    }

    private ControlCharacter(String description, String regex, String charaterToEscape) {
        this.description = description;
        this.pattern = Pattern.compile(regex);
        this.charaterToEscape = charaterToEscape;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getCharacterToEscape() {
        return this.charaterToEscape;
    }

    public boolean mustEscape() {
        return this.getCharacterToEscape() != null;
    }

    public String escape(String text) {
        if (!this.mustEscape()) {
            return text;
        }
        return text.replaceAll(Pattern.quote(this.getCharacterToEscape()), "\\" + this.getCharacterToEscape());
    }

    public String unescape(String text) {
        if (!this.mustEscape()) {
            return text;
        }
        return text.replaceAll("\\\\" + Pattern.quote(this.getCharacterToEscape()), this.getCharacterToEscape());
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public char charAt(int index) {
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return null;
    }

    @Override
    public String toString() {
        return this.description;
    }
}

