/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements.render;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.Cutter;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Document;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.VerticalSpacer;
import rst.pdfbox.layout.elements.render.Layout;
import rst.pdfbox.layout.elements.render.LayoutHint;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.VerticalLayoutHint;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.WidthRespecting;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class VerticalLayout
implements Layout {
    @Override
    public void render(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        if (drawable.getAbsolutePosition() != null) {
            this.renderAbsolute(renderContext, drawable, layoutHint, drawable.getAbsolutePosition());
        } else {
            this.renderReleative(renderContext, drawable, layoutHint);
        }
    }

    protected void renderAbsolute(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint, Position position) throws IOException {
        PDPageContentStream contentStream = renderContext.getContentStream();
        drawable.draw(contentStream, position);
    }

    protected void renderReleative(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        VerticalLayoutHint verticalLayoutHint = null;
        if (layoutHint instanceof VerticalLayoutHint && (verticalLayoutHint = (VerticalLayoutHint)layoutHint).getMarginTop() > 0.0f) {
            this.layoutAndDrawReleative(renderContext, new VerticalSpacer(verticalLayoutHint.getMarginTop()), verticalLayoutHint);
        }
        this.layoutAndDrawReleative(renderContext, drawable, verticalLayoutHint);
        if (verticalLayoutHint != null && verticalLayoutHint.getMarginBottom() > 0.0f) {
            this.layoutAndDrawReleative(renderContext, new VerticalSpacer(verticalLayoutHint.getMarginBottom()), verticalLayoutHint);
        }
    }

    protected void layoutAndDrawReleative(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        WidthRespecting flowing;
        float targetWidth = renderContext.getWidth();
        boolean movePosition = true;
        VerticalLayoutHint verticalLayoutHint = null;
        if (layoutHint instanceof VerticalLayoutHint) {
            verticalLayoutHint = (VerticalLayoutHint)layoutHint;
            targetWidth -= verticalLayoutHint.getMarginLeft();
            targetWidth -= verticalLayoutHint.getMarginRight();
            movePosition = !verticalLayoutHint.isResetY();
        }
        float oldMaxWidth = -1.0f;
        if (drawable instanceof WidthRespecting && (oldMaxWidth = (flowing = (WidthRespecting)((Object)drawable)).getMaxWidth()) < 0.0f) {
            flowing.setMaxWidth(targetWidth);
        }
        Drawable drawablePart = drawable;
        while (renderContext.getRemainingHeight() < drawablePart.getHeight()) {
            Dividable dividable = null;
            dividable = drawablePart instanceof Dividable ? (Dividable)((Object)drawablePart) : new Cutter(drawablePart);
            Dividable.Divided divided = dividable.divide(renderContext.getRemainingHeight(), renderContext.getHeight());
            this.drawReletivePartAndMovePosition(renderContext, divided.getFirst(), layoutHint, true);
            renderContext.newPage();
            drawablePart = divided.getTail();
        }
        this.drawReletivePartAndMovePosition(renderContext, drawablePart, layoutHint, movePosition);
        if (drawable instanceof WidthRespecting && oldMaxWidth < 0.0f) {
            ((WidthRespecting)((Object)drawable)).setMaxWidth(oldMaxWidth);
        }
    }

    protected void drawReletivePartAndMovePosition(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint, boolean movePosition) throws IOException {
        PDPageContentStream contentStream = renderContext.getContentStream();
        Document document = renderContext.getDocument();
        float offsetX = 0.0f;
        if (layoutHint instanceof VerticalLayoutHint) {
            VerticalLayoutHint verticalLayoutHint = (VerticalLayoutHint)layoutHint;
            Alignment alignment = verticalLayoutHint.getAlignment();
            float horizontalExtraSpace = renderContext.getWidth() - drawable.getWidth();
            switch (alignment) {
                case Right: {
                    offsetX = horizontalExtraSpace - verticalLayoutHint.getMarginRight();
                    break;
                }
                case Center: {
                    offsetX = horizontalExtraSpace / 2.0f;
                    break;
                }
                default: {
                    offsetX = verticalLayoutHint.getMarginLeft();
                }
            }
        }
        contentStream.saveGraphicsState();
        contentStream.addRect(document.getMarginLeft(), document.getMarginBottom(), renderContext.getWidth(), renderContext.getHeight());
        CompatibilityHelper.clip(contentStream);
        drawable.draw(contentStream, renderContext.getCurrentPosition().add(offsetX, 0.0f));
        contentStream.restoreGraphicsState();
        if (movePosition) {
            renderContext.movePositionBy(0.0f, -drawable.getHeight());
        }
    }
}

