/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.spotlight.effet;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.view.animation.LinearInterpolator;
import androidx.annotation.ColorInt;
import com.takusemba.spotlight.effet.Effect;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/takusemba/spotlight/effet/FlickerEffect;", "Lcom/takusemba/spotlight/effet/Effect;", "radius", "", "color", "", "duration", "", "interpolator", "Landroid/animation/TimeInterpolator;", "repeatMode", "(FIJLandroid/animation/TimeInterpolator;I)V", "getDuration", "()J", "getInterpolator", "()Landroid/animation/TimeInterpolator;", "getRepeatMode", "()I", "draw", "", "canvas", "Landroid/graphics/Canvas;", "point", "Landroid/graphics/PointF;", "value", "paint", "Landroid/graphics/Paint;", "Companion", "spotlight_release"})
public final class FlickerEffect
implements Effect {
    private final float radius;
    private final int color;
    private final long duration;
    @NotNull
    private final TimeInterpolator interpolator;
    private final int repeatMode;
    private static final long DEFAULT_DURATION;
    @NotNull
    private static final LinearInterpolator DEFAULT_INTERPOLATOR;
    public static final int DEFAULT_REPEAT_MODE = 2;
    @NotNull
    public static final Companion Companion;

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull PointF point, float value, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        paint.setColor(this.color);
        paint.setAlpha((int)(value * (float)255));
        canvas.drawCircle(point.x, point.y, this.radius, paint);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public TimeInterpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public int getRepeatMode() {
        return this.repeatMode;
    }

    @JvmOverloads
    public FlickerEffect(float radius, @ColorInt int color, long duration, @NotNull TimeInterpolator interpolator, int repeatMode) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.radius = radius;
        this.color = color;
        this.duration = duration;
        this.interpolator = interpolator;
        this.repeatMode = repeatMode;
    }

    public /* synthetic */ FlickerEffect(float f, int n, long l, TimeInterpolator timeInterpolator, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            l = DEFAULT_DURATION;
        }
        if ((n3 & 8) != 0) {
            timeInterpolator = (TimeInterpolator)DEFAULT_INTERPOLATOR;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 2;
        }
        this(f, n, l, timeInterpolator, n2);
    }

    @JvmOverloads
    public FlickerEffect(float radius, @ColorInt int color, long duration, @NotNull TimeInterpolator interpolator) {
        this(radius, color, duration, interpolator, 0, 16, null);
    }

    @JvmOverloads
    public FlickerEffect(float radius, @ColorInt int color, long duration) {
        this(radius, color, duration, null, 0, 24, null);
    }

    @JvmOverloads
    public FlickerEffect(float radius, @ColorInt int color) {
        this(radius, color, 0L, null, 0, 28, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_DURATION = TimeUnit.MILLISECONDS.toMillis(1000L);
        DEFAULT_INTERPOLATOR = new LinearInterpolator();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/takusemba/spotlight/effet/FlickerEffect$Companion;", "", "()V", "DEFAULT_DURATION", "", "getDEFAULT_DURATION", "()J", "DEFAULT_INTERPOLATOR", "Landroid/view/animation/LinearInterpolator;", "getDEFAULT_INTERPOLATOR", "()Landroid/view/animation/LinearInterpolator;", "DEFAULT_REPEAT_MODE", "", "spotlight_release"})
    public static final class Companion {
        public final long getDEFAULT_DURATION() {
            return DEFAULT_DURATION;
        }

        @NotNull
        public final LinearInterpolator getDEFAULT_INTERPOLATOR() {
            return DEFAULT_INTERPOLATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

