/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.utils;

import android.widget.EditText;
import java.io.Serializable;

public class Selection
implements Serializable {
    private static final long serialVersionUID = 8415527424030047664L;
    private int mStart;
    private int mEnd;

    public Selection(int start, int end) {
        this.mStart = start;
        this.mEnd = end;
        if (this.mStart > this.mEnd) {
            int temp = this.mEnd;
            this.mEnd = this.mStart;
            this.mStart = temp;
        }
    }

    public Selection(EditText editor) {
        this(editor.getSelectionStart(), editor.getSelectionEnd());
    }

    public int start() {
        return this.mStart;
    }

    public int end() {
        return this.mEnd;
    }

    public boolean isEmpty() {
        return this.mStart == this.mEnd;
    }

    public Selection offset(int offsetLeft, int offsetRight) {
        this.mStart = Math.max(0, this.mStart - offsetLeft);
        this.mEnd += offsetRight;
        return this;
    }

    public String toString() {
        return "[" + this.mStart + ", " + this.mEnd + "]";
    }
}

