/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.toolbar.spinner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.toolbar.spinner.SpinnerItem;
import com.onegravity.rteditor.toolbar.spinner.SpinnerItems;
import java.util.List;

public class SpinnerItemAdapter<T extends SpinnerItem>
extends BaseAdapter
implements SpinnerItem.OnChangedListener {
    private final int mSpinnerId;
    private final int mSpinnerItemId;
    private int mSelectedItem;
    private final List<T> mItems;
    private final LayoutInflater mInflater;
    private ViewGroup mParent;
    private String mSpinnerTitle;
    private final Handler mHandler;
    private final SparseArray<View> mViewCache = new SparseArray();
    private final int mSelectedBackgroundId;

    public SpinnerItemAdapter(Context context, SpinnerItems<T> spinnerItems, int spinnerId, int spinnerItemId) {
        this.mSelectedItem = spinnerItems.getSelectedItem();
        this.mItems = spinnerItems.getItems();
        this.mInflater = LayoutInflater.from((Context)context);
        this.mHandler = new Handler();
        this.mSpinnerId = spinnerId;
        this.mSpinnerItemId = spinnerItemId;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.rte_ToolbarSpinnerSelectedColor, typedValue, true);
        this.mSelectedBackgroundId = typedValue.resourceId;
    }

    @SuppressLint(value={"ViewHolder"})
    public final View getView(int position, View convertView, ViewGroup parent) {
        View spinnerView = this.mInflater.inflate(this.mSpinnerId, parent, false);
        this.mParent = parent;
        TextView spinnerTitleView = (TextView)spinnerView.findViewById(R.id.title);
        this.updateSpinnerTitle(spinnerTitleView);
        return spinnerView;
    }

    @SuppressLint(value={"InlinedApi"})
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        SpinnerItem spinnerItem = (SpinnerItem)this.mItems.get(position);
        spinnerItem.setOnChangedListener(this, position);
        View spinnerItemView = this.mInflater.inflate(this.mSpinnerItemId, parent, false);
        int key = (position << 16) + this.getItemViewType(position);
        this.mViewCache.put(key, (Object)spinnerItemView);
        this.bindView(position, spinnerItemView, spinnerItem);
        return spinnerItemView;
    }

    @Override
    public void onSpinnerItemChanged(Object tag) {
        this.mHandler.post(() -> {
            int position = (Integer)tag;
            int key = (position << 16) + this.getItemViewType(position);
            SpinnerItem spinnerItem = (SpinnerItem)this.mItems.get(position);
            View spinnerItemView = (View)this.mViewCache.get(key);
            if (spinnerItemView != null) {
                this.bindView(position, spinnerItemView, spinnerItem);
            }
        });
    }

    private void bindView(int position, View spinnerItemView, SpinnerItem spinnerItem) {
        TextView nameView = (TextView)spinnerItemView.findViewById(R.id.spinner_name);
        spinnerItem.formatNameView(nameView);
        View colorView = spinnerItemView.findViewById(R.id.spinner_color);
        spinnerItem.formatColorView(colorView);
        View textContainer = spinnerItemView.findViewById(R.id.chip_pacemaker);
        textContainer = textContainer == null ? nameView : textContainer;
        textContainer.setBackgroundResource(position == this.mSelectedItem ? this.mSelectedBackgroundId : 17170445);
    }

    public void setSelectedItem(int position) {
        this.mSelectedItem = position;
    }

    public int getSelectedItem() {
        return this.mSelectedItem;
    }

    public void updateSpinnerTitle(String title) {
        this.mSpinnerTitle = title;
        if (this.mParent != null) {
            try {
                TextView spinnerTitleView = (TextView)this.mParent.getChildAt(0).findViewById(R.id.title);
                this.updateSpinnerTitle(spinnerTitleView);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateSpinnerTitle(TextView titleView) {
        if (titleView != null) {
            titleView.setText((CharSequence)this.mSpinnerTitle);
            titleView.setVisibility(this.mSpinnerTitle == null ? 8 : 0);
            titleView.setHorizontallyScrolling(true);
        }
    }

    public int getCount() {
        return this.mItems.size();
    }

    public T getItem(int position) {
        return (T)((SpinnerItem)this.mItems.get(position));
    }

    public int getViewTypeCount() {
        return 1;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean hasStableIds() {
        return false;
    }

    public long getItemId(int position) {
        return position;
    }
}

