/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.spans;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import com.onegravity.rteditor.fonts.RTTypeface;
import com.onegravity.rteditor.spans.RTSpan;

public class TypefaceSpan
extends android.text.style.TypefaceSpan
implements RTSpan<RTTypeface> {
    private final RTTypeface mTypeface;

    public TypefaceSpan(RTTypeface typeface) {
        super("");
        this.mTypeface = typeface;
    }

    public void updateDrawState(TextPaint paint) {
        this.applyCustomTypeFace((Paint)paint, this.mTypeface.getTypeface());
    }

    public void updateMeasureState(TextPaint paint) {
        this.applyCustomTypeFace((Paint)paint, this.mTypeface.getTypeface());
    }

    private void applyCustomTypeFace(Paint paint, Typeface tf) {
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int fake = oldStyle & ~tf.getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }

    @Override
    public RTTypeface getValue() {
        return this.mTypeface;
    }
}

