/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import com.onegravity.rteditor.spans.BaseListItemSpan;
import com.onegravity.rteditor.spans.RTParagraphSpan;
import com.onegravity.rteditor.spans.RTSpan;

public class BulletSpan
extends BaseListItemSpan
implements LeadingMarginSpan,
RTSpan<Boolean>,
RTParagraphSpan<Boolean> {
    private static Path sBulletPath = null;
    private final int mGapWidth;
    private final boolean mIgnoreSpan;

    public BulletSpan(int gapWidth, boolean isEmpty, boolean isFirst, boolean isLast) {
        this.mGapWidth = gapWidth;
        boolean bl = this.mIgnoreSpan = isEmpty && isLast && !isFirst;
        if (sBulletPath == null) {
            sBulletPath = new Path();
        }
    }

    private BulletSpan(int gapWidth, boolean ignoreSpan) {
        this.mGapWidth = gapWidth;
        this.mIgnoreSpan = ignoreSpan;
    }

    public int getLeadingMargin(boolean first) {
        return this.mIgnoreSpan ? 0 : this.mGapWidth;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
        Spanned spanned = (Spanned)text;
        if (!this.mIgnoreSpan && spanned.getSpanStart((Object)this) == start) {
            Paint.Style oldStyle = p.getStyle();
            p.setStyle(Paint.Style.FILL);
            int size = Math.max(Math.round(this.determineTextSize(spanned, start, end, p.getTextSize()) / 9.0f), 4);
            this.draw(c, p, x, dir, top, bottom, size);
            p.setStyle(oldStyle);
        }
    }

    private void draw(Canvas c, Paint p, int x, int dir, int top, int bottom, int size) {
        sBulletPath.reset();
        sBulletPath.addCircle(0.0f, 0.0f, (float)size, Path.Direction.CW);
        c.save();
        c.translate((float)(x + dir * size), (float)(top + bottom) / 2.0f);
        c.drawPath(sBulletPath, p);
        c.restore();
    }

    @Override
    public Boolean getValue() {
        return Boolean.TRUE;
    }

    public BulletSpan createClone() {
        return new BulletSpan(this.mGapWidth, this.mIgnoreSpan);
    }
}

