/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.crop;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.onegravity.rteditor.R;

class HighlightView {
    private static final String TAG = "HighlightView";
    View mContext;
    public static final int GROW_NONE = 1;
    public static final int GROW_LEFT_EDGE = 2;
    public static final int GROW_RIGHT_EDGE = 4;
    public static final int GROW_TOP_EDGE = 8;
    public static final int GROW_BOTTOM_EDGE = 16;
    public static final int MOVE = 32;
    boolean mIsFocused;
    boolean mHidden;
    private ModifyMode mMode = ModifyMode.None;
    Rect mDrawRect;
    private RectF mImageRect;
    RectF mCropRect;
    Matrix mMatrix;
    private boolean mMaintainAspectRatio = false;
    private float mInitialAspectRatio;
    private boolean mCircle = false;
    private Drawable mResizeDrawableWidth;
    private Drawable mResizeDrawableHeight;
    private Drawable mResizeDrawableDiagonal;
    private final Paint mFocusPaint = new Paint();
    private final Paint mNoFocusPaint = new Paint();
    private final Paint mOutlinePaint = new Paint();

    public HighlightView(View ctx) {
        this.mContext = ctx;
    }

    private void init() {
        Resources resources = this.mContext.getResources();
        this.mResizeDrawableWidth = resources.getDrawable(R.drawable.camera_crop_width);
        this.mResizeDrawableHeight = resources.getDrawable(R.drawable.camera_crop_height);
        this.mResizeDrawableDiagonal = resources.getDrawable(R.drawable.indicator_autocrop);
    }

    public boolean hasFocus() {
        return this.mIsFocused;
    }

    public void setFocus(boolean f) {
        this.mIsFocused = f;
    }

    public void setHidden(boolean hidden) {
        this.mHidden = hidden;
    }

    protected void draw(Canvas canvas) {
        if (this.mHidden) {
            return;
        }
        Path path = new Path();
        if (!this.hasFocus()) {
            this.mOutlinePaint.setColor(-16777216);
            canvas.drawRect(this.mDrawRect, this.mOutlinePaint);
        } else {
            Rect viewDrawingRect = new Rect();
            this.mContext.getDrawingRect(viewDrawingRect);
            if (this.mCircle) {
                canvas.save();
                float width = this.mDrawRect.width();
                float height = this.mDrawRect.height();
                path.addCircle((float)this.mDrawRect.left + width / 2.0f, (float)this.mDrawRect.top + height / 2.0f, width / 2.0f, Path.Direction.CW);
                this.mOutlinePaint.setColor(-1112874);
                canvas.clipPath(path, Region.Op.DIFFERENCE);
                canvas.drawRect(viewDrawingRect, this.hasFocus() ? this.mFocusPaint : this.mNoFocusPaint);
                canvas.restore();
            } else {
                Rect rightRect;
                Rect leftRect;
                Rect bottomRect;
                Rect topRect = new Rect(viewDrawingRect.left, viewDrawingRect.top, viewDrawingRect.right, this.mDrawRect.top);
                if (topRect.width() > 0 && topRect.height() > 0) {
                    canvas.drawRect(topRect, this.hasFocus() ? this.mFocusPaint : this.mNoFocusPaint);
                }
                if ((bottomRect = new Rect(viewDrawingRect.left, this.mDrawRect.bottom, viewDrawingRect.right, viewDrawingRect.bottom)).width() > 0 && bottomRect.height() > 0) {
                    canvas.drawRect(bottomRect, this.hasFocus() ? this.mFocusPaint : this.mNoFocusPaint);
                }
                if ((leftRect = new Rect(viewDrawingRect.left, topRect.bottom, this.mDrawRect.left, bottomRect.top)).width() > 0 && leftRect.height() > 0) {
                    canvas.drawRect(leftRect, this.hasFocus() ? this.mFocusPaint : this.mNoFocusPaint);
                }
                if ((rightRect = new Rect(this.mDrawRect.right, topRect.bottom, viewDrawingRect.right, bottomRect.top)).width() > 0 && rightRect.height() > 0) {
                    canvas.drawRect(rightRect, this.hasFocus() ? this.mFocusPaint : this.mNoFocusPaint);
                }
                path.addRect(new RectF(this.mDrawRect), Path.Direction.CW);
                this.mOutlinePaint.setColor(-30208);
            }
            canvas.drawPath(path, this.mOutlinePaint);
            if (this.mMode == ModifyMode.Grow) {
                if (this.mCircle) {
                    int width = this.mResizeDrawableDiagonal.getIntrinsicWidth();
                    int height = this.mResizeDrawableDiagonal.getIntrinsicHeight();
                    int d = (int)Math.round(Math.cos(0.7853981633974483) * ((double)this.mDrawRect.width() / 2.0));
                    int x = this.mDrawRect.left + this.mDrawRect.width() / 2 + d - width / 2;
                    int y = this.mDrawRect.top + this.mDrawRect.height() / 2 - d - height / 2;
                    this.mResizeDrawableDiagonal.setBounds(x, y, x + this.mResizeDrawableDiagonal.getIntrinsicWidth(), y + this.mResizeDrawableDiagonal.getIntrinsicHeight());
                    this.mResizeDrawableDiagonal.draw(canvas);
                } else {
                    int left = this.mDrawRect.left + 1;
                    int right = this.mDrawRect.right + 1;
                    int top = this.mDrawRect.top + 4;
                    int bottom = this.mDrawRect.bottom + 3;
                    int widthWidth = this.mResizeDrawableWidth.getIntrinsicWidth() / 2;
                    int widthHeight = this.mResizeDrawableWidth.getIntrinsicHeight() / 2;
                    int heightHeight = this.mResizeDrawableHeight.getIntrinsicHeight() / 2;
                    int heightWidth = this.mResizeDrawableHeight.getIntrinsicWidth() / 2;
                    int xMiddle = this.mDrawRect.left + (this.mDrawRect.right - this.mDrawRect.left) / 2;
                    int yMiddle = this.mDrawRect.top + (this.mDrawRect.bottom - this.mDrawRect.top) / 2;
                    this.mResizeDrawableWidth.setBounds(left - widthWidth, yMiddle - widthHeight, left + widthWidth, yMiddle + widthHeight);
                    this.mResizeDrawableWidth.draw(canvas);
                    this.mResizeDrawableWidth.setBounds(right - widthWidth, yMiddle - widthHeight, right + widthWidth, yMiddle + widthHeight);
                    this.mResizeDrawableWidth.draw(canvas);
                    this.mResizeDrawableHeight.setBounds(xMiddle - heightWidth, top - heightHeight, xMiddle + heightWidth, top + heightHeight);
                    this.mResizeDrawableHeight.draw(canvas);
                    this.mResizeDrawableHeight.setBounds(xMiddle - heightWidth, bottom - heightHeight, xMiddle + heightWidth, bottom + heightHeight);
                    this.mResizeDrawableHeight.draw(canvas);
                }
            }
        }
    }

    public ModifyMode getMode() {
        return this.mMode;
    }

    public void setMode(ModifyMode mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.mContext.invalidate();
        }
    }

    public int getHit(float x, float y) {
        Rect r = this.computeLayout();
        float hysteresis = 20.0f;
        int retval = 1;
        if (this.mCircle) {
            int radius;
            float distY;
            float distX = x - (float)r.centerX();
            int distanceFromCenter = (int)Math.sqrt(distX * distX + (distY = y - (float)r.centerY()) * distY);
            int delta = distanceFromCenter - (radius = this.mDrawRect.width() / 2);
            retval = (float)Math.abs(delta) <= 20.0f ? (Math.abs(distY) > Math.abs(distX) ? (distY < 0.0f ? 8 : 16) : (distX < 0.0f ? 2 : 4)) : (distanceFromCenter < radius ? 32 : 1);
        } else {
            boolean horizCheck;
            boolean verticalCheck = y >= (float)r.top - 20.0f && y < (float)r.bottom + 20.0f;
            boolean bl = horizCheck = x >= (float)r.left - 20.0f && x < (float)r.right + 20.0f;
            if (Math.abs((float)r.left - x) < 20.0f && verticalCheck) {
                retval |= 2;
            }
            if (Math.abs((float)r.right - x) < 20.0f && verticalCheck) {
                retval |= 4;
            }
            if (Math.abs((float)r.top - y) < 20.0f && horizCheck) {
                retval |= 8;
            }
            if (Math.abs((float)r.bottom - y) < 20.0f && horizCheck) {
                retval |= 0x10;
            }
            if (retval == 1 && r.contains((int)x, (int)y)) {
                retval = 32;
            }
        }
        return retval;
    }

    void handleMotion(int edge, float dx, float dy) {
        Rect r = this.computeLayout();
        if (edge == 1) {
            return;
        }
        if (edge == 32) {
            this.moveBy(dx * (this.mCropRect.width() / (float)r.width()), dy * (this.mCropRect.height() / (float)r.height()));
        } else {
            if ((6 & edge) == 0) {
                dx = 0.0f;
            }
            if ((0x18 & edge) == 0) {
                dy = 0.0f;
            }
            float xDelta = dx * (this.mCropRect.width() / (float)r.width());
            float yDelta = dy * (this.mCropRect.height() / (float)r.height());
            this.growBy((float)((edge & 2) != 0 ? -1 : 1) * xDelta, (float)((edge & 8) != 0 ? -1 : 1) * yDelta);
        }
    }

    void moveBy(float dx, float dy) {
        Rect invalRect = new Rect(this.mDrawRect);
        this.mCropRect.offset(dx, dy);
        this.mCropRect.offset(Math.max(0.0f, this.mImageRect.left - this.mCropRect.left), Math.max(0.0f, this.mImageRect.top - this.mCropRect.top));
        this.mCropRect.offset(Math.min(0.0f, this.mImageRect.right - this.mCropRect.right), Math.min(0.0f, this.mImageRect.bottom - this.mCropRect.bottom));
        this.mDrawRect = this.computeLayout();
        invalRect.union(this.mDrawRect);
        invalRect.inset(-10, -10);
        this.mContext.invalidate(invalRect);
    }

    void growBy(float dx, float dy) {
        float heightCap;
        float adjustment;
        if (this.mMaintainAspectRatio) {
            if (dx != 0.0f) {
                dy = dx / this.mInitialAspectRatio;
            } else if (dy != 0.0f) {
                dx = dy * this.mInitialAspectRatio;
            }
        }
        RectF r = new RectF(this.mCropRect);
        if (dx > 0.0f && r.width() + 2.0f * dx > this.mImageRect.width()) {
            dx = adjustment = (this.mImageRect.width() - r.width()) / 2.0f;
            if (this.mMaintainAspectRatio) {
                dy = dx / this.mInitialAspectRatio;
            }
        }
        if (dy > 0.0f && r.height() + 2.0f * dy > this.mImageRect.height()) {
            dy = adjustment = (this.mImageRect.height() - r.height()) / 2.0f;
            if (this.mMaintainAspectRatio) {
                dx = dy * this.mInitialAspectRatio;
            }
        }
        r.inset(-dx, -dy);
        float widthCap = 25.0f;
        if (r.width() < 25.0f) {
            r.inset(-(25.0f - r.width()) / 2.0f, 0.0f);
        }
        float f = heightCap = this.mMaintainAspectRatio ? 25.0f / this.mInitialAspectRatio : 25.0f;
        if (r.height() < heightCap) {
            r.inset(0.0f, -(heightCap - r.height()) / 2.0f);
        }
        if (r.left < this.mImageRect.left) {
            r.offset(this.mImageRect.left - r.left, 0.0f);
        } else if (r.right > this.mImageRect.right) {
            r.offset(-(r.right - this.mImageRect.right), 0.0f);
        }
        if (r.top < this.mImageRect.top) {
            r.offset(0.0f, this.mImageRect.top - r.top);
        } else if (r.bottom > this.mImageRect.bottom) {
            r.offset(0.0f, -(r.bottom - this.mImageRect.bottom));
        }
        this.mCropRect.set(r);
        this.mDrawRect = this.computeLayout();
        this.mContext.invalidate();
    }

    public Rect getCropRect() {
        return new Rect((int)this.mCropRect.left, (int)this.mCropRect.top, (int)this.mCropRect.right, (int)this.mCropRect.bottom);
    }

    private Rect computeLayout() {
        RectF r = new RectF(this.mCropRect.left, this.mCropRect.top, this.mCropRect.right, this.mCropRect.bottom);
        this.mMatrix.mapRect(r);
        return new Rect(Math.round(r.left), Math.round(r.top), Math.round(r.right), Math.round(r.bottom));
    }

    public void invalidate() {
        this.mDrawRect = this.computeLayout();
    }

    public void setup(Matrix m, Rect imageRect, RectF cropRect, boolean circle, boolean maintainAspectRatio) {
        if (circle) {
            maintainAspectRatio = true;
        }
        this.mMatrix = new Matrix(m);
        this.mCropRect = cropRect;
        this.mImageRect = new RectF(imageRect);
        this.mMaintainAspectRatio = maintainAspectRatio;
        this.mCircle = circle;
        this.mInitialAspectRatio = this.mCropRect.width() / this.mCropRect.height();
        this.mDrawRect = this.computeLayout();
        this.mFocusPaint.setARGB(125, 50, 50, 50);
        this.mNoFocusPaint.setARGB(125, 50, 50, 50);
        this.mOutlinePaint.setStrokeWidth(3.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
        this.mMode = ModifyMode.None;
        this.init();
    }

    static enum ModifyMode {
        None,
        Move,
        Grow;

    }
}

