/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Spannable;
import com.onegravity.rteditor.spans.RTParagraphSpan;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Paragraph;
import java.util.ArrayList;
import java.util.List;

class ParagraphSpanProcessor<V> {
    private final ArrayList<ParagraphSpan<V>> mParagraphSpans = new ArrayList();

    ParagraphSpanProcessor() {
    }

    void clear() {
        this.mParagraphSpans.clear();
    }

    void removeSpans(List<RTSpan<V>> spans, Paragraph paragraph) {
        for (RTSpan<V> span : spans) {
            this.removeSpan(span, paragraph);
        }
    }

    void removeSpan(RTSpan<V> span, Paragraph paragraph) {
        if (span instanceof RTParagraphSpan) {
            this.mParagraphSpans.add(new ParagraphSpan((RTParagraphSpan)((Object)span), paragraph, true));
        }
    }

    void addSpan(RTParagraphSpan<V> span, Paragraph paragraph) {
        this.mParagraphSpans.add(new ParagraphSpan<V>(span, paragraph, false));
    }

    void process(Spannable str) {
        for (ParagraphSpan<V> paragraphSpan : this.mParagraphSpans) {
            RTParagraphSpan span = paragraphSpan.mSpan;
            int paraStart = paragraphSpan.mParagraph.start();
            if (paragraphSpan.mRemove) {
                int spanStart = str.getSpanStart(span);
                if (spanStart > -1 && spanStart < paraStart) {
                    str.setSpan(span.createClone(), spanStart, paraStart, 34);
                }
                str.removeSpan(span);
                continue;
            }
            Paragraph paragraph = paragraphSpan.mParagraph;
            int paraEnd = paragraphSpan.mParagraph.end();
            int flags = paragraph.isLast() && paragraph.isEmpty() ? 18 : (paragraph.isLast() && paragraph.isFirst() ? 18 : (paragraph.isLast() ? 34 : 33));
            str.setSpan(span, paraStart, paraEnd, flags);
        }
    }

    private static class ParagraphSpan<V> {
        final RTParagraphSpan<V> mSpan;
        final Paragraph mParagraph;
        final boolean mRemove;

        ParagraphSpan(RTParagraphSpan<V> span, Paragraph paragraph, boolean remove) {
            this.mSpan = span;
            this.mParagraph = paragraph;
            this.mRemove = remove;
        }
    }
}

