/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.ParagraphEffect;
import com.onegravity.rteditor.effects.ParagraphSpanProcessor;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.spans.AlignmentSpan;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.List;

public class AlignmentEffect
extends ParagraphEffect<Layout.Alignment, AlignmentSpan> {
    private ParagraphSpanProcessor<Layout.Alignment> mSpans2Process = new ParagraphSpanProcessor();

    @Override
    public void applyToSelection(RTEditText editor, Selection selectedParagraphs, Layout.Alignment alignment) {
        Editable str = editor.getText();
        this.mSpans2Process.clear();
        ArrayList<Paragraph> paragraphs = editor.getParagraphs();
        int size = paragraphs.size();
        for (int i = 0; i < size; ++i) {
            Layout.Alignment newAlignment;
            boolean hasExistingSpans;
            Paragraph paragraph = paragraphs.get(i);
            List existingSpans = this.getSpans((Spannable)str, paragraph, SpanCollectMode.SPAN_FLAGS);
            this.mSpans2Process.removeSpans(existingSpans, paragraph);
            boolean bl = hasExistingSpans = !existingSpans.isEmpty();
            Object object = paragraph.isSelected(selectedParagraphs) ? alignment : (newAlignment = hasExistingSpans ? (Layout.Alignment)existingSpans.get(0).getValue() : null);
            if (newAlignment == null) continue;
            boolean isRTL = Helper.isRTL((CharSequence)str, paragraph.start(), paragraph.end());
            AlignmentSpan alignmentSpan = new AlignmentSpan(newAlignment, isRTL);
            this.mSpans2Process.addSpan(alignmentSpan, paragraph);
        }
        this.mSpans2Process.process((Spannable)str);
    }
}

